<?php
require_once __DIR__ . '/../auth/functions.php';
requireRole('admin');
require_once __DIR__ . '/../config/db_connect.php';

echo "<h3>Accreditation Requests Debug</h3>";

// Check all accreditation requests and their current status
$query = "SELECT 
    ar.request_id, 
    ar.student_id, 
    ar.course_id, 
    ar.status, 
    ar.request_date,
    ar.payment_status,
    ar.assignment_created_date,
    ar.documents_submitted_date,
    u.first_name,
    u.last_name,
    u.email,
    c.title as course_title,
    COUNT(ad.document_id) as document_count
FROM accreditation_requests ar
JOIN users u ON ar.student_id = u.user_id  
JOIN courses c ON ar.course_id = c.course_id
LEFT JOIN accreditation_documents ad ON ar.request_id = ad.request_id
GROUP BY ar.request_id
ORDER BY ar.request_date DESC";

$result = $conn->query($query);

echo "<h4>All Accreditation Requests:</h4>";
echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
echo "<tr>
    <th>Request ID</th>
    <th>Student</th>
    <th>Course</th>
    <th>Status</th>
    <th>Payment Status</th>
    <th>Documents Count</th>
    <th>Request Date</th>
    <th>Assignment Created</th>
    <th>Documents Submitted</th>
</tr>";

while ($row = $result->fetch_assoc()) {
    echo "<tr>";
    echo "<td>" . $row['request_id'] . "</td>";
    echo "<td>" . htmlspecialchars($row['first_name'] . ' ' . $row['last_name']) . "</td>";
    echo "<td>" . htmlspecialchars($row['course_title']) . "</td>";
    echo "<td><strong>" . $row['status'] . "</strong></td>";
    echo "<td>" . $row['payment_status'] . "</td>";
    echo "<td>" . $row['document_count'] . "</td>";
    echo "<td>" . $row['request_date'] . "</td>";
    echo "<td>" . ($row['assignment_created_date'] ?? 'NULL') . "</td>";
    echo "<td>" . ($row['documents_submitted_date'] ?? 'NULL') . "</td>";
    echo "</tr>";
}
echo "</table>";

// Check submitted documents for the latest request
$latest_query = "SELECT ar.request_id FROM accreditation_requests ar ORDER BY ar.request_date DESC LIMIT 1";
$latest_result = $conn->query($latest_query);
$latest_request = $latest_result->fetch_assoc();

if ($latest_request) {
    $request_id = $latest_request['request_id'];
    
    echo "<h4>Documents for Latest Request (ID: $request_id):</h4>";
    $doc_query = "SELECT * FROM accreditation_documents WHERE request_id = ? ORDER BY upload_date DESC";
    $doc_stmt = $conn->prepare($doc_query);
    $doc_stmt->bind_param("i", $request_id);
    $doc_stmt->execute();
    $doc_result = $doc_stmt->get_result();
    
    echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
    echo "<tr><th>Document Type</th><th>File Name</th><th>Upload Date</th><th>Status</th></tr>";
    while ($doc = $doc_result->fetch_assoc()) {
        echo "<tr>";
        echo "<td>" . $doc['document_type'] . "</td>";
        echo "<td>" . htmlspecialchars($doc['document_name']) . "</td>";
        echo "<td>" . $doc['upload_date'] . "</td>";
        echo "<td>" . $doc['verification_status'] . "</td>";
        echo "</tr>";
    }
    echo "</table>";
}

// Test the assessment management query directly
echo "<h4>Assessment Management Query Test:</h4>";
$test_query = "
    SELECT 
        COALESCE(sa.assessment_id, CONCAT('pending_', ar.request_id)) as assessment_id,
        COALESCE(sa.title, CONCAT('SITA Assignment - ', c.title)) as title,
        COALESCE(sa.status, CASE WHEN ar.status = 'assignment_created' THEN 'awaiting_completion' ELSE ar.status END) as status,
        ar.status as request_status,
        u.first_name, u.last_name, u.email,
        c.title as course_title
    FROM accreditation_requests ar
    JOIN users u ON ar.student_id = u.user_id
    JOIN courses c ON ar.course_id = c.course_id
    LEFT JOIN sita_assessments sa ON ar.request_id = sa.accreditation_request_id
    WHERE ar.status IN ('assignment_created', 'documents_submitted', 'assessment_passed', 'assessment_failed', 'certificate_issued')
       OR sa.assessment_id IS NOT NULL
    ORDER BY ar.request_date DESC";

$test_result = $conn->query($test_query);
echo "<p><strong>Query Results: " . $test_result->num_rows . " rows</strong></p>";

if ($test_result->num_rows > 0) {
    echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
    echo "<tr><th>Assessment ID</th><th>Title</th><th>Status</th><th>Request Status</th><th>Student</th></tr>";
    while ($row = $test_result->fetch_assoc()) {
        echo "<tr>";
        echo "<td>" . $row['assessment_id'] . "</td>";
        echo "<td>" . htmlspecialchars($row['title']) . "</td>";
        echo "<td><strong>" . $row['status'] . "</strong></td>";
        echo "<td>" . $row['request_status'] . "</td>";
        echo "<td>" . htmlspecialchars($row['first_name'] . ' ' . $row['last_name']) . "</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<p style='color: red;'><strong>No results found! This explains why the admin panel is empty.</strong></p>";
}
?>
