<?php
require_once '../includes/config.php';

echo "<h2>Referral Tables Debug Script</h2>";
echo "<style>table { border-collapse: collapse; width: 100%; margin: 20px 0; }
       th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
       th { background-color: #f2f2f2; }</style>";

// Check what referral-related tables exist
echo "<h3>1. Checking for Referral-Related Tables:</h3>";
$tables_query = "SHOW TABLES LIKE '%referral%'";
$result = $conn->query($tables_query);
if ($result && $result->num_rows > 0) {
    echo "<ul>";
    while ($row = $result->fetch_array()) {
        echo "<li><strong>" . $row[0] . "</strong></li>";
    }
    echo "</ul>";
} else {
    echo "<p>No tables found with 'referral' in the name.</p>";
}

// Check for commission-related tables
echo "<h3>2. Checking for Commission-Related Tables:</h3>";
$tables_query = "SHOW TABLES LIKE '%commission%'";
$result = $conn->query($tables_query);
if ($result && $result->num_rows > 0) {
    echo "<ul>";
    while ($row = $result->fetch_array()) {
        echo "<li><strong>" . $row[0] . "</strong></li>";
    }
    echo "</ul>";
} else {
    echo "<p>No tables found with 'commission' in the name.</p>";
}

// Check all tables to see what might contain referral data
echo "<h3>3. All Tables in Database:</h3>";
$all_tables = $conn->query("SHOW TABLES");
if ($all_tables) {
    echo "<ul>";
    while ($table = $all_tables->fetch_array()) {
        echo "<li>" . $table[0] . "</li>";
    }
    echo "</ul>";
}

// Check if referral_commissions table exists and show its structure
echo "<h3>4. Checking referral_commissions Table Structure:</h3>";
$check_table = $conn->query("SHOW TABLES LIKE 'referral_commissions'");
if ($check_table && $check_table->num_rows > 0) {
    echo "<p><strong>✓ referral_commissions table exists</strong></p>";
    
    // Show table structure
    echo "<h4>Table Structure:</h4>";
    $structure = $conn->query("DESCRIBE referral_commissions");
    if ($structure) {
        echo "<table><tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr>";
        while ($col = $structure->fetch_assoc()) {
            echo "<tr><td>" . $col['Field'] . "</td><td>" . $col['Type'] . "</td><td>" . $col['Null'] . "</td><td>" . $col['Key'] . "</td><td>" . $col['Default'] . "</td><td>" . $col['Extra'] . "</td></tr>";
        }
        echo "</table>";
    }
    
    // Show sample data
    echo "<h4>Sample Data (first 10 records):</h4>";
    $data = $conn->query("SELECT * FROM referral_commissions LIMIT 10");
    if ($data && $data->num_rows > 0) {
        echo "<table><tr>";
        $fields = $data->fetch_fields();
        foreach ($fields as $field) {
            echo "<th>" . $field->name . "</th>";
        }
        echo "</tr>";
        
        $data->data_seek(0); // Reset pointer
        while ($row = $data->fetch_assoc()) {
            echo "<tr>";
            foreach ($row as $value) {
                echo "<td>" . htmlspecialchars($value) . "</td>";
            }
            echo "</tr>";
        }
        echo "</table>";
    } else {
        echo "<p><strong>No data found in referral_commissions table</strong></p>";
    }
    
    // Show record count
    $count = $conn->query("SELECT COUNT(*) as total FROM referral_commissions");
    if ($count) {
        $total = $count->fetch_assoc();
        echo "<p><strong>Total records: " . $total['total'] . "</strong></p>";
    }
    
} else {
    echo "<p><strong>✗ referral_commissions table does not exist</strong></p>";
    
    // Look for alternative table names
    echo "<h4>Looking for similar tables:</h4>";
    $similar = $conn->query("SHOW TABLES WHERE Tables_in_" . DATABASE_NAME . " LIKE '%refer%' OR Tables_in_" . DATABASE_NAME . " LIKE '%commission%' OR Tables_in_" . DATABASE_NAME . " LIKE '%earning%'");
    if ($similar && $similar->num_rows > 0) {
        while ($table = $similar->fetch_array()) {
            echo "<p>Found: <strong>" . $table[0] . "</strong></p>";
            
            // Show structure of each found table
            $struct = $conn->query("DESCRIBE " . $table[0]);
            if ($struct) {
                echo "<table><tr><th>Field</th><th>Type</th></tr>";
                while ($col = $struct->fetch_assoc()) {
                    echo "<tr><td>" . $col['Field'] . "</td><td>" . $col['Type'] . "</td></tr>";
                }
                echo "</table>";
                
                // Show sample data
                $sample = $conn->query("SELECT * FROM " . $table[0] . " LIMIT 5");
                if ($sample && $sample->num_rows > 0) {
                    echo "<p>Sample data:</p><table><tr>";
                    $fields = $sample->fetch_fields();
                    foreach ($fields as $field) {
                        echo "<th>" . $field->name . "</th>";
                    }
                    echo "</tr>";
                    
                    $sample->data_seek(0);
                    while ($row = $sample->fetch_assoc()) {
                        echo "<tr>";
                        foreach ($row as $value) {
                            echo "<td>" . htmlspecialchars($value) . "</td>";
                        }
                        echo "</tr>";
                    }
                    echo "</table><br>";
                }
            }
        }
    }
}

// Check teacher_earnings table for referral data
echo "<h3>5. Checking teacher_earnings Table for Referral Data:</h3>";
$check_teacher_earnings = $conn->query("SHOW TABLES LIKE 'teacher_earnings'");
if ($check_teacher_earnings && $check_teacher_earnings->num_rows > 0) {
    echo "<p><strong>✓ teacher_earnings table exists</strong></p>";
    
    // Check if there are referral-related columns
    $te_structure = $conn->query("DESCRIBE teacher_earnings");
    echo "<h4>teacher_earnings Table Structure:</h4>";
    echo "<table><tr><th>Field</th><th>Type</th></tr>";
    while ($col = $te_structure->fetch_assoc()) {
        echo "<tr><td>" . $col['Field'] . "</td><td>" . $col['Type'] . "</td></tr>";
    }
    echo "</table>";
    
    // Look for referral-type transactions
    $referral_earnings = $conn->query("SELECT * FROM teacher_earnings WHERE transaction_type LIKE '%referral%' OR transaction_type LIKE '%commission%' LIMIT 10");
    if ($referral_earnings && $referral_earnings->num_rows > 0) {
        echo "<h4>Referral Earnings Found:</h4>";
        echo "<table><tr><th>ID</th><th>User ID</th><th>Amount</th><th>Transaction Type</th><th>Status</th><th>Created At</th></tr>";
        while ($row = $referral_earnings->fetch_assoc()) {
            echo "<tr><td>" . $row['earning_id'] . "</td><td>" . $row['user_id'] . "</td><td>R" . number_format($row['amount'], 2) . "</td><td>" . $row['transaction_type'] . "</td><td>" . $row['status'] . "</td><td>" . $row['created_at'] . "</td></tr>";
        }
        echo "</table>";
    } else {
        echo "<p>No referral-type transactions found in teacher_earnings</p>";
        
        // Show all transaction types
        $types = $conn->query("SELECT DISTINCT transaction_type FROM teacher_earnings");
        if ($types && $types->num_rows > 0) {
            echo "<p><strong>Available transaction types:</strong> ";
            $type_list = [];
            while ($type = $types->fetch_assoc()) {
                $type_list[] = $type['transaction_type'];
            }
            echo implode(', ', $type_list) . "</p>";
        }
    }
    
    // Show total count and sum
    $total_te = $conn->query("SELECT COUNT(*) as count, SUM(amount) as total_amount FROM teacher_earnings");
    if ($total_te) {
        $te_stats = $total_te->fetch_assoc();
        echo "<p><strong>Total teacher_earnings records: " . $te_stats['count'] . ", Total amount: R" . number_format($te_stats['total_amount'], 2) . "</strong></p>";
    }
}

echo "<h3>6. Examining teacher_referral_commissions Table:</h3>";
$check_trc = $conn->query("SHOW TABLES LIKE 'teacher_referral_commissions'");
if ($check_trc && $check_trc->num_rows > 0) {
    echo "<p><strong>✓ teacher_referral_commissions table exists</strong></p>";
    
    // Show table structure
    echo "<h4>Table Structure:</h4>";
    $trc_structure = $conn->query("DESCRIBE teacher_referral_commissions");
    if ($trc_structure) {
        echo "<table><tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th></tr>";
        while ($col = $trc_structure->fetch_assoc()) {
            echo "<tr><td>" . $col['Field'] . "</td><td>" . $col['Type'] . "</td><td>" . $col['Null'] . "</td><td>" . $col['Key'] . "</td><td>" . $col['Default'] . "</td></tr>";
        }
        echo "</table>";
    }
    
    // Show all data
    echo "<h4>All Data in teacher_referral_commissions:</h4>";
    $trc_data = $conn->query("SELECT * FROM teacher_referral_commissions");
    if ($trc_data && $trc_data->num_rows > 0) {
        echo "<table><tr>";
        $fields = $trc_data->fetch_fields();
        foreach ($fields as $field) {
            echo "<th>" . $field->name . "</th>";
        }
        echo "</tr>";
        
        $trc_data->data_seek(0);
        while ($row = $trc_data->fetch_assoc()) {
            echo "<tr>";
            foreach ($row as $value) {
                echo "<td>" . htmlspecialchars($value) . "</td>";
            }
            echo "</tr>";
        }
        echo "</table>";
        
        // Show totals
        $totals = $conn->query("SELECT COUNT(*) as count, SUM(commission_amount) as total_commission FROM teacher_referral_commissions");
        if ($totals) {
            $stats = $totals->fetch_assoc();
            echo "<p><strong>Total records: " . $stats['count'] . ", Total commission: R" . number_format($stats['total_commission'], 2) . "</strong></p>";
        }
    } else {
        echo "<p>No data found in teacher_referral_commissions table</p>";
    }
}

echo "<h3>7. Examining referrals Table:</h3>";
$check_ref = $conn->query("SHOW TABLES LIKE 'referrals'");
if ($check_ref && $check_ref->num_rows > 0) {
    echo "<p><strong>✓ referrals table exists</strong></p>";
    
    // Show table structure
    echo "<h4>Table Structure:</h4>";
    $ref_structure = $conn->query("DESCRIBE referrals");
    if ($ref_structure) {
        echo "<table><tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th></tr>";
        while ($col = $ref_structure->fetch_assoc()) {
            echo "<tr><td>" . $col['Field'] . "</td><td>" . $col['Type'] . "</td><td>" . $col['Null'] . "</td><td>" . $col['Key'] . "</td><td>" . $col['Default'] . "</td></tr>";
        }
        echo "</table>";
    }
    
    // Show sample data
    echo "<h4>Sample Data from referrals table:</h4>";
    $ref_data = $conn->query("SELECT * FROM referrals LIMIT 10");
    if ($ref_data && $ref_data->num_rows > 0) {
        echo "<table><tr>";
        $fields = $ref_data->fetch_fields();
        foreach ($fields as $field) {
            echo "<th>" . $field->name . "</th>";
        }
        echo "</tr>";
        
        $ref_data->data_seek(0);
        while ($row = $ref_data->fetch_assoc()) {
            echo "<tr>";
            foreach ($row as $value) {
                echo "<td>" . htmlspecialchars($value) . "</td>";
            }
            echo "</tr>";
        }
        echo "</table>";
        
        // Show totals
        $ref_totals = $conn->query("SELECT COUNT(*) as count FROM referrals");
        if ($ref_totals) {
            $ref_stats = $ref_totals->fetch_assoc();
            echo "<p><strong>Total referral records: " . $ref_stats['count'] . "</strong></p>";
        }
    } else {
        echo "<p>No data found in referrals table</p>";
    }
}

$conn->close();
?>
