<?php
// Debug script to check user session and database users
require_once __DIR__ . '/../config/db_connect.php';
session_start();

echo "<h3>🔍 Session Debug Information</h3>";
echo "<p><strong>Session User ID:</strong> " . ($_SESSION['user_id'] ?? 'NOT SET') . "</p>";
echo "<p><strong>Session Username:</strong> " . ($_SESSION['username'] ?? 'NOT SET') . "</p>";
echo "<p><strong>Session Role:</strong> " . ($_SESSION['role'] ?? 'NOT SET') . "</p>";

echo "<h3>👥 Available Admin Users in Database</h3>";

// Check what admin users exist
$stmt = $conn->prepare("SELECT user_id, username, first_name, last_name, user_role FROM users WHERE user_role = 'admin' ORDER BY user_id LIMIT 10");
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    echo "<table border='1' style='border-collapse: collapse; margin: 10px 0;'>";
    echo "<tr><th>User ID</th><th>Username</th><th>Name</th><th>Role</th></tr>";
    
    while ($user = $result->fetch_assoc()) {
        echo "<tr>";
        echo "<td>" . $user['user_id'] . "</td>";
        echo "<td>" . $user['username'] . "</td>";
        echo "<td>" . $user['first_name'] . " " . $user['last_name'] . "</td>";
        echo "<td>" . $user['user_role'] . "</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<p>❌ No admin users found!</p>";
}

echo "<h3>🔧 Potential Solutions</h3>";
echo "<p>1. <strong>If user ID 999 doesn't exist:</strong> We need to use a valid admin user ID</p>";
echo "<p>2. <strong>If session is incorrect:</strong> Re-login with proper admin credentials</p>";
echo "<p>3. <strong>Quick fix:</strong> Use the first available admin user ID</p>";

// Show first valid admin user
$stmt2 = $conn->prepare("SELECT user_id FROM users WHERE user_role = 'admin' ORDER BY user_id LIMIT 1");
$stmt2->execute();
$result2 = $stmt2->get_result();
if ($admin = $result2->fetch_assoc()) {
    echo "<p><strong>💡 Suggested Fix:</strong> Use user_id = " . $admin['user_id'] . " instead of 999</p>";
    echo "<p><a href='fix_session.php?user_id=" . $admin['user_id'] . "' style='background: #007bff; color: white; padding: 10px 15px; text-decoration: none; border-radius: 5px;'>🔧 Auto-Fix Session</a></p>";
}
?>
