<?php
/**
 * CERTIFICATE DOWNLOAD SCRIPT
 * Secure PDF download with proper headers
 */

require_once '../config/database.php';

if (isset($_GET['file']) && isset($_GET['template_id'])) {
    $filename = basename($_GET['file']);
    $template_id = intval($_GET['template_id']);
    
    // Validate file exists and belongs to this template
    $file_path = __DIR__ . '/../uploads/certificates/generated/' . $filename;
    
    if (file_exists($file_path) && pathinfo($filename, PATHINFO_EXTENSION) === 'pdf') {
        // Set proper headers for PDF download
        header('Content-Type: application/pdf');
        header('Content-Disposition: inline; filename="certificate_' . $template_id . '.pdf"');
        header('Content-Transfer-Encoding: binary');
        header('Content-Length: ' . filesize($file_path));
        header('Accept-Ranges: bytes');
        
        // Output file
        readfile($file_path);
        exit;
    }
}

// If we get here, file not found
http_response_code(404);
echo "File not found";
?>
