<?php
// Quick fix for user session foreign key issue
require_once __DIR__ . '/../config/db_connect.php';
session_start();

// Get the first available admin user
$stmt = $conn->prepare("SELECT user_id, username, first_name, last_name FROM users WHERE user_role = 'admin' ORDER BY user_id LIMIT 1");
$stmt->execute();
$result = $stmt->get_result();

if ($admin = $result->fetch_assoc()) {
    // Update session with valid admin user
    $_SESSION['user_id'] = $admin['user_id'];
    $_SESSION['username'] = $admin['username'];
    $_SESSION['role'] = 'admin';
    
    echo "<h2>✅ Session Fixed Successfully!</h2>";
    echo "<p><strong>Updated Session:</strong></p>";
    echo "<ul>";
    echo "<li>User ID: " . $_SESSION['user_id'] . "</li>";
    echo "<li>Username: " . $_SESSION['username'] . "</li>";
    echo "<li>Name: " . $admin['first_name'] . " " . $admin['last_name'] . "</li>";
    echo "<li>Role: " . $_SESSION['role'] . "</li>";
    echo "</ul>";
    
    echo "<p><a href='certificate_templates.php' style='background: #28a745; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px; display: inline-block; margin-top: 15px;'>🚀 Go Back to Certificate Templates</a></p>";
    
    echo "<p style='color: #666; margin-top: 20px;'><small>Your session has been updated with a valid admin user ID. You can now upload certificate templates successfully!</small></p>";
    
} else {
    echo "<h2>❌ No Admin Users Found</h2>";
    echo "<p>There are no admin users in the database. Please contact system administrator.</p>";
}
?>
