<?php
session_start();
require_once '../includes/config.php';

// Prevent output buffering
if (ob_get_level()) {
    ob_end_clean();
}

header('Content-Type: text/html; charset=UTF-8');

echo "<h1>🔍 Quick Quiz-Course Diagnostic</h1>";
echo "<pre>";

try {
    // 1. Check what tables exist
    echo "=== TABLES ANALYSIS ===\n";
    $tables = ['courses', 'quizzes', 'quiz_attempts', 'enrollments', 'course_enrollments'];
    
    foreach ($tables as $table) {
        $result = $conn->query("SHOW TABLES LIKE '$table'");
        if ($result && $result->num_rows > 0) {
            echo "✅ Table '$table' EXISTS\n";
            
            // Get row count
            $count_result = $conn->query("SELECT COUNT(*) as count FROM $table");
            if ($count_result) {
                $count = $count_result->fetch_assoc()['count'];
                echo "   📊 Rows: $count\n";
            }
        } else {
            echo "❌ Table '$table' MISSING\n";
        }
    }
    
    // 2. Check courses table structure
    echo "\n=== COURSES TABLE STRUCTURE ===\n";
    $courses_structure = $conn->query("DESCRIBE courses");
    if ($courses_structure) {
        while ($column = $courses_structure->fetch_assoc()) {
            echo "📋 {$column['Field']} ({$column['Type']})\n";
        }
    }
    
    // 3. Check quizzes table structure
    echo "\n=== QUIZZES TABLE STRUCTURE ===\n";
    $quizzes_check = $conn->query("SHOW TABLES LIKE 'quizzes'");
    if ($quizzes_check && $quizzes_check->num_rows > 0) {
        $quizzes_structure = $conn->query("DESCRIBE quizzes");
        if ($quizzes_structure) {
            while ($column = $quizzes_structure->fetch_assoc()) {
                echo "📋 {$column['Field']} ({$column['Type']})\n";
            }
        }
    } else {
        echo "❌ QUIZZES table doesn't exist!\n";
    }
    
    // 4. Sample courses data
    echo "\n=== SAMPLE COURSES ===\n";
    $courses_result = $conn->query("SELECT course_id, title, COALESCE(course_title, title) as display_title FROM courses LIMIT 5");
    if ($courses_result) {
        while ($course = $courses_result->fetch_assoc()) {
            echo "🎓 Course ID: {$course['course_id']} | Title: {$course['display_title']}\n";
        }
    }
    
    // 5. Sample quizzes data with course relationships
    echo "\n=== QUIZ-COURSE RELATIONSHIPS ===\n";
    $quiz_check = $conn->query("SHOW TABLES LIKE 'quizzes'");
    if ($quiz_check && $quiz_check->num_rows > 0) {
        $quiz_result = $conn->query("
            SELECT q.quiz_id, q.title as quiz_title, q.course_id, c.title as course_title
            FROM quizzes q 
            LEFT JOIN courses c ON q.course_id = c.course_id 
            LIMIT 10
        ");
        
        if ($quiz_result) {
            while ($quiz = $quiz_result->fetch_assoc()) {
                echo "📝 Quiz ID: {$quiz['quiz_id']} | Quiz: {$quiz['quiz_title']} | Course ID: {$quiz['course_id']} | Course: {$quiz['course_title']}\n";
            }
        }
    } else {
        echo "❌ No quizzes table found!\n";
    }
    
    // 6. Count quizzes per course
    echo "\n=== QUIZZES PER COURSE COUNT ===\n";
    $quiz_check = $conn->query("SHOW TABLES LIKE 'quizzes'");
    if ($quiz_check && $quiz_check->num_rows > 0) {
        $count_result = $conn->query("
            SELECT 
                c.course_id, 
                c.title as course_title,
                COUNT(q.quiz_id) as quiz_count
            FROM courses c
            LEFT JOIN quizzes q ON c.course_id = q.course_id
            GROUP BY c.course_id, c.title
            ORDER BY quiz_count DESC
        ");
        
        if ($count_result) {
            while ($count = $count_result->fetch_assoc()) {
                echo "🎓 Course: {$count['course_title']} (ID: {$count['course_id']}) | Quizzes: {$count['quiz_count']}\n";
            }
        }
    }
    
    // 7. Check specific course mentioned in error (Assessment Practitioner)
    echo "\n=== ASSESSMENT PRACTITIONER ANALYSIS ===\n";
    $assessment_result = $conn->query("
        SELECT course_id, title, COALESCE(course_title, title) as display_title 
        FROM courses 
        WHERE title LIKE '%Assessment%' OR title LIKE '%Practitioner%'
    ");
    
    if ($assessment_result && $assessment_result->num_rows > 0) {
        while ($course = $assessment_result->fetch_assoc()) {
            echo "🎯 Found Course: {$course['display_title']} (ID: {$course['course_id']})\n";
            
            // Check for quizzes in this specific course
            $quiz_check = $conn->query("SHOW TABLES LIKE 'quizzes'");
            if ($quiz_check && $quiz_check->num_rows > 0) {
                $quiz_count = $conn->query("SELECT COUNT(*) as count FROM quizzes WHERE course_id = {$course['course_id']}");
                if ($quiz_count) {
                    $count = $quiz_count->fetch_assoc()['count'];
                    echo "   📝 Quizzes found: $count\n";
                    
                    if ($count > 0) {
                        $quiz_details = $conn->query("SELECT quiz_id, title FROM quizzes WHERE course_id = {$course['course_id']}");
                        while ($quiz = $quiz_details->fetch_assoc()) {
                            echo "     • Quiz: {$quiz['title']} (ID: {$quiz['quiz_id']})\n";
                        }
                    }
                }
            }
        }
    } else {
        echo "❌ No Assessment Practitioner course found!\n";
    }

} catch (Exception $e) {
    echo "❌ ERROR: " . $e->getMessage() . "\n";
}

echo "</pre>";
?>
