<?php
require_once '../auth/functions.php';

// Ensure user is logged in as an admin
requireRole('admin');

// Process message status
$message = '';
$messageType = '';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>System Management - Panadite Academy</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css">
    <link href='https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css' rel='stylesheet'>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" href="/assets/css/style.css">
    <link rel="stylesheet" href="/assets/css/admin-dashboard.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        /* Modern Card Styles */
        .system-card {
            border: none;
            border-radius: 15px;
            overflow: hidden;
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.05);
            transition: all 0.3s ease;
            height: 100%;
            margin-bottom: 30px;
            position: relative;
            background: #fff;
        }
        
        .system-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 15px 30px rgba(0, 0, 0, 0.1);
        }
        
        .system-card .card-banner {
            height: 120px;
            position: relative;
            overflow: hidden;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .system-card .card-banner.users {
            background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
        }
        
        .system-card .card-banner.content {
            background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%);
        }
        
        .system-card .card-banner.files {
            background: linear-gradient(135deg, #36b9cc 0%, #258391 100%);
        }
        
        .system-card .card-banner.backup {
            background: linear-gradient(135deg, #f6c23e 0%, #dda20a 100%);
        }
        
        .system-card .card-banner.cleanup {
            background: linear-gradient(135deg, #e74a3b 0%, #be2617 100%);
        }
        
        .system-card .card-banner.logs {
            background: linear-gradient(135deg, #858796 0%, #60616f 100%);
        }
        
        .system-icon {
            font-size: 4rem;
            color: rgba(255, 255, 255, 0.85);
            filter: drop-shadow(0 2px 5px rgba(0, 0, 0, 0.2));
        }
        
        .system-card .card-body {
            padding: 25px;
            text-align: center;
        }
        
        .system-card .card-title {
            font-size: 1.4rem;
            font-weight: 600;
            margin-bottom: 15px;
            color: #333;
        }
        
        .system-card .card-text {
            color: #6e707e;
            margin-bottom: 25px;
            line-height: 1.5;
            font-size: 0.95rem;
        }
        
        .btn-system {
            border-radius: 50px;
            padding: 10px 25px;
            font-weight: 500;
            letter-spacing: 0.5px;
            transition: all 0.3s ease;
            text-transform: uppercase;
            font-size: 0.85rem;
        }
        
        .btn-system:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
        }
        
        .btn-users {
            background: #4e73df;
            color: white;
        }
        
        .btn-users:hover {
            background: #224abe;
            color: white;
        }
        
        .btn-content {
            background: #1cc88a;
            color: white;
        }
        
        .btn-content:hover {
            background: #13855c;
            color: white;
        }
        
        .btn-files {
            background: #36b9cc;
            color: white;
        }
        
        .btn-files:hover {
            background: #258391;
            color: white;
        }
        
        .btn-backup {
            background: #f6c23e;
            color: white;
        }
        
        .btn-backup:hover {
            background: #dda20a;
            color: white;
        }
        
        .btn-cleanup {
            background: #e74a3b;
            color: white;
        }
        
        .btn-cleanup:hover {
            background: #be2617;
            color: white;
        }
        
        .btn-logs {
            background: #858796;
            color: white;
        }
        
        .btn-logs:hover {
            background: #60616f;
            color: white;
        }
        
        /* Header Styles */
        .page-header {
            background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
            color: white;
            border-radius: 15px;
            padding: 25px;
            margin-bottom: 30px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
        }
        
        .page-header h1 {
            font-weight: 600;
            margin: 0;
            font-size: 1.8rem;
        }
        
        .page-header p {
            margin: 5px 0 0;
            opacity: 0.8;
        }
        
        /* Modal Styles */
        .confirmation-modal .modal-content {
            border: none;
            border-radius: 15px;
            overflow: hidden;
        }
        
        .confirmation-modal .modal-body {
            padding: 40px;
            text-align: center;
        }
        
        .confirmation-modal .icon {
            font-size: 5rem;
            color: #e74a3b;
            margin-bottom: 20px;
        }
        
        .confirmation-modal h4 {
            font-weight: 600;
            color: #333;
        }
        
        .confirmation-modal .form-control {
            border-radius: 50px;
            padding: 12px 20px;
            font-size: 1rem;
            box-shadow: none;
            border: 1px solid #ddd;
            text-align: center;
        }
        
        .confirmation-modal .form-control:focus {
            border-color: #4e73df;
            box-shadow: 0 0 0 0.25rem rgba(78, 115, 223, 0.25);
        }
        
        /* Animation */
        .animate-fade-up {
            opacity: 0;
            transform: translateY(20px);
            animation: fadeUp 0.5s ease forwards;
            animation-delay: calc(var(--delay) * 0.1s);
        }
        
        @keyframes fadeUp {
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        /* Dashboard Content Custom Styling */
        .dashboard-content {
            padding: 30px 15px;
        }
        
        /* Equal height cards */
        .card-row {
            display: flex;
            flex-wrap: wrap;
        }
        
        .card-col {
            display: flex;
            flex-direction: column;
            margin-bottom: 30px;
        }
    </style>
</head>
<body>
    <!-- Sidebar -->
    <?php include('components/sidebar.php'); ?>
    
    <!-- Main Content -->
    <section class="main-content">
        <!-- Navbar -->
        <?php include('components/navbar.php'); ?>
        
        <!-- Dashboard Content -->
        <div class="dashboard-content">
            <div class="container-fluid">
                <!-- Page Header -->
                <div class="page-header animate-fade-up" style="--delay: 0">
                    <div class="row align-items-center">
                        <div class="col-md-6">
                            <h1><i class="bx bxs-cog me-2"></i> System Management</h1>
                            <p>Configure and manage system settings and maintenance</p>
                        </div>
                    </div>
                </div>
                
                <?php if (!empty($message)): ?>
                    <div class="alert alert-<?= $messageType ?> alert-dismissible fade show animate-fade-up" role="alert" style="--delay: 1">
                        <?= $message ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?>
                
                <div class="row card-row">
                    <!-- User Management Card -->
                    <div class="col-lg-4 col-md-6 card-col animate-fade-up" style="--delay: 2">
                        <div class="system-card">
                            <div class="card-banner users">
                                <i class="system-icon bx bxs-user-detail"></i>
                            </div>
                            <div class="card-body">
                                <h5 class="card-title">User Management</h5>
                                <p class="card-text">Delete user accounts and associated data permanently from the system.</p>
                                <a href="system_users.php" class="btn btn-system btn-users">Manage Users</a>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Content Management Card -->
                    <div class="col-lg-4 col-md-6 card-col animate-fade-up" style="--delay: 3">
                        <div class="system-card">
                            <div class="card-banner content">
                                <i class="system-icon bx bxs-file"></i>
                            </div>
                            <div class="card-body">
                                <h5 class="card-title">Content Management</h5>
                                <p class="card-text">Delete courses, videos, assignments, and other content materials.</p>
                                <a href="system_content.php" class="btn btn-system btn-content">Manage Content</a>
                            </div>
                        </div>
                    </div>
                    
                    <!-- File Management Card -->
                    <div class="col-lg-4 col-md-6 card-col animate-fade-up" style="--delay: 4">
                        <div class="system-card">
                            <div class="card-banner files">
                                <i class="system-icon bx bxs-folder"></i>
                            </div>
                            <div class="card-body">
                                <h5 class="card-title">File Management</h5>
                                <p class="card-text">Delete uploaded images, videos, documents, and other files.</p>
                                <a href="system_files.php" class="btn btn-system btn-files">Manage Files</a>
                            </div>
                        </div>
                    </div>
                    
                    <!-- System Backup Card -->
                    <div class="col-lg-4 col-md-6 card-col animate-fade-up" style="--delay: 5">
                        <div class="system-card">
                            <div class="card-banner backup">
                                <i class="system-icon bx bxs-data"></i>
                            </div>
                            <div class="card-body">
                                <h5 class="card-title">System Backup</h5>
                                <p class="card-text">Create and manage system backups for database and files.</p>
                                <a href="system_backup.php" class="btn btn-system btn-backup">Manage Backups</a>
                            </div>
                        </div>
                    </div>
                    
                    <!-- System Cleanup Card -->
                    <div class="col-lg-4 col-md-6 card-col animate-fade-up" style="--delay: 6">
                        <div class="system-card">
                            <div class="card-banner cleanup">
                                <i class="system-icon bx bxs-trash"></i>
                            </div>
                            <div class="card-body">
                                <h5 class="card-title">System Cleanup</h5>
                                <p class="card-text">Perform complete system cleanup, removing all data except admin account.</p>
                                <button type="button" class="btn btn-system btn-cleanup" data-bs-toggle="modal" data-bs-target="#systemCleanupModal">
                                    Clean System
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <!-- System Logs Card -->
                    <div class="col-lg-4 col-md-6 card-col animate-fade-up" style="--delay: 7">
                        <div class="system-card">
                            <div class="card-banner logs">
                                <i class="system-icon bx bxs-notepad"></i>
                            </div>
                            <div class="card-body">
                                <h5 class="card-title">System Logs</h5>
                                <p class="card-text">View and manage system logs, activities, and error reports.</p>
                                <a href="system_logs.php" class="btn btn-system btn-logs">View Logs</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
    <!-- System Cleanup Confirmation Modal -->
    <div class="modal fade confirmation-modal" id="systemCleanupModal" tabindex="-1" aria-labelledby="systemCleanupModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-body">
                    <i class="icon bx bxs-error-circle"></i>
                    <h4 class="mb-4">Complete System Cleanup</h4>
                    <p class="mb-4">Warning! This will delete ALL data except the admin account. This action cannot be undone.</p>
                    <p class="text-danger fw-bold mb-4">All users, courses, videos, files, and other data will be permanently removed.</p>
                    <form action="system_cleanup_process.php" method="post" class="mt-4">
                        <div class="mb-3">
                            <label for="confirmText" class="form-label">Type "CONFIRM DELETE ALL" to proceed:</label>
                            <input type="text" class="form-control" id="confirmText" name="confirm_text" required>
                        </div>
                        <div class="d-flex justify-content-center gap-3 mt-4">
                            <button type="button" class="btn btn-secondary rounded-pill px-4" data-bs-dismiss="modal">Cancel</button>
                            <button type="submit" class="btn btn-danger rounded-pill px-4" id="confirmCleanupBtn" disabled>Confirm Cleanup</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/jquery@3.6.4/dist/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Enable the confirm button only when the correct text is typed
        document.getElementById('confirmText').addEventListener('input', function() {
            const confirmBtn = document.getElementById('confirmCleanupBtn');
            confirmBtn.disabled = this.value !== "CONFIRM DELETE ALL";
        });
    </script>
</body>
</html>
