/**
 * Night Sky Animation with Glimmering Stars
 * For Panadite Academy Teacher Dashboard
 */

document.addEventListener('DOMContentLoaded', function() {
    // Initialize the night sky animation
    const starsContainer = document.querySelector('.modern-dashboard .night-sky-banner .stars');
    
    if (!starsContainer) {
        console.log('Stars container not found');
        return; // Exit if stars container doesn't exist
    }
    
    // Create twinkling stars
    for (let i = 0; i < 100; i++) {
        createStar(starsContainer);
    }
    
    // Create shooting stars occasionally
    setInterval(() => {
        if (Math.random() > 0.7) { // 30% chance to create a shooting star
            createShootingStar(starsContainer);
        }
    }, 2000);
    
    // Toggle sidebar collapse on button click
    const sidebarToggle = document.getElementById('sidebarToggle');
    const sidebar = document.querySelector('.modern-dashboard .sidebar');
    const mainContent = document.querySelector('.modern-dashboard .main-content');
    
    if (sidebarToggle && sidebar && mainContent) {
        sidebarToggle.addEventListener('click', function() {
            sidebar.classList.toggle('collapsed');
            mainContent.classList.toggle('expanded');
        });
    }
});

/**
 * Creates a twinkling star with random properties
 * @param {HTMLElement} container - The container to append the star to
 */
function createStar(container) {
    const star = document.createElement('div');
    star.classList.add('star');
    
    // Random position
    const x = Math.random() * 100;
    const y = Math.random() * 100;
    star.style.left = `${x}%`;
    star.style.top = `${y}%`;
    
    // Random size (1-3px)
    const size = 1 + Math.random() * 2;
    star.style.width = `${size}px`;
    star.style.height = `${size}px`;
    
    // Random animation duration (1-5s)
    const duration = 1 + Math.random() * 4;
    star.style.setProperty('--duration', `${duration}s`);
    
    // Random animation delay
    const delay = Math.random() * 5;
    star.style.animationDelay = `${delay}s`;
    
    container.appendChild(star);
}

/**
 * Creates a shooting star with random properties
 * @param {HTMLElement} container - The container to append the shooting star to
 */
function createShootingStar(container) {
    const shootingStar = document.createElement('div');
    shootingStar.classList.add('shooting-star');
    
    // Random position at top of banner
    const x = Math.random() * 100;
    shootingStar.style.left = `${x}%`;
    shootingStar.style.top = '0';
    
    // Random delay
    const delay = Math.random() * 0.5;
    shootingStar.style.setProperty('--delay', `${delay}s`);
    
    container.appendChild(shootingStar);
    
    // Remove the shooting star after animation completes
    setTimeout(() => {
        shootingStar.remove();
    }, 6000); // Animation duration is 6s
}
