<?php
/**
 * Focused debug to check what's actually in the referrals table
 */

header('Content-Type: text/plain');
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "=== REFERRALS TABLE DEBUG ===\n\n";

// Database configuration
$is_local = ($_SERVER['HTTP_HOST'] == 'localhost' || 
            strpos($_SERVER['HTTP_HOST'], '127.0.0.1') !== false ||
            strpos($_SERVER['HTTP_HOST'], '192.168.') !== false);

if ($is_local) {
    $db_host = 'localhost';
    $db_name = 'panadite_academy';
    $db_user = 'root';
    $db_pass = '';
} else {
    $db_host = 'localhost';
    $db_name = 'twpurnyc_panadite_DB';
    $db_user = 'twpurnyc_149586Alain';
    $db_pass = '149586Alain#';
}

try {
    $conn = new mysqli($db_host, $db_user, $db_pass, $db_name);
    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error . "\n");
    }
    
    echo "✓ Database connected: $db_name\n\n";

    // 1. Check if TBNSU1480 exists in referrals table
    echo "=== SEARCHING FOR TBNSU1480 ===\n";
    $searchQuery = "SELECT * FROM referrals WHERE referral_code = 'TBNSU1480'";
    $result = $conn->query($searchQuery);
    
    if ($result && $result->num_rows > 0) {
        echo "✓ FOUND TBNSU1480 in referrals table:\n";
        while ($row = $result->fetch_assoc()) {
            foreach ($row as $key => $value) {
                echo "  $key: $value\n";
            }
        }
    } else {
        echo "✗ TBNSU1480 NOT FOUND in referrals table\n";
    }

    // 2. Show ALL referral codes in the table
    echo "\n=== ALL REFERRAL CODES IN TABLE ===\n";
    $allQuery = "SELECT referral_code, referrer_id, referrer_type, status, created_at FROM referrals ORDER BY created_at DESC LIMIT 10";
    $allResult = $conn->query($allQuery);
    
    if ($allResult && $allResult->num_rows > 0) {
        echo "Found " . $allResult->num_rows . " referral codes:\n";
        while ($row = $allResult->fetch_assoc()) {
            echo "Code: {$row['referral_code']} | Referrer ID: {$row['referrer_id']} | Type: {$row['referrer_type']} | Status: {$row['status']} | Created: {$row['created_at']}\n";
        }
    } else {
        echo "No referral codes found in referrals table\n";
    }

    // 3. Count total referrals
    echo "\n=== REFERRALS TABLE STATS ===\n";
    $countQuery = "SELECT COUNT(*) as total FROM referrals";
    $countResult = $conn->query($countQuery);
    if ($countResult) {
        $count = $countResult->fetch_assoc();
        echo "Total referrals in table: {$count['total']}\n";
    }

    // 4. Check for codes starting with TBNS or similar
    echo "\n=== CODES STARTING WITH 'TBNS' ===\n";
    $tbnsQuery = "SELECT referral_code, referrer_id FROM referrals WHERE referral_code LIKE 'TBNS%'";
    $tbnsResult = $conn->query($tbnsQuery);
    
    if ($tbnsResult && $tbnsResult->num_rows > 0) {
        echo "Found TBNS codes:\n";
        while ($row = $tbnsResult->fetch_assoc()) {
            echo "Code: {$row['referral_code']} | Referrer ID: {$row['referrer_id']}\n";
        }
    } else {
        echo "No codes starting with 'TBNS' found\n";
    }

    // 5. Check what users are in the users table (teachers specifically)
    echo "\n=== TEACHERS IN USERS TABLE ===\n";
    $teachersQuery = "SELECT user_id, username, first_name, last_name, user_role FROM users WHERE user_role = 'teacher' LIMIT 5";
    $teachersResult = $conn->query($teachersQuery);
    
    if ($teachersResult && $teachersResult->num_rows > 0) {
        echo "Teachers found:\n";
        while ($row = $teachersResult->fetch_assoc()) {
            echo "ID: {$row['user_id']} | Username: {$row['username']} | Name: {$row['first_name']} {$row['last_name']} | Role: {$row['user_role']}\n";
            
            // Check if this teacher has any referrals
            $teacherReferrals = $conn->query("SELECT referral_code FROM referrals WHERE referrer_id = {$row['user_id']}");
            if ($teacherReferrals && $teacherReferrals->num_rows > 0) {
                $codes = [];
                while ($refRow = $teacherReferrals->fetch_assoc()) {
                    $codes[] = $refRow['referral_code'];
                }
                echo "  → Has referral codes: " . implode(', ', $codes) . "\n";
            } else {
                echo "  → No referral codes found\n";
            }
        }
    } else {
        echo "No teachers found in users table\n";
    }

    // 6. Test the exact query used in validation
    echo "\n=== TESTING VALIDATION QUERY ===\n";
    $validationQuery = "SELECT u.user_id, u.username, u.user_role, u.first_name, u.last_name
                       FROM referrals r 
                       JOIN users u ON r.referrer_id = u.user_id 
                       WHERE r.referral_code = 'TBNSU1480'";
    
    echo "Query: $validationQuery\n";
    $validationResult = $conn->query($validationQuery);
    
    if ($validationResult && $validationResult->num_rows > 0) {
        echo "✓ Validation query successful:\n";
        while ($row = $validationResult->fetch_assoc()) {
            echo "Found referrer: {$row['first_name']} {$row['last_name']} ({$row['username']}) - {$row['user_role']}\n";
        }
    } else {
        echo "✗ Validation query returned no results\n";
        if ($conn->error) {
            echo "SQL Error: " . $conn->error . "\n";
        }
    }

} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
}
?>
