<?php
/**
 * Debug Script - Check forgot-password.php issues
 */
echo "<h2>Forgot Password File Debug</h2>";
echo "<hr>";

// Check current directory
echo "<h3>Current Directory Info:</h3>";
echo "Current directory: " . __DIR__ . "<br>";
echo "Document root: " . $_SERVER['DOCUMENT_ROOT'] . "<br>";
echo "Server script name: " . $_SERVER['SCRIPT_NAME'] . "<br>";
echo "<hr>";

// Check if forgot-password.php exists
$forgot_file = __DIR__ . '/forgot-password.php';
echo "<h3>File Existence Check:</h3>";
echo "Looking for: $forgot_file<br>";

if (file_exists($forgot_file)) {
    echo "✅ <span style='color: green;'>forgot-password.php EXISTS</span><br>";
    echo "📏 File size: " . number_format(filesize($forgot_file)) . " bytes<br>";
    echo "📅 Last modified: " . date('Y-m-d H:i:s', filemtime($forgot_file)) . "<br>";
    echo "🔒 File permissions: " . substr(sprintf('%o', fileperms($forgot_file)), -4) . "<br>";
    
    // Check if file is readable
    if (is_readable($forgot_file)) {
        echo "📖 <span style='color: green;'>File is READABLE</span><br>";
    } else {
        echo "❌ <span style='color: red;'>File is NOT READABLE</span><br>";
    }
} else {
    echo "❌ <span style='color: red;'>forgot-password.php NOT FOUND</span><br>";
}
echo "<hr>";

// List all files in auth directory
echo "<h3>All Files in /auth/ Directory:</h3>";
$files = scandir(__DIR__);
echo "<ul>";
foreach ($files as $file) {
    if ($file != '.' && $file != '..') {
        $size = filesize(__DIR__ . '/' . $file);
        $perms = substr(sprintf('%o', fileperms(__DIR__ . '/' . $file)), -4);
        echo "<li><strong>$file</strong> - " . number_format($size) . " bytes - Permissions: $perms</li>";
    }
}
echo "</ul>";
echo "<hr>";

// Test direct PHP inclusion
echo "<h3>PHP Inclusion Test:</h3>";
if (file_exists($forgot_file)) {
    echo "Attempting to include forgot-password.php...<br>";
    
    ob_start();
    $error = '';
    
    try {
        // Try to include the file and catch any fatal errors
        include_once $forgot_file;
        echo "✅ <span style='color: green;'>File included successfully (no fatal PHP errors)</span><br>";
    } catch (Exception $e) {
        $error = $e->getMessage();
        echo "❌ <span style='color: red;'>PHP Error: " . htmlspecialchars($error) . "</span><br>";
    } catch (ParseError $e) {
        $error = $e->getMessage();
        echo "❌ <span style='color: red;'>PHP Parse Error: " . htmlspecialchars($error) . "</span><br>";
    }
    
    $output = ob_get_clean();
    
    if ($error) {
        echo "Error details: " . htmlspecialchars($error) . "<br>";
    }
} else {
    echo "Cannot test - file does not exist<br>";
}
echo "<hr>";

// Test URL access
echo "<h3>URL Access Test:</h3>";
$current_url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]";
$forgot_url = $current_url . '/auth/forgot-password.php';

echo "Expected URL: <a href='$forgot_url' target='_blank'>$forgot_url</a><br>";
echo "Try clicking the link above to test direct access.<br>";
echo "<hr>";

// Check server configuration
echo "<h3>Server Configuration:</h3>";
echo "PHP Version: " . phpversion() . "<br>";
echo "Server Software: " . $_SERVER['SERVER_SOFTWARE'] . "<br>";
echo "Server Name: " . $_SERVER['SERVER_NAME'] . "<br>";

// Check for any .htaccess files
echo "<h3>.htaccess Files Check:</h3>";
$htaccess_files = [
    __DIR__ . '/.htaccess',
    dirname(__DIR__) . '/.htaccess',
    $_SERVER['DOCUMENT_ROOT'] . '/.htaccess'
];

foreach ($htaccess_files as $htaccess) {
    if (file_exists($htaccess)) {
        echo "🚨 Found .htaccess at: $htaccess<br>";
        echo "Content preview:<br><pre>" . htmlspecialchars(file_get_contents($htaccess)) . "</pre><br>";
    }
}

echo "<hr>";
echo "<p><strong>Debug complete. If forgot-password.php exists but still gives 404, check the file permissions and server error logs.</strong></p>";
?>
