<?php
/**
 * Comprehensive search to find where referral code TBNSU1480 is actually stored
 */

header('Content-Type: application/json');

// Database configuration
$is_local = ($_SERVER['HTTP_HOST'] == 'localhost' || 
            strpos($_SERVER['HTTP_HOST'], '127.0.0.1') !== false ||
            strpos($_SERVER['HTTP_HOST'], '192.168.') !== false);

if ($is_local) {
    $db_host = 'localhost';
    $db_name = 'panadite_academy';
    $db_user = 'root';
    $db_pass = '';
} else {
    $db_host = 'localhost';
    $db_name = 'twpurnyc_panadite_DB';
    $db_user = 'twpurnyc_149586Alain';
    $db_pass = '149586Alain#';
}

try {
    $conn = new mysqli($db_host, $db_user, $db_pass, $db_name);
    if ($conn->connect_error) {
        echo json_encode(['error' => 'Database connection failed: ' . $conn->connect_error]);
        exit;
    }

    $searchCode = 'TBNSU1480';
    $results = [
        'searching_for' => $searchCode,
        'database' => $db_name,
        'found_in' => []
    ];

    // Get all tables
    $tablesQuery = $conn->query("SHOW TABLES");
    $allTables = [];
    while ($row = $tablesQuery->fetch_array()) {
        $allTables[] = $row[0];
    }

    // Search in each table for the referral code
    foreach ($allTables as $tableName) {
        try {
            // Get table structure
            $structureQuery = $conn->query("DESCRIBE `$tableName`");
            $columns = [];
            while ($col = $structureQuery->fetch_assoc()) {
                $columns[] = $col['Field'];
            }

            // Look for columns that might contain referral codes
            $possibleColumns = [];
            foreach ($columns as $column) {
                if (stripos($column, 'code') !== false || 
                    stripos($column, 'referral') !== false || 
                    stripos($column, 'refer') !== false) {
                    $possibleColumns[] = $column;
                }
            }

            if (!empty($possibleColumns)) {
                // Search in each possible column
                foreach ($possibleColumns as $column) {
                    $searchQuery = "SELECT * FROM `$tableName` WHERE `$column` = ? LIMIT 5";
                    $stmt = $conn->prepare($searchQuery);
                    if ($stmt) {
                        $stmt->bind_param("s", $searchCode);
                        $stmt->execute();
                        $result = $stmt->get_result();
                        
                        if ($result->num_rows > 0) {
                            $foundData = [];
                            while ($row = $result->fetch_assoc()) {
                                $foundData[] = $row;
                            }
                            
                            $results['found_in'][] = [
                                'table' => $tableName,
                                'column' => $column,
                                'data' => $foundData
                            ];
                        }
                    }
                }
            }

            // Also search for partial matches in text columns
            foreach ($columns as $column) {
                if (in_array($column, ['username', 'name', 'full_name', 'email'])) {
                    continue; // Skip obvious non-code columns
                }
                
                $likeQuery = "SELECT * FROM `$tableName` WHERE `$column` LIKE ? LIMIT 3";
                $stmt = $conn->prepare($likeQuery);
                if ($stmt) {
                    $likePattern = '%' . $searchCode . '%';
                    $stmt->bind_param("s", $likePattern);
                    $stmt->execute();
                    $result = $stmt->get_result();
                    
                    if ($result->num_rows > 0) {
                        $foundData = [];
                        while ($row = $result->fetch_assoc()) {
                            $foundData[] = $row;
                        }
                        
                        $results['found_in'][] = [
                            'table' => $tableName,
                            'column' => $column,
                            'match_type' => 'partial',
                            'data' => $foundData
                        ];
                    }
                }
            }

        } catch (Exception $e) {
            // Skip tables we can't access
            continue;
        }
    }

    // Check specific referral-related tables more thoroughly
    $referralTables = ['referrals', 'referral_settings', 'referral_analytics', 
                      'student_referral_discounts', 'teacher_referral_commissions', 
                      'users', 'teachers', 'students'];

    foreach ($referralTables as $table) {
        if (in_array($table, $allTables)) {
            $results['table_structures'][$table] = [];
            
            $structureQuery = $conn->query("DESCRIBE `$table`");
            while ($col = $structureQuery->fetch_assoc()) {
                $results['table_structures'][$table][] = $col['Field'];
            }

            // Get sample data
            $sampleQuery = $conn->query("SELECT * FROM `$table` LIMIT 3");
            $sampleData = [];
            while ($row = $sampleQuery->fetch_assoc()) {
                $sampleData[] = $row;
            }
            $results['sample_data'][$table] = $sampleData;
        }
    }

    // Check if referral codes are generated dynamically
    // Look for users with ID that might match the teacher
    $teacherQuery = "SELECT id, username, role FROM users WHERE role = 'teacher' LIMIT 5";
    $teacherResult = $conn->query($teacherQuery);
    $teachers = [];
    while ($row = $teacherResult->fetch_assoc()) {
        $teachers[] = $row;
    }
    $results['sample_teachers'] = $teachers;

    echo json_encode($results);

} catch (Exception $e) {
    echo json_encode(['error' => $e->getMessage()]);
}
?>
