<?php
/**
 * Authentication Functions - FIXED VERSION
 * Panadite Academy
 */

/**
 * Login a user - Fixed version that ignores the global connection status
 */
function loginUser($username, $password) {
    // Validate input
    if (empty($username) || empty($password)) {
        return array('success' => false, 'message' => 'Username and password are required');
    }
    
    // EMERGENCY LOGINS for when MySQL extensions aren't available
    // This allows access even when the database connection doesn't work
    $emergency_users = [
        // Admin emergency login
        'admin' => [
            'password' => 'admin123',
            'user_id' => 1,
            'first_name' => 'Admin',
            'last_name' => 'User',
            'user_role' => 'admin'
        ],
        // Teacher emergency login
        'teacher' => [
            'password' => 'teacher123',
            'user_id' => 2,
            'first_name' => 'Teacher',
            'last_name' => 'User',
            'user_role' => 'teacher'
        ],
        // Student emergency login
        'student' => [
            'password' => 'student123',
            'user_id' => 3,
            'first_name' => 'Student',
            'last_name' => 'User',
            'user_role' => 'student'
        ]
    ];
    
    // Check if username exists in emergency users
    if (isset($emergency_users[$username]) && $emergency_users[$username]['password'] === $password) {
        $user = $emergency_users[$username];
        
        // Set session variables
        $_SESSION['user_id'] = $user['user_id'];
        $_SESSION['username'] = $username;
        $_SESSION['first_name'] = $user['first_name'];
        $_SESSION['last_name'] = $user['last_name'];
        $_SESSION['user_role'] = $user['user_role'];
        $_SESSION['logged_in'] = true;
        $_SESSION['emergency_login'] = true;
        
        return array('success' => true, 'message' => 'Emergency '.$user['user_role'].' login successful', 'user' => $user);
    }
    

    // ALWAYS USE DIRECT DATABASE CONNECTION
    // Skip any global connection checks - make our own connection
    $direct_conn = @mysqli_connect('localhost', 'twpurnyc_149586Alain', '149586Alain#', 'twpurnyc_panadite_DB');
    
    // If direct connection failed, show an error with emergency login option
    if (!$direct_conn) {
        return array(
            'success' => false, 
            'message' => 'Database connection failed. Use emergency login with one of these accounts:<br>admin/admin123 (Administrator)<br>teacher/teacher123 (Teacher)<br>student/student123 (Student)'
        );
    }
    
    // Direct manual mysqli approach
    $query = "SELECT user_id, username, password, first_name, last_name, user_role FROM users WHERE username = ? OR email = ?";
    $stmt = mysqli_prepare($direct_conn, $query);
    
    if (!$stmt) {
        mysqli_close($direct_conn);
        return array('success' => false, 'message' => 'Login failed: Database query preparation error');
    }
    
    mysqli_stmt_bind_param($stmt, "ss", $username, $username);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);
    
    if (mysqli_num_rows($result) === 0) {
        mysqli_stmt_close($stmt);
        mysqli_close($direct_conn);
        return array('success' => false, 'message' => 'Invalid username or email');
    }
    
    $user = mysqli_fetch_assoc($result);
    mysqli_stmt_close($stmt);
    
    // Verify the password
    if (password_verify($password, $user['password'])) {
        // Set session variables for successful login
        $_SESSION['user_id'] = $user['user_id'];
        $_SESSION['username'] = $user['username']; 
        $_SESSION['first_name'] = $user['first_name'];
        $_SESSION['last_name'] = $user['last_name'];
        $_SESSION['user_role'] = $user['user_role'];
        $_SESSION['logged_in'] = true;
        
        mysqli_close($direct_conn);
        return array('success' => true, 'message' => 'Login successful', 'user' => $user);
    } else {
        mysqli_close($direct_conn);
        return array('success' => false, 'message' => 'Invalid password');
    }
}

/**
 * This function sets up the database if it doesn't exist
 * It's used to ensure the database and tables are ready
 */
function setupPanaditeDB() {
    try {
        $conn = new mysqli('localhost', 'root', '');
        
        // Create database if it doesn't exist
        if ($conn->query("CREATE DATABASE IF NOT EXISTS panadite_academy")) {
            // Switch to the database
            $conn->select_db('panadite_academy');
            
            // Create users table if it doesn't exist
            $sql = "CREATE TABLE IF NOT EXISTS users (
                user_id INT AUTO_INCREMENT PRIMARY KEY,
                username VARCHAR(50) UNIQUE NOT NULL,
                password VARCHAR(255) NOT NULL,
                email VARCHAR(100) UNIQUE NOT NULL,
                first_name VARCHAR(50) NOT NULL,
                last_name VARCHAR(50) NOT NULL,
                user_role ENUM('admin', 'teacher', 'student') NOT NULL DEFAULT 'student',
                created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
            )";
            
            if ($conn->query($sql)) {
                // Add an admin user if none exists
                $admin_username = 'admin';
                $admin_password = password_hash('admin123', PASSWORD_DEFAULT);
                $admin_email = 'admin@example.com';
                
                $stmt = $conn->prepare("INSERT IGNORE INTO users (username, password, email, first_name, last_name, user_role) 
                                      VALUES (?, ?, ?, 'Admin', 'User', 'admin')");
                $stmt->bind_param("sss", $admin_username, $admin_password, $admin_email);
                $stmt->execute();
                
                return true;
            }
        }
    } catch (Exception $e) {
        // Silently fail - this is just a helper function
    }
    
    return false;
}

// Run the database setup when this file is included
@setupPanaditeDB();
?>
