<?php
/**
 * User Logout File - Enhanced Session Management
 * Panadite Academy - Matches enhanced login cookie settings
 */

// Enhanced session configuration matching login.php EXACTLY
ini_set('session.cookie_httponly', 1);
ini_set('session.use_only_cookies', 1);
// Adjust secure flag based on HTTPS availability
ini_set('session.cookie_secure', isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 1 : 0);
ini_set('session.cookie_samesite', 'Lax');
ini_set('session.use_strict_mode', 1);
ini_set('session.cookie_lifetime', 7200); // 2 hours - MUST MATCH login.php
ini_set('session.gc_maxlifetime', 7200); // 2 hours - MUST MATCH login.php
ini_set('session.cookie_domain', ''); // Let PHP determine the domain
ini_set('session.cookie_path', '/'); // Ensure cookie works for entire site

// Set proper session save path for Linux server (same as login.php)
$temp_dir = sys_get_temp_dir();
if (!is_writable($temp_dir)) {
    // Try alternative paths for Linux server
    $alternative_paths = ['/tmp', '/var/tmp', dirname(__FILE__) . '/tmp'];
    foreach ($alternative_paths as $path) {
        if (is_dir($path) && is_writable($path)) {
            $temp_dir = $path;
            break;
        }
    }
}
ini_set('session.save_path', $temp_dir);


// Start session to clear it
if (session_status() !== PHP_SESSION_ACTIVE) {
    session_start();
}

$session_id = session_id();
$username = $_SESSION['username'] ?? $_SESSION['email'] ?? 'unknown';



// Clear all session data
$_SESSION = array();

// Enhanced cookie clearing to match login.php settings
if (!headers_sent()) {
    // Clear cookies with same settings used during login
    $cookie_options = [
        'expires' => time() - 3600, // 1 hour ago to ensure deletion
        'path' => '/',  // CRITICAL: Root path for entire site
        'domain' => $_SERVER['HTTP_HOST'] ?? $_SERVER['SERVER_NAME'] ?? '',
        'secure' => isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on',
        'httponly' => true,
        'samesite' => 'Lax'
    ];
    
    // Clear cookies multiple ways to ensure they're removed
    setcookie('PHPSESSID', '', $cookie_options);
    setcookie(session_name(), '', $cookie_options);
    
    // Also clear via header as additional fallback
    $cookie_header = session_name() . '=; Path=/; HttpOnly; SameSite=Lax; Expires=' . gmdate('D, d M Y H:i:s T', time() - 3600);
    if ($cookie_options['secure']) {
        $cookie_header .= '; Secure';
    }
    header('Set-Cookie: ' . $cookie_header, false);
    

}

// Destroy the session
session_destroy();



// Redirect to login page with success message
header('Location: login.php?logout=1');
exit();
?>
