<?php
/**
 * Final test for referral code validation with correct pattern
 */
header('Content-Type: text/html');
?>
<!DOCTYPE html>
<html>
<head>
    <title>Test Referral Code Validation</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; background: #f5f5f5; }
        .container { max-width: 800px; background: white; padding: 20px; border-radius: 10px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
        .test-box { background: #f8f9fa; border: 1px solid #dee2e6; border-radius: 5px; padding: 15px; margin: 10px 0; }
        .success { background: #d4edda; border-color: #c3e6cb; color: #155724; }
        .error { background: #f8d7da; border-color: #f5c6cb; color: #721c24; }
        .info { background: #d1ecf1; border-color: #bee5eb; color: #0c5460; }
        input[type="text"] { padding: 10px; border: 1px solid #ccc; border-radius: 5px; width: 200px; }
        button { padding: 10px 20px; background: #007bff; color: white; border: none; border-radius: 5px; cursor: pointer; margin-left: 10px; }
        button:hover { background: #0056b3; }
        pre { background: #f8f9fa; padding: 10px; border-radius: 5px; overflow-x: auto; }
    </style>
</head>
<body>
    <div class="container">
        <h1>🎯 Final Referral Code Validation Test</h1>
        
        <div class="info">
            <h3>📋 Discovered Pattern:</h3>
            <p><strong>ALKI2315</strong> = <strong>AL</strong>(ain) + <strong>KI</strong>(tumaini) + <strong>23</strong>(user_id) + <strong>15</strong>(random)</p>
            <p>Pattern: First 2 letters of first name + First 2 letters of last name + User ID + Random 2 digits</p>
        </div>

        <?php
        // Show actual users that could generate codes
        $is_local = ($_SERVER['HTTP_HOST'] == 'localhost' || 
                    strpos($_SERVER['HTTP_HOST'], '127.0.0.1') !== false ||
                    strpos($_SERVER['HTTP_HOST'], '192.168.') !== false);

        if ($is_local) {
            $db_host = 'localhost'; $db_name = 'panadite_academy'; $db_user = 'root'; $db_pass = '';
        } else {
            $db_host = 'localhost'; $db_name = 'twpurnyc_panadite_DB'; $db_user = 'twpurnyc_149586Alain'; $db_pass = '149586Alain#';
        }

        try {
            $conn = new mysqli($db_host, $db_user, $db_pass, $db_name);
            if (!$conn->connect_error) {
                echo '<div class="info"><h3>👥 Sample Valid Referral Codes:</h3>';
                
                $query = "SELECT user_id, first_name, last_name, user_role FROM users WHERE user_role IN ('student', 'teacher') LIMIT 5";
                $result = $conn->query($query);
                
                if ($result && $result->num_rows > 0) {
                    echo '<ul>';
                    while ($user = $result->fetch_assoc()) {
                        $prefix = strtoupper(substr($user['first_name'], 0, 2) . substr($user['last_name'], 0, 2));
                        $sampleCode = $prefix . $user['user_id'] . '45'; // Use 45 as sample random
                        echo "<li><strong>{$sampleCode}</strong> → {$user['first_name']} {$user['last_name']} (ID: {$user['user_id']}, {$user['user_role']})</li>";
                    }
                    echo '</ul>';
                }
                echo '</div>';
            }
        } catch (Exception $e) {
            echo '<div class="error">Database connection failed</div>';
        }
        ?>

        <div class="test-box">
            <h3>🧪 Test Referral Code Validation</h3>
            <input type="text" id="testCode" placeholder="Enter referral code (e.g., ALKI2315)" value="ALKI2315">
            <button onclick="testValidation()">Validate Code</button>
            <div id="result" style="margin-top: 15px;"></div>
        </div>

        <div class="test-box">
            <h3>📝 Test Results Log</h3>
            <div id="testLog"></div>
        </div>
    </div>

    <script>
    let testCount = 0;
    
    function testValidation() {
        const code = document.getElementById('testCode').value.trim();
        const resultDiv = document.getElementById('result');
        const logDiv = document.getElementById('testLog');
        
        if (!code) {
            resultDiv.innerHTML = '<div class="error">Please enter a referral code</div>';
            return;
        }
        
        testCount++;
        resultDiv.innerHTML = '<div class="info">🔄 Testing referral code: <strong>' + code + '</strong>...</div>';
        
        const startTime = Date.now();
        
        fetch('validate_referral.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify({
                code: code
            })
        })
        .then(response => response.text())
        .then(text => {
            const endTime = Date.now();
            const duration = endTime - startTime;
            
            console.log('Raw response:', text);
            
            try {
                const data = JSON.parse(text);
                
                if (data.success) {
                    resultDiv.innerHTML = `
                        <div class="success">
                            <h4>✅ SUCCESS!</h4>
                            <p><strong>Referrer:</strong> ${data.referrer.name}</p>
                            <p><strong>Role:</strong> ${data.referrer.role}</p>
                            <p><strong>Reward:</strong> ${data.reward || 'N/A'}</p>
                        </div>`;
                        
                    logDiv.innerHTML = `<div class="success">Test ${testCount}: ✅ ${code} → Valid (${duration}ms)</div>` + logDiv.innerHTML;
                } else {
                    resultDiv.innerHTML = `
                        <div class="error">
                            <h4>❌ FAILED</h4>
                            <p><strong>Error:</strong> ${data.message}</p>
                        </div>`;
                        
                    logDiv.innerHTML = `<div class="error">Test ${testCount}: ❌ ${code} → ${data.message} (${duration}ms)</div>` + logDiv.innerHTML;
                }
            } catch (e) {
                resultDiv.innerHTML = `
                    <div class="error">
                        <h4>⚠️ JSON Parse Error</h4>
                        <p>The server returned invalid JSON. Raw response:</p>
                        <pre>${text}</pre>
                    </div>`;
                    
                logDiv.innerHTML = `<div class="error">Test ${testCount}: ⚠️ ${code} → JSON Parse Error (${duration}ms)</div>` + logDiv.innerHTML;
            }
        })
        .catch(error => {
            const endTime = Date.now();
            const duration = endTime - startTime;
            
            resultDiv.innerHTML = `
                <div class="error">
                    <h4>🔥 Network Error</h4>
                    <p>${error.message}</p>
                </div>`;
                
            logDiv.innerHTML = `<div class="error">Test ${testCount}: 🔥 ${code} → Network Error (${duration}ms)</div>` + logDiv.innerHTML;
            console.error('Error:', error);
        });
    }
    
    // Test with Enter key
    document.getElementById('testCode').addEventListener('keypress', function(e) {
        if (e.key === 'Enter') {
            testValidation();
        }
    });
    
    // Auto-test on page load
    window.onload = function() {
        setTimeout(() => {
            testValidation();
        }, 500);
    };
    </script>
</body>
</html>
