<?php
/**
 * Test the JSON input fix and find correct referral code pattern
 */

header('Content-Type: text/plain');
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "=== TESTING JSON INPUT FIX ===\n\n";

// Test 1: Test validation endpoint with JSON input
echo "Testing validation endpoint with JSON POST...\n";

$testCode = 'ALKI2315';
$postData = json_encode(['code' => $testCode]);

$context = stream_context_create([
    'http' => [
        'method' => 'POST',
        'header' => [
            'Content-Type: application/json',
            'Content-Length: ' . strlen($postData)
        ],
        'content' => $postData
    ]
]);

$url = 'http://' . $_SERVER['HTTP_HOST'] . dirname($_SERVER['REQUEST_URI']) . '/validate_referral.php';
$result = file_get_contents($url, false, $context);

echo "URL: $url\n";
echo "POST Data: $postData\n";
echo "Response: $result\n\n";

$decoded = json_decode($result, true);
if ($decoded) {
    echo "✓ JSON decoded successfully!\n";
    echo "Success: " . ($decoded['success'] ? 'true' : 'false') . "\n";
    echo "Message: " . ($decoded['message'] ?? 'N/A') . "\n\n";
} else {
    echo "✗ Failed to decode JSON\n\n";
}

// Test 2: Find the correct referral code pattern
echo "=== FINDING CORRECT REFERRAL CODE PATTERN ===\n";

// Database connection
$is_local = ($_SERVER['HTTP_HOST'] == 'localhost' || 
            strpos($_SERVER['HTTP_HOST'], '127.0.0.1') !== false ||
            strpos($_SERVER['HTTP_HOST'], '192.168.') !== false);

if ($is_local) {
    $db_host = 'localhost';
    $db_name = 'panadite_academy';
    $db_user = 'root';
    $db_pass = '';
} else {
    $db_host = 'localhost';
    $db_name = 'twpurnyc_panadite_DB';
    $db_user = 'twpurnyc_149586Alain';
    $db_pass = '149586Alain#';
}

try {
    $conn = new mysqli($db_host, $db_user, $db_pass, $db_name);
    if ($conn->connect_error) {
        throw new Exception("Connection failed: " . $conn->connect_error);
    }
    
    echo "✓ Database connected\n\n";
    
    // Find user ID 2315 (from ALKI2315)
    echo "Searching for user ID 2315 (from ALKI2315):\n";
    $userQuery = "SELECT user_id, username, first_name, last_name, user_role, email FROM users WHERE user_id = 2315";
    $result = $conn->query($userQuery);
    
    if ($result && $result->num_rows > 0) {
        $user = $result->fetch_assoc();
        echo "✓ Found user:\n";
        echo "  ID: {$user['user_id']}\n";
        echo "  Username: {$user['username']}\n";
        echo "  Name: {$user['first_name']} {$user['last_name']}\n";
        echo "  Email: {$user['email']}\n";
        echo "  Role: {$user['user_role']}\n\n";
        
        // Analyze how ALKI2315 could be generated
        echo "Analyzing how ALKI2315 could be generated:\n";
        
        $patterns = [];
        
        // Pattern 1: First 4 letters of first name + ID
        $pattern1 = strtoupper(substr($user['first_name'], 0, 4)) . $user['user_id'];
        $patterns[] = ['First name (4 chars)', $pattern1];
        
        // Pattern 2: First 4 letters of username + ID
        $pattern2 = strtoupper(substr($user['username'], 0, 4)) . $user['user_id'];
        $patterns[] = ['Username (4 chars)', $pattern2];
        
        // Pattern 3: First 2 + Last 2 letters of names + ID
        $pattern3 = strtoupper(substr($user['first_name'], 0, 2) . substr($user['last_name'], 0, 2)) . $user['user_id'];
        $patterns[] = ['First(2) + Last(2)', $pattern3];
        
        // Pattern 4: First 2 + Last 2 letters of email + ID
        $emailParts = explode('@', $user['email']);
        if (isset($emailParts[0])) {
            $pattern4 = strtoupper(substr($emailParts[0], 0, 4)) . $user['user_id'];
            $patterns[] = ['Email username (4 chars)', $pattern4];
        }
        
        foreach ($patterns as $patternInfo) {
            list($desc, $code) = $patternInfo;
            $match = ($code === 'ALKI2315') ? ' *** MATCH! ***' : '';
            echo "  $desc: $code$match\n";
        }
        
    } else {
        echo "✗ User ID 2315 not found\n";
        
        // Search for users with names/usernames that could generate ALKI
        echo "\nSearching for users that could generate 'ALKI':\n";
        $searchQuery = "SELECT user_id, username, first_name, last_name, user_role 
                        FROM users 
                        WHERE UPPER(SUBSTRING(first_name, 1, 4)) = 'ALKI' 
                        OR UPPER(SUBSTRING(username, 1, 4)) = 'ALKI'
                        OR UPPER(CONCAT(SUBSTRING(first_name, 1, 2), SUBSTRING(last_name, 1, 2))) = 'ALKI'
                        LIMIT 5";
        $searchResult = $conn->query($searchQuery);
        
        if ($searchResult && $searchResult->num_rows > 0) {
            while ($row = $searchResult->fetch_assoc()) {
                echo "  User {$row['user_id']}: {$row['first_name']} {$row['last_name']} ({$row['username']})\n";
                $possibleCode = strtoupper(substr($row['first_name'], 0, 4)) . $row['user_id'];
                echo "    → Possible code: $possibleCode\n";
            }
        } else {
            echo "  No matching users found\n";
        }
    }
    
    // Test 3: Check what's actually in student referrals page
    echo "\n=== CHECKING HOW STUDENT DASHBOARD GENERATES CODES ===\n";
    
    // Look at student referrals.php to see how it generates the code
    $studentReferralsFile = dirname(__DIR__) . '/student/referrals.php';
    if (file_exists($studentReferralsFile)) {
        echo "Found student referrals file: $studentReferralsFile\n";
        
        // Search for referral code generation in the file
        $fileContent = file_get_contents($studentReferralsFile);
        
        // Look for patterns that might generate referral codes
        if (strpos($fileContent, 'referral_code') !== false) {
            echo "File contains 'referral_code' references\n";
        }
        
        // Look for specific patterns
        $patterns = ['ALKI', 'KABR', 'strtoupper', 'substr'];
        foreach ($patterns as $pattern) {
            if (strpos($fileContent, $pattern) !== false) {
                echo "Found pattern '$pattern' in student referrals file\n";
            }
        }
    } else {
        echo "Student referrals file not found\n";
    }

} catch (Exception $e) {
    echo "Database error: " . $e->getMessage() . "\n";
}

echo "\n=== SUMMARY ===\n";
echo "1. JSON input fix should now allow proper validation\n";
echo "2. Need to identify correct referral code pattern for ALKI2315\n";
echo "3. Need to update referral code generation to match dashboard\n";
echo "4. Need to regenerate referral codes with correct pattern\n";
?>
