<?php
/**
 * Test script to verify that new users get their own referral codes created
 */

header('Content-Type: text/plain');
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "=== TESTING NEW USER REFERRAL CODE CREATION ===\n\n";

// Database configuration
$is_local = ($_SERVER['HTTP_HOST'] == 'localhost' || 
            strpos($_SERVER['HTTP_HOST'], '127.0.0.1') !== false ||
            strpos($_SERVER['HTTP_HOST'], '192.168.') !== false);

if ($is_local) {
    $db_host = 'localhost';
    $db_name = 'panadite_academy';
    $db_user = 'root';
    $db_pass = '';
} else {
    $db_host = 'localhost';
    $db_name = 'twpurnyc_panadite_DB';
    $db_user = 'twpurnyc_149586Alain';
    $db_pass = '149586Alain#';
}

try {
    $conn = new mysqli($db_host, $db_user, $db_pass, $db_name);
    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error . "\n");
    }
    
    echo "✓ Database connected: $db_name\n\n";

    // Test 1: Check if existing users have referral codes
    echo "=== TEST 1: CHECKING EXISTING USERS ===\n";
    
    $usersQuery = "SELECT u.user_id, u.username, u.user_role, u.first_name, u.last_name, u.created_at,
                          r.referral_code, r.status as referral_status
                   FROM users u 
                   LEFT JOIN referrals r ON u.user_id = r.referrer_id AND r.referrer_type = u.user_role
                   WHERE u.user_role IN ('teacher', 'student') 
                   ORDER BY u.created_at DESC 
                   LIMIT 10";
    
    $usersResult = $conn->query($usersQuery);
    
    if ($usersResult && $usersResult->num_rows > 0) {
        echo "Recent users and their referral codes:\n";
        while ($user = $usersResult->fetch_assoc()) {
            $hasCode = $user['referral_code'] ? "✓" : "✗";
            $code = $user['referral_code'] ?? 'NONE';
            echo "  $hasCode {$user['user_role']}: {$user['first_name']} {$user['last_name']} ({$user['username']}) → $code\n";
        }
    } else {
        echo "No users found\n";
    }
    
    // Test 2: Check referral code patterns
    echo "\n=== TEST 2: REFERRAL CODE PATTERNS ===\n";
    
    // Teacher codes
    $teacherCodesQuery = "SELECT r.referral_code, u.username, u.user_id 
                          FROM referrals r 
                          JOIN users u ON r.referrer_id = u.user_id 
                          WHERE r.referrer_type = 'teacher' 
                          LIMIT 5";
    $teacherResult = $conn->query($teacherCodesQuery);
    
    echo "Teacher referral codes:\n";
    if ($teacherResult && $teacherResult->num_rows > 0) {
        while ($row = $teacherResult->fetch_assoc()) {
            echo "  {$row['referral_code']} → {$row['username']} (ID: {$row['user_id']})\n";
        }
    } else {
        echo "  No teacher referral codes found\n";
    }
    
    // Student codes
    $studentCodesQuery = "SELECT r.referral_code, u.username, u.user_id 
                          FROM referrals r 
                          JOIN users u ON r.referrer_id = u.user_id 
                          WHERE r.referrer_type = 'student' 
                          LIMIT 5";
    $studentResult = $conn->query($studentCodesQuery);
    
    echo "\nStudent referral codes:\n";
    if ($studentResult && $studentResult->num_rows > 0) {
        while ($row = $studentResult->fetch_assoc()) {
            echo "  {$row['referral_code']} → {$row['username']} (ID: {$row['user_id']})\n";
        }
    } else {
        echo "  No student referral codes found\n";
    }
    
    // Test 3: Simulate referral code creation function
    echo "\n=== TEST 3: SIMULATING REFERRAL CODE GENERATION ===\n";
    
    function simulateReferralCode($userId, $role, $username) {
        $usernamePrefix = strtoupper(substr($username, 0, 2));
        
        if ($role === 'teacher') {
            return 'TBN' . $usernamePrefix . 'U' . $userId;
        } else {
            $code = 'KABR' . $usernamePrefix . $userId;
            if (strlen($code) > 10) {
                $code = 'KABR' . $userId;
            }
            return $code;
        }
    }
    
    // Test with sample users
    $sampleUsers = [
        ['id' => 1480, 'role' => 'teacher', 'username' => 'susan_teacher'],
        ['id' => 1545, 'role' => 'student', 'username' => 'john_student'],
        ['id' => 2001, 'role' => 'teacher', 'username' => 'mike_prof'],
        ['id' => 2002, 'role' => 'student', 'username' => 'alice_learner']
    ];
    
    echo "Sample referral code generation:\n";
    foreach ($sampleUsers as $user) {
        $code = simulateReferralCode($user['id'], $user['role'], $user['username']);
        echo "  {$user['role']} '{$user['username']}' (ID: {$user['id']}) → $code\n";
    }
    
    // Test 4: Check for users without referral codes
    echo "\n=== TEST 4: USERS WITHOUT REFERRAL CODES ===\n";
    
    $missingCodesQuery = "SELECT u.user_id, u.username, u.user_role, u.first_name, u.last_name 
                          FROM users u 
                          LEFT JOIN referrals r ON u.user_id = r.referrer_id AND r.referrer_type = u.user_role
                          WHERE u.user_role IN ('teacher', 'student') 
                          AND r.referral_code IS NULL 
                          LIMIT 5";
    
    $missingResult = $conn->query($missingCodesQuery);
    
    if ($missingResult && $missingResult->num_rows > 0) {
        echo "Users WITHOUT referral codes (need fixing):\n";
        while ($user = $missingResult->fetch_assoc()) {
            $expectedCode = simulateReferralCode($user['user_id'], $user['user_role'], $user['username']);
            echo "  ✗ {$user['user_role']}: {$user['first_name']} {$user['last_name']} ({$user['username']}) → should have: $expectedCode\n";
        }
    } else {
        echo "✓ All users have referral codes!\n";
    }
    
    // Test 5: Statistics
    echo "\n=== TEST 5: REFERRAL CODE STATISTICS ===\n";
    
    $statsQuery = "SELECT 
                       r.referrer_type,
                       COUNT(*) as total_codes,
                       MIN(r.created_at) as oldest_code,
                       MAX(r.created_at) as newest_code
                   FROM referrals r 
                   GROUP BY r.referrer_type";
    
    $statsResult = $conn->query($statsQuery);
    
    if ($statsResult && $statsResult->num_rows > 0) {
        while ($stat = $statsResult->fetch_assoc()) {
            echo "  {$stat['referrer_type']}: {$stat['total_codes']} codes (oldest: {$stat['oldest_code']}, newest: {$stat['newest_code']})\n";
        }
    }
    
    echo "\n=== SUMMARY ===\n";
    echo "✓ Email verification service updated to create referral codes for new users\n";
    echo "✓ Function createReferralCodeForNewUser() added\n";
    echo "✓ New registrations will automatically get referral codes\n";
    echo "✓ Validation endpoint will find codes for both old and new users\n";
    echo "\nNext: Test by registering a new user and verifying they get a referral code!\n";

} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
}
?>
