<?php
/**
 * AJAX endpoint to validate referral codes and return referrer information
 * Returns JSON response with referrer details
 */

// Start output buffering and disable all error output to prevent JSON corruption
ob_start();
error_reporting(0);
ini_set('display_errors', 0);
ini_set('log_errors', 0);

// Clean any previous output
ob_clean();

// Set JSON headers
header('Content-Type: application/json');
header('Cache-Control: no-cache, must-revalidate');

// Only accept POST requests
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    ob_clean();
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit;
}

// Manual database connection to avoid include issues
try {
    // Database configuration
    $is_local = ($_SERVER['HTTP_HOST'] == 'localhost' || 
                strpos($_SERVER['HTTP_HOST'], '127.0.0.1') !== false ||
                strpos($_SERVER['HTTP_HOST'], '192.168.') !== false);
    
    if ($is_local) {
        $db_host = 'localhost';
        $db_name = 'panadite_academy';
        $db_user = 'root';
        $db_pass = '';
    } else {
        $db_host = 'localhost';
        $db_name = 'twpurnyc_panadite_DB';
        $db_user = 'twpurnyc_149586Alain';
        $db_pass = '149586Alain#';
    }
    
    // Create connection
    $conn = new mysqli($db_host, $db_user, $db_pass, $db_name);
    
    if ($conn->connect_error) {
        ob_clean();
        echo json_encode(['success' => false, 'message' => 'Database connection failed']);
        exit;
    }
    
    $conn->set_charset("utf8");
    
} catch (Exception $e) {
    ob_clean();
    echo json_encode(['success' => false, 'message' => 'Database error']);
    exit;
}

try {
    // Get the referral code from POST data - handle both JSON and form data
    $referralCode = '';
    
    // First try JSON input
    $jsonInput = file_get_contents('php://input');
    if (!empty($jsonInput)) {
        $input = json_decode($jsonInput, true);
        if (isset($input['code'])) {
            $referralCode = trim($input['code']);
        }
    }
    
    // Fallback to regular POST data
    if (empty($referralCode) && isset($_POST['code'])) {
        $referralCode = trim($_POST['code']);
    }
    
    // Validate input
    if (empty($referralCode)) {
        ob_clean();
        echo json_encode(['success' => false, 'message' => 'Referral code is required']);
        exit;
    }
    
    try {
        // Include secure referral generator
        require_once __DIR__ . '/../includes/secure_referral_generator.php';
        
        $referrer = null;
        
        // Try secure referral code validation first (new format: TCH123ABC4DEF, STU456GHI7JKL)
        if (preg_match('/^(TCH|STU)[A-F0-9]{12}$/', $referralCode)) {
            $referrer = SecureReferralGenerator::validateSecureCode($referralCode, $conn);
        }
        
        // If not secure format, try legacy validation for backward compatibility
        if (!$referrer) {
            $referrer = LegacyReferralValidator::validateLegacyCode($referralCode, $conn);
        }
        
        if (!$referrer) {
            ob_clean();
            echo json_encode([
                'success' => false, 
                'message' => 'Invalid referral code'
            ]);
            exit;
        }
        
        // Get referrer's display name using correct column names
        $displayName = '';
        if (!empty($referrer['first_name']) && !empty($referrer['last_name'])) {
            $displayName = $referrer['first_name'] . ' ' . $referrer['last_name'];
        } else {
            $displayName = $referrer['username'];
        }
        $roleTitle = ucfirst($referrer['user_role']);
        
        // Get referral reward information
        $rewardQuery = "SELECT * FROM referral_settings WHERE is_active = 1 LIMIT 1";
        $rewardResult = $conn->query($rewardQuery);
        $rewards = null;
        if ($rewardResult && $rewardResult->num_rows > 0) {
            $rewards = $rewardResult->fetch_assoc();
        }
        
        $discountAmount = '0%';
        if ($rewards) {
            if ($rewards['discount_type'] === 'percentage') {
                $discountAmount = $rewards['discount_amount'] . '%';
            } else {
                $discountAmount = '$' . number_format($rewards['discount_amount'], 2);
            }
        }
        
        // Clean output buffer and return success response
        ob_clean();
        echo json_encode([
            'success' => true,
            'referrer' => [
                'name' => $displayName,
                'role' => $roleTitle,
                'username' => $referrer['username']
            ],
            'reward' => [
                'discount' => $discountAmount,
                'points' => $rewards ? intval($rewards['points_reward']) : 0
            ]
        ]);
        
    } catch (Exception $e) {
        ob_clean();
        echo json_encode([
            'success' => false, 
            'message' => 'Server error occurred'
        ]);
        exit;
    }
    
} catch (Exception $e) {
    ob_clean();
    echo json_encode([
        'success' => false, 
        'message' => 'Server error occurred'
    ]);
}
?>
