-- Database Backup - Generated on 2025-07-07 02:39:58
-- Tables: admin_profiles, assignment_submissions, assignments, backup_history, backup_settings, calendar_events, categories, comments, course_purchases, courses, enrollments, forum_replies, forum_topics, forums, messages, payfast_settings, quiz_answers, quiz_attempts, quiz_question_options, quiz_questions, quiz_responses, quiz_submissions, quizzes, ratings, settings, student_profiles, students, teacher_profiles, teacher_settings, teacher_student_assignments, teachers, users, video_purchases, video_views, videos

-- Table structure for table `admin_profiles`
DROP TABLE IF EXISTS `admin_profiles`;
CREATE TABLE `admin_profiles` (
  `admin_id` int(11) NOT NULL,
  `permissions` text DEFAULT NULL,
  PRIMARY KEY (`admin_id`),
  CONSTRAINT `admin_profiles_ibfk_1` FOREIGN KEY (`admin_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Data for table `admin_profiles`
INSERT INTO `admin_profiles` (`admin_id`, `permissions`) VALUES ('1', 'all');

-- Table structure for table `assignment_submissions`
DROP TABLE IF EXISTS `assignment_submissions`;
CREATE TABLE `assignment_submissions` (
  `submission_id` int(11) NOT NULL AUTO_INCREMENT,
  `assignment_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `submission_text` text DEFAULT NULL,
  `file_url` varchar(255) DEFAULT NULL,
  `submission_date` timestamp NOT NULL DEFAULT current_timestamp(),
  `grade` decimal(5,2) DEFAULT NULL,
  `feedback` text DEFAULT NULL,
  PRIMARY KEY (`submission_id`),
  UNIQUE KEY `student_id` (`student_id`,`assignment_id`),
  KEY `assignment_id` (`assignment_id`),
  CONSTRAINT `assignment_submissions_ibfk_1` FOREIGN KEY (`assignment_id`) REFERENCES `assignments` (`assignment_id`) ON DELETE CASCADE,
  CONSTRAINT `assignment_submissions_ibfk_2` FOREIGN KEY (`student_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Table structure for table `assignments`
DROP TABLE IF EXISTS `assignments`;
CREATE TABLE `assignments` (
  `assignment_id` int(11) NOT NULL AUTO_INCREMENT,
  `teacher_id` int(11) NOT NULL,
  `course_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `instructions` text DEFAULT NULL,
  `due_date` datetime DEFAULT NULL,
  `points` int(11) DEFAULT 10,
  `file_path` varchar(255) DEFAULT NULL,
  `allow_late` tinyint(1) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`assignment_id`),
  KEY `course_id` (`course_id`),
  KEY `teacher_id` (`teacher_id`),
  CONSTRAINT `assignments_ibfk_1` FOREIGN KEY (`course_id`) REFERENCES `courses` (`course_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Table structure for table `backup_history`
DROP TABLE IF EXISTS `backup_history`;
CREATE TABLE `backup_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `filename` varchar(255) NOT NULL,
  `format` varchar(10) NOT NULL,
  `tables` text NOT NULL,
  `size` varchar(20) NOT NULL,
  `created_at` datetime NOT NULL,
  `type` varchar(10) NOT NULL,
  `status` varchar(20) NOT NULL,
  `file_path` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Table structure for table `backup_settings`
DROP TABLE IF EXISTS `backup_settings`;
CREATE TABLE `backup_settings` (
  `id` int(11) NOT NULL,
  `frequency` varchar(20) NOT NULL,
  `format` varchar(10) NOT NULL,
  `tables` text DEFAULT NULL,
  `retention` int(11) NOT NULL DEFAULT 30,
  `last_backup` datetime DEFAULT NULL,
  `next_backup` datetime DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Data for table `backup_settings`
INSERT INTO `backup_settings` (`id`, `frequency`, `format`, `tables`, `retention`, `last_backup`, `next_backup`, `enabled`) VALUES ('1', 'weekly', 'sql', 'a:1:{i:0;s:5:\"users\";}', '1', NULL, '2025-07-14 02:33:31', '1');

-- Table structure for table `calendar_events`
DROP TABLE IF EXISTS `calendar_events`;
CREATE TABLE `calendar_events` (
  `event_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `course_id` int(11) DEFAULT NULL,
  `title` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `start_time` datetime NOT NULL,
  `end_time` datetime NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`event_id`),
  KEY `user_id` (`user_id`),
  KEY `course_id` (`course_id`),
  CONSTRAINT `calendar_events_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE,
  CONSTRAINT `calendar_events_ibfk_2` FOREIGN KEY (`course_id`) REFERENCES `courses` (`course_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Table structure for table `categories`
DROP TABLE IF EXISTS `categories`;
CREATE TABLE `categories` (
  `category_id` int(11) NOT NULL AUTO_INCREMENT,
  `category_name` varchar(100) NOT NULL,
  `description` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`category_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Data for table `categories`
INSERT INTO `categories` (`category_id`, `category_name`, `description`, `created_at`) VALUES ('1', 'Programming', 'Learn programming languages and software development', '2025-06-13 18:00:04');
INSERT INTO `categories` (`category_id`, `category_name`, `description`, `created_at`) VALUES ('2', 'Mathematics', 'Mathematics courses from basic to advanced', '2025-06-13 18:00:04');
INSERT INTO `categories` (`category_id`, `category_name`, `description`, `created_at`) VALUES ('3', 'Business', 'Business, management, and entrepreneurship', '2025-06-13 18:00:04');
INSERT INTO `categories` (`category_id`, `category_name`, `description`, `created_at`) VALUES ('4', 'Science', 'Physics, chemistry, biology and more', '2025-06-13 18:00:04');
INSERT INTO `categories` (`category_id`, `category_name`, `description`, `created_at`) VALUES ('5', 'Languages', 'Learn new languages', '2025-06-13 18:00:04');
INSERT INTO `categories` (`category_id`, `category_name`, `description`, `created_at`) VALUES ('6', 'Technology', 'Modern tech trends and applications', '2025-06-13 18:00:04');
INSERT INTO `categories` (`category_id`, `category_name`, `description`, `created_at`) VALUES ('7', 'Arts', 'Creative arts and design principles', '2025-06-13 18:00:04');

-- Table structure for table `comments`
DROP TABLE IF EXISTS `comments`;
CREATE TABLE `comments` (
  `comment_id` int(11) NOT NULL AUTO_INCREMENT,
  `video_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `comment_text` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`comment_id`),
  KEY `video_id` (`video_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `comments_ibfk_1` FOREIGN KEY (`video_id`) REFERENCES `videos` (`video_id`) ON DELETE CASCADE,
  CONSTRAINT `comments_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Table structure for table `course_purchases`
DROP TABLE IF EXISTS `course_purchases`;
CREATE TABLE `course_purchases` (
  `purchase_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `course_id` int(11) NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `payment_id` varchar(255) NOT NULL,
  `payment_status` enum('pending','completed','failed') DEFAULT 'pending',
  `purchase_date` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`purchase_id`),
  UNIQUE KEY `user_id` (`user_id`,`course_id`),
  KEY `course_id` (`course_id`),
  CONSTRAINT `course_purchases_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE,
  CONSTRAINT `course_purchases_ibfk_2` FOREIGN KEY (`course_id`) REFERENCES `courses` (`course_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Table structure for table `courses`
DROP TABLE IF EXISTS `courses`;
CREATE TABLE `courses` (
  `course_id` int(11) NOT NULL AUTO_INCREMENT,
  `teacher_id` int(11) NOT NULL,
  `category_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `thumbnail` varchar(255) DEFAULT NULL,
  `price` decimal(10,2) DEFAULT 0.00,
  `is_published` tinyint(1) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `is_approved` tinyint(1) DEFAULT NULL COMMENT 'NULL=auto approved (legacy), 0=pending, 1=approved',
  PRIMARY KEY (`course_id`),
  KEY `teacher_id` (`teacher_id`),
  KEY `category_id` (`category_id`),
  CONSTRAINT `courses_ibfk_1` FOREIGN KEY (`teacher_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE,
  CONSTRAINT `courses_ibfk_2` FOREIGN KEY (`category_id`) REFERENCES `categories` (`category_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Data for table `courses`
INSERT INTO `courses` (`course_id`, `teacher_id`, `category_id`, `title`, `description`, `thumbnail`, `price`, `is_published`, `created_at`, `updated_at`, `is_approved`) VALUES ('19', '12', '6', 'Computer and MS Office 365', 'End-User Computing: Computer, Excel, Word , PowerPoint, Outlook', '../uploads/thumbnails/course_1751647190_686803d60c6ca.jpeg', '3750.00', '1', '2025-07-04 18:39:50', '2025-07-06 22:25:27', NULL);
INSERT INTO `courses` (`course_id`, `teacher_id`, `category_id`, `title`, `description`, `thumbnail`, `price`, `is_published`, `created_at`, `updated_at`, `is_approved`) VALUES ('20', '12', '6', 'Data Capturing', '\"Learn how to collect, record, and manage information accurately and efficiently – essential skills for any admin or data-driven role.\"\r\n\r\nOr a slightly more casual one:\r\n\r\n\"Take this course to master the basics of data capturing – from typing and forms to organizing records professionally.\"', '../uploads/thumbnails/course_1751647516_6868051cb8666.jpeg', '4900.00', '0', '2025-07-04 18:45:17', '2025-07-04 18:45:17', NULL);
INSERT INTO `courses` (`course_id`, `teacher_id`, `category_id`, `title`, `description`, `thumbnail`, `price`, `is_published`, `created_at`, `updated_at`, `is_approved`) VALUES ('21', '12', '6', 'Front-End Web development', '\"Learn to build visually engaging and interactive websites using HTML, CSS, and JavaScript – the core skills behind every modern website.\"\r\n\r\nOr a slightly more beginner-friendly version:\r\n\r\n\"Start your journey into web development by learning how to design and code the part of websites users see and interact with.\"\r\n\r\nLet me know if you\'d like a version tailored for a course form, poster, or registration page!', '../uploads/thumbnails/course_1751647738_686805fa7a39d.png', '4750.00', '0', '2025-07-04 18:48:58', '2025-07-04 18:48:58', NULL);
INSERT INTO `courses` (`course_id`, `teacher_id`, `category_id`, `title`, `description`, `thumbnail`, `price`, `is_published`, `created_at`, `updated_at`, `is_approved`) VALUES ('22', '12', '6', 'PowerBi Analytics', '\"Learn how to turn raw data into powerful insights using Power BI. Gain skills in data visualization, dashboard creation, and real-time analytics for smarter decision-making.\"\r\n\r\nBeginner-friendly tone:\r\n\r\n\"Discover how to use Power BI to create interactive reports and dashboards. Learn to make sense of data and share insights with your team or clients.\"\r\n\r\nWould you like one that fits a specific target group like businesses, students, or job seekers?', '../uploads/thumbnails/course_1751647868_6868067cef360.jpeg', '3499.00', '0', '2025-07-04 18:51:08', '2025-07-04 18:51:08', NULL);
INSERT INTO `courses` (`course_id`, `teacher_id`, `category_id`, `title`, `description`, `thumbnail`, `price`, `is_published`, `created_at`, `updated_at`, `is_approved`) VALUES ('23', '12', '6', 'Data Analytics', '\"Develop the skills to collect, analyze, and interpret data to drive informed business decisions. This course covers essential tools and techniques used in modern data analytics.\"\r\n\r\nBeginner-friendly tone:\r\n\r\n\"Learn how to understand and work with data to uncover patterns, solve problems, and support smart decision-making across any field.\"\r\n\r\nCareer-focused tone:\r\n\r\n\"Kickstart your career in data with practical analytics skills – from spreadsheets to visualizations – and learn how to turn numbers into knowledge.\"\r\n\r\nLet me know if you want one tailored for marketing, finance, health, or another industry.', '../uploads/thumbnails/course_1751647994_686806fae63f2.jpeg', '5499.00', '0', '2025-07-04 18:53:15', '2025-07-04 18:53:15', NULL);
INSERT INTO `courses` (`course_id`, `teacher_id`, `category_id`, `title`, `description`, `thumbnail`, `price`, `is_published`, `created_at`, `updated_at`, `is_approved`) VALUES ('24', '12', '6', 'Python Programming', '\"Learn the fundamentals of Python, one of the most powerful and versatile programming languages used in web development, data science, automation, and more.\"\r\n\r\nBeginner-friendly tone:\r\n\r\n\"Start coding with Python – an easy-to-learn language used for apps, games, websites, and data. No experience needed!\"\r\n\r\nCareer-focused tone:\r\n\r\n\"Master Python programming and open doors to careers in tech, data analysis, software development, and automation.\"\r\n\r\nWould you like one specifically aimed at teens, job seekers, or professionals transitioning into tech?', '../uploads/thumbnails/course_1751648106_6868076abb15f.jpeg', '5350.00', '0', '2025-07-04 18:55:07', '2025-07-04 18:55:07', NULL);
INSERT INTO `courses` (`course_id`, `teacher_id`, `category_id`, `title`, `description`, `thumbnail`, `price`, `is_published`, `created_at`, `updated_at`, `is_approved`) VALUES ('25', '12', '6', 'IT System Development', '\"Gain a solid understanding of how to design, develop, and manage IT systems that support business operations, user needs, and digital transformation.\"\r\n\r\nBeginner-friendly tone:\r\n\r\n\"Learn how IT systems are planned and built – from ideas and designs to real-world software and solutions.\"\r\n\r\nCareer-focused tone:\r\n\r\n\"Build the skills to develop IT systems that power businesses – and start your journey toward becoming a systems analyst, developer, or IT project manager.\"\r\n\r\nWould you like one that focuses more on software development, business systems, or database integration?', '../uploads/thumbnails/course_1751648252_686807fc9172c.jpeg', '6999.00', '0', '2025-07-04 18:57:33', '2025-07-04 18:57:33', NULL);
INSERT INTO `courses` (`course_id`, `teacher_id`, `category_id`, `title`, `description`, `thumbnail`, `price`, `is_published`, `created_at`, `updated_at`, `is_approved`) VALUES ('26', '12', '6', 'IT Technical Support', '\"Learn how to provide effective technical support by diagnosing issues, maintaining hardware and software, and assisting users in a fast-paced IT environment.\"\r\n\r\nBeginner-friendly tone:\r\n\r\n\"Start your IT journey by learning how to help others solve computer problems, set up systems, and keep technology running smoothly.\"\r\n\r\nCareer-focused tone:\r\n\r\n\"Develop hands-on skills in troubleshooting, system setup, and user support – essential for entry-level roles in IT support and help desk services.\"\r\n\r\nWould you like a version tailored for a training brochure, job-readiness program, or internal staff development?', '../uploads/thumbnails/course_1751648376_6868087809f52.jpeg', '6999.00', '0', '2025-07-04 18:59:36', '2025-07-04 18:59:36', NULL);

-- Table structure for table `enrollments`
DROP TABLE IF EXISTS `enrollments`;
CREATE TABLE `enrollments` (
  `enrollment_id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `course_id` int(11) NOT NULL,
  `enrolled_date` timestamp NOT NULL DEFAULT current_timestamp(),
  `progress` int(11) DEFAULT 0,
  PRIMARY KEY (`enrollment_id`),
  UNIQUE KEY `student_id` (`student_id`,`course_id`),
  KEY `course_id` (`course_id`),
  CONSTRAINT `enrollments_ibfk_1` FOREIGN KEY (`student_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE,
  CONSTRAINT `enrollments_ibfk_2` FOREIGN KEY (`course_id`) REFERENCES `courses` (`course_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Data for table `enrollments`
INSERT INTO `enrollments` (`enrollment_id`, `student_id`, `user_id`, `course_id`, `enrolled_date`, `progress`) VALUES ('5', '11', '0', '21', '2025-07-05 14:47:33', '0');
INSERT INTO `enrollments` (`enrollment_id`, `student_id`, `user_id`, `course_id`, `enrolled_date`, `progress`) VALUES ('6', '11', '0', '20', '2025-07-05 14:53:50', '0');
INSERT INTO `enrollments` (`enrollment_id`, `student_id`, `user_id`, `course_id`, `enrolled_date`, `progress`) VALUES ('7', '11', '0', '22', '2025-07-05 16:45:09', '0');
INSERT INTO `enrollments` (`enrollment_id`, `student_id`, `user_id`, `course_id`, `enrolled_date`, `progress`) VALUES ('8', '11', '0', '26', '2025-07-06 20:07:18', '0');
INSERT INTO `enrollments` (`enrollment_id`, `student_id`, `user_id`, `course_id`, `enrolled_date`, `progress`) VALUES ('9', '11', '0', '25', '2025-07-06 20:18:44', '0');

-- Table structure for table `forum_replies`
DROP TABLE IF EXISTS `forum_replies`;
CREATE TABLE `forum_replies` (
  `reply_id` int(11) NOT NULL AUTO_INCREMENT,
  `topic_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `content` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`reply_id`),
  KEY `topic_id` (`topic_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `forum_replies_ibfk_1` FOREIGN KEY (`topic_id`) REFERENCES `forum_topics` (`topic_id`) ON DELETE CASCADE,
  CONSTRAINT `forum_replies_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Table structure for table `forum_topics`
DROP TABLE IF EXISTS `forum_topics`;
CREATE TABLE `forum_topics` (
  `topic_id` int(11) NOT NULL AUTO_INCREMENT,
  `forum_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `content` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`topic_id`),
  KEY `forum_id` (`forum_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `forum_topics_ibfk_1` FOREIGN KEY (`forum_id`) REFERENCES `forums` (`forum_id`) ON DELETE CASCADE,
  CONSTRAINT `forum_topics_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Table structure for table `forums`
DROP TABLE IF EXISTS `forums`;
CREATE TABLE `forums` (
  `forum_id` int(11) NOT NULL AUTO_INCREMENT,
  `course_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`forum_id`),
  KEY `course_id` (`course_id`),
  CONSTRAINT `forums_ibfk_1` FOREIGN KEY (`course_id`) REFERENCES `courses` (`course_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Table structure for table `messages`
DROP TABLE IF EXISTS `messages`;
CREATE TABLE `messages` (
  `message_id` int(11) NOT NULL AUTO_INCREMENT,
  `sender_id` int(11) NOT NULL,
  `recipient_id` int(11) NOT NULL,
  `message_text` text NOT NULL,
  `is_read` tinyint(1) DEFAULT 0,
  `sent_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`message_id`),
  KEY `sender_id` (`sender_id`),
  KEY `recipient_id` (`recipient_id`),
  CONSTRAINT `messages_ibfk_1` FOREIGN KEY (`sender_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE,
  CONSTRAINT `messages_ibfk_2` FOREIGN KEY (`recipient_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Table structure for table `payfast_settings`
DROP TABLE IF EXISTS `payfast_settings`;
CREATE TABLE `payfast_settings` (
  `setting_id` int(11) NOT NULL AUTO_INCREMENT,
  `merchant_id` varchar(50) NOT NULL,
  `merchant_key` varchar(50) NOT NULL,
  `passphrase` varchar(255) DEFAULT NULL,
  `sandbox_mode` tinyint(1) DEFAULT 1,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`setting_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Data for table `payfast_settings`
INSERT INTO `payfast_settings` (`setting_id`, `merchant_id`, `merchant_key`, `passphrase`, `sandbox_mode`, `updated_at`) VALUES ('1', '10038898', 'jkeryt8c9i8sy', NULL, '1', '2025-06-13 18:00:04');

-- Table structure for table `quiz_answers`
DROP TABLE IF EXISTS `quiz_answers`;
CREATE TABLE `quiz_answers` (
  `answer_id` int(11) NOT NULL AUTO_INCREMENT,
  `submission_id` int(11) NOT NULL,
  `question_id` int(11) NOT NULL,
  `selected_option_id` int(11) DEFAULT NULL,
  `text_answer` text DEFAULT NULL,
  `is_correct` tinyint(1) DEFAULT 0,
  `points_earned` decimal(5,2) DEFAULT 0.00,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`answer_id`),
  KEY `submission_id` (`submission_id`),
  KEY `question_id` (`question_id`),
  KEY `selected_option_id` (`selected_option_id`),
  CONSTRAINT `quiz_answers_ibfk_1` FOREIGN KEY (`submission_id`) REFERENCES `quiz_submissions` (`submission_id`) ON DELETE CASCADE,
  CONSTRAINT `quiz_answers_ibfk_2` FOREIGN KEY (`question_id`) REFERENCES `quiz_questions` (`question_id`) ON DELETE CASCADE,
  CONSTRAINT `quiz_answers_ibfk_3` FOREIGN KEY (`selected_option_id`) REFERENCES `quiz_question_options` (`option_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Table structure for table `quiz_attempts`
DROP TABLE IF EXISTS `quiz_attempts`;
CREATE TABLE `quiz_attempts` (
  `attempt_id` int(11) NOT NULL AUTO_INCREMENT,
  `quiz_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `start_time` datetime NOT NULL,
  `end_time` datetime DEFAULT NULL,
  `score` int(11) DEFAULT NULL,
  `pass_status` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`attempt_id`),
  KEY `quiz_id` (`quiz_id`),
  KEY `student_id` (`student_id`),
  CONSTRAINT `quiz_attempts_ibfk_1` FOREIGN KEY (`quiz_id`) REFERENCES `quizzes` (`quiz_id`) ON DELETE CASCADE,
  CONSTRAINT `quiz_attempts_ibfk_2` FOREIGN KEY (`student_id`) REFERENCES `students` (`student_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Table structure for table `quiz_question_options`
DROP TABLE IF EXISTS `quiz_question_options`;
CREATE TABLE `quiz_question_options` (
  `option_id` int(11) NOT NULL AUTO_INCREMENT,
  `question_id` int(11) NOT NULL,
  `option_text` text NOT NULL,
  `is_correct` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`option_id`),
  KEY `question_id` (`question_id`),
  CONSTRAINT `quiz_question_options_ibfk_1` FOREIGN KEY (`question_id`) REFERENCES `quiz_questions` (`question_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Data for table `quiz_question_options`
INSERT INTO `quiz_question_options` (`option_id`, `question_id`, `option_text`, `is_correct`, `created_at`) VALUES ('5', '3', 'whcih is whcih', '1', '2025-07-05 12:51:26');
INSERT INTO `quiz_question_options` (`option_id`, `question_id`, `option_text`, `is_correct`, `created_at`) VALUES ('6', '3', 'long for', '0', '2025-07-05 12:51:26');

-- Table structure for table `quiz_questions`
DROP TABLE IF EXISTS `quiz_questions`;
CREATE TABLE `quiz_questions` (
  `question_id` int(11) NOT NULL AUTO_INCREMENT,
  `quiz_id` int(11) NOT NULL,
  `question_text` text NOT NULL,
  `question_type` enum('multiple_choice','true_false','short_answer') NOT NULL DEFAULT 'multiple_choice',
  `points` int(11) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`question_id`),
  KEY `quiz_id` (`quiz_id`),
  CONSTRAINT `quiz_questions_ibfk_1` FOREIGN KEY (`quiz_id`) REFERENCES `quizzes` (`quiz_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Data for table `quiz_questions`
INSERT INTO `quiz_questions` (`question_id`, `quiz_id`, `question_text`, `question_type`, `points`, `created_at`) VALUES ('3', '3', 'Welcome who are you?', 'multiple_choice', '45', '2025-07-05 12:51:26');

-- Table structure for table `quiz_responses`
DROP TABLE IF EXISTS `quiz_responses`;
CREATE TABLE `quiz_responses` (
  `response_id` int(11) NOT NULL AUTO_INCREMENT,
  `attempt_id` int(11) NOT NULL,
  `question_id` int(11) NOT NULL,
  `answer_id` int(11) DEFAULT NULL,
  `text_response` text DEFAULT NULL,
  `is_correct` tinyint(1) DEFAULT NULL,
  `points_earned` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`response_id`),
  KEY `attempt_id` (`attempt_id`),
  KEY `question_id` (`question_id`),
  KEY `answer_id` (`answer_id`),
  CONSTRAINT `quiz_responses_ibfk_1` FOREIGN KEY (`attempt_id`) REFERENCES `quiz_attempts` (`attempt_id`) ON DELETE CASCADE,
  CONSTRAINT `quiz_responses_ibfk_2` FOREIGN KEY (`question_id`) REFERENCES `quiz_questions` (`question_id`) ON DELETE CASCADE,
  CONSTRAINT `quiz_responses_ibfk_3` FOREIGN KEY (`answer_id`) REFERENCES `quiz_answers` (`answer_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Table structure for table `quiz_submissions`
DROP TABLE IF EXISTS `quiz_submissions`;
CREATE TABLE `quiz_submissions` (
  `submission_id` int(11) NOT NULL AUTO_INCREMENT,
  `quiz_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `score` decimal(5,2) NOT NULL DEFAULT 0.00,
  `total_points` int(11) NOT NULL DEFAULT 0,
  `start_time` timestamp NULL DEFAULT NULL,
  `end_time` timestamp NULL DEFAULT NULL,
  `status` enum('in_progress','completed','expired') NOT NULL DEFAULT 'in_progress',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`submission_id`),
  KEY `quiz_id` (`quiz_id`),
  KEY `student_id` (`student_id`),
  CONSTRAINT `quiz_submissions_ibfk_1` FOREIGN KEY (`quiz_id`) REFERENCES `quizzes` (`quiz_id`) ON DELETE CASCADE,
  CONSTRAINT `quiz_submissions_ibfk_2` FOREIGN KEY (`student_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Table structure for table `quizzes`
DROP TABLE IF EXISTS `quizzes`;
CREATE TABLE `quizzes` (
  `quiz_id` int(11) NOT NULL AUTO_INCREMENT,
  `teacher_id` int(11) NOT NULL,
  `course_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `time_limit` int(11) DEFAULT 30,
  `passing_score` int(11) DEFAULT 60,
  `is_published` tinyint(1) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`quiz_id`),
  KEY `teacher_id` (`teacher_id`),
  KEY `course_id` (`course_id`),
  CONSTRAINT `quizzes_ibfk_1` FOREIGN KEY (`teacher_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE,
  CONSTRAINT `quizzes_ibfk_2` FOREIGN KEY (`course_id`) REFERENCES `courses` (`course_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Data for table `quizzes`
INSERT INTO `quizzes` (`quiz_id`, `teacher_id`, `course_id`, `title`, `description`, `time_limit`, `passing_score`, `is_published`, `created_at`, `updated_at`) VALUES ('3', '12', '21', 'Web development HTML', 'Welcome', '30', '60', '1', '2025-07-05 12:51:26', '2025-07-05 12:51:26');

-- Table structure for table `ratings`
DROP TABLE IF EXISTS `ratings`;
CREATE TABLE `ratings` (
  `rating_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `course_id` int(11) DEFAULT NULL,
  `video_id` int(11) DEFAULT NULL,
  `rating` decimal(2,1) NOT NULL,
  `review` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`rating_id`),
  KEY `user_id` (`user_id`),
  KEY `course_id` (`course_id`),
  KEY `video_id` (`video_id`),
  CONSTRAINT `ratings_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE,
  CONSTRAINT `ratings_ibfk_2` FOREIGN KEY (`course_id`) REFERENCES `courses` (`course_id`) ON DELETE CASCADE,
  CONSTRAINT `ratings_ibfk_3` FOREIGN KEY (`video_id`) REFERENCES `videos` (`video_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Table structure for table `settings`
DROP TABLE IF EXISTS `settings`;
CREATE TABLE `settings` (
  `setting_id` int(11) NOT NULL AUTO_INCREMENT,
  `setting_name` varchar(100) NOT NULL,
  `setting_value` text DEFAULT NULL,
  `setting_group` varchar(50) DEFAULT 'general',
  `is_public` tinyint(1) DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`setting_id`),
  UNIQUE KEY `setting_name` (`setting_name`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Data for table `settings`
INSERT INTO `settings` (`setting_id`, `setting_name`, `setting_value`, `setting_group`, `is_public`, `created_at`, `updated_at`) VALUES ('1', 'site_name', 'Panadite Academy', 'general', '1', '2025-06-17 08:40:54', '2025-06-17 08:40:54');
INSERT INTO `settings` (`setting_id`, `setting_name`, `setting_value`, `setting_group`, `is_public`, `created_at`, `updated_at`) VALUES ('2', 'site_description', 'Online Learning Platform for Everyone', 'general', '1', '2025-06-17 08:40:54', '2025-06-17 08:40:54');
INSERT INTO `settings` (`setting_id`, `setting_name`, `setting_value`, `setting_group`, `is_public`, `created_at`, `updated_at`) VALUES ('3', 'contact_email', 'contact@panaditeeacademy.com', 'contact', '1', '2025-06-17 08:40:54', '2025-06-17 08:40:54');
INSERT INTO `settings` (`setting_id`, `setting_name`, `setting_value`, `setting_group`, `is_public`, `created_at`, `updated_at`) VALUES ('4', 'currency', 'USD', 'payment', '1', '2025-06-17 08:40:54', '2025-06-17 08:40:54');
INSERT INTO `settings` (`setting_id`, `setting_name`, `setting_value`, `setting_group`, `is_public`, `created_at`, `updated_at`) VALUES ('5', 'currency_symbol', '$', 'payment', '1', '2025-06-17 08:40:54', '2025-06-17 08:40:54');
INSERT INTO `settings` (`setting_id`, `setting_name`, `setting_value`, `setting_group`, `is_public`, `created_at`, `updated_at`) VALUES ('6', 'max_upload_size', '512000000', 'upload', '0', '2025-06-17 08:40:54', '2025-06-17 08:40:54');
INSERT INTO `settings` (`setting_id`, `setting_name`, `setting_value`, `setting_group`, `is_public`, `created_at`, `updated_at`) VALUES ('7', 'allowed_video_extensions', 'mp4,webm,mov,avi', 'upload', '0', '2025-06-17 08:40:54', '2025-06-17 08:40:54');
INSERT INTO `settings` (`setting_id`, `setting_name`, `setting_value`, `setting_group`, `is_public`, `created_at`, `updated_at`) VALUES ('8', 'allowed_document_extensions', 'pdf,doc,docx,ppt,pptx,xls,xlsx,txt', 'upload', '0', '2025-06-17 08:40:54', '2025-06-17 08:40:54');
INSERT INTO `settings` (`setting_id`, `setting_name`, `setting_value`, `setting_group`, `is_public`, `created_at`, `updated_at`) VALUES ('9', 'allowed_image_extensions', 'jpg,jpeg,png,gif,webp', 'upload', '0', '2025-06-17 08:40:54', '2025-06-17 08:40:54');
INSERT INTO `settings` (`setting_id`, `setting_name`, `setting_value`, `setting_group`, `is_public`, `created_at`, `updated_at`) VALUES ('10', 'theme_color', '#4f46e5', 'appearance', '1', '2025-06-17 08:40:54', '2025-06-17 08:40:54');

-- Table structure for table `student_profiles`
DROP TABLE IF EXISTS `student_profiles`;
CREATE TABLE `student_profiles` (
  `student_id` int(11) NOT NULL,
  `bio` text DEFAULT NULL,
  PRIMARY KEY (`student_id`),
  CONSTRAINT `student_profiles_ibfk_1` FOREIGN KEY (`student_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Data for table `student_profiles`
INSERT INTO `student_profiles` (`student_id`, `bio`) VALUES ('4', 'Studying computer science and eager to learn new programming languages');
INSERT INTO `student_profiles` (`student_id`, `bio`) VALUES ('5', 'Business major with interest in entrepreneurship and marketing');
INSERT INTO `student_profiles` (`student_id`, `bio`) VALUES ('7', NULL);
INSERT INTO `student_profiles` (`student_id`, `bio`) VALUES ('14', NULL);
INSERT INTO `student_profiles` (`student_id`, `bio`) VALUES ('15', NULL);

-- Table structure for table `students`
DROP TABLE IF EXISTS `students`;
CREATE TABLE `students` (
  `student_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `first_name` varchar(50) NOT NULL,
  `last_name` varchar(50) NOT NULL,
  `profile_picture` varchar(255) DEFAULT NULL,
  `bio` text DEFAULT NULL,
  `education` varchar(255) DEFAULT NULL,
  `interests` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`student_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `students_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Data for table `students`
INSERT INTO `students` (`student_id`, `user_id`, `first_name`, `last_name`, `profile_picture`, `bio`, `education`, `interests`, `created_at`, `updated_at`) VALUES ('1', '7', 'Sample', 'Student', NULL, NULL, NULL, NULL, '2025-06-17 09:46:05', '2025-06-17 09:46:05');

-- Table structure for table `teacher_profiles`
DROP TABLE IF EXISTS `teacher_profiles`;
CREATE TABLE `teacher_profiles` (
  `teacher_id` int(11) NOT NULL,
  `bio` text DEFAULT NULL,
  `qualifications` text DEFAULT NULL,
  `expertise` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`teacher_id`),
  CONSTRAINT `teacher_profiles_ibfk_1` FOREIGN KEY (`teacher_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Data for table `teacher_profiles`
INSERT INTO `teacher_profiles` (`teacher_id`, `bio`, `qualifications`, `expertise`) VALUES ('2', 'Experienced programming instructor with 10 years of teaching experience', 'MSc Computer Science, Certified Software Developer', 'Python, JavaScript, Web Development');
INSERT INTO `teacher_profiles` (`teacher_id`, `bio`, `qualifications`, `expertise`) VALUES ('3', 'Math and Science teacher with passion for making difficult concepts easy to understand', 'PhD Mathematics, Science Education Certification', 'Mathematics, Physics, Chemistry');
INSERT INTO `teacher_profiles` (`teacher_id`, `bio`, `qualifications`, `expertise`) VALUES ('6', NULL, NULL, NULL);

-- Table structure for table `teacher_settings`
DROP TABLE IF EXISTS `teacher_settings`;
CREATE TABLE `teacher_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `email_notifications` tinyint(1) DEFAULT 1,
  `sms_notifications` tinyint(1) DEFAULT 0,
  `dashboard_theme` varchar(20) DEFAULT 'light',
  `timezone` varchar(50) DEFAULT 'UTC',
  `language` varchar(10) DEFAULT 'en',
  `enable_2fa` tinyint(1) DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Data for table `teacher_settings`
INSERT INTO `teacher_settings` (`id`, `user_id`, `email_notifications`, `sms_notifications`, `dashboard_theme`, `timezone`, `language`, `enable_2fa`) VALUES ('1', '2', '1', '0', 'light', 'UTC', 'en', '0');
INSERT INTO `teacher_settings` (`id`, `user_id`, `email_notifications`, `sms_notifications`, `dashboard_theme`, `timezone`, `language`, `enable_2fa`) VALUES ('2', '3', '1', '0', 'light', 'UTC', 'en', '0');
INSERT INTO `teacher_settings` (`id`, `user_id`, `email_notifications`, `sms_notifications`, `dashboard_theme`, `timezone`, `language`, `enable_2fa`) VALUES ('3', '6', '1', '0', 'light', 'UTC', 'en', '0');

-- Table structure for table `teacher_student_assignments`
DROP TABLE IF EXISTS `teacher_student_assignments`;
CREATE TABLE `teacher_student_assignments` (
  `assignment_id` int(11) NOT NULL AUTO_INCREMENT,
  `teacher_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `assigned_by` int(11) NOT NULL COMMENT 'Admin ID who made the assignment',
  `assigned_date` timestamp NOT NULL DEFAULT current_timestamp(),
  `status` enum('active','inactive') DEFAULT 'active',
  `notes` text DEFAULT NULL,
  PRIMARY KEY (`assignment_id`),
  UNIQUE KEY `teacher_id` (`teacher_id`,`student_id`),
  KEY `student_id` (`student_id`),
  KEY `assigned_by` (`assigned_by`),
  CONSTRAINT `teacher_student_assignments_ibfk_1` FOREIGN KEY (`teacher_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE,
  CONSTRAINT `teacher_student_assignments_ibfk_2` FOREIGN KEY (`student_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE,
  CONSTRAINT `teacher_student_assignments_ibfk_3` FOREIGN KEY (`assigned_by`) REFERENCES `users` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Table structure for table `teachers`
DROP TABLE IF EXISTS `teachers`;
CREATE TABLE `teachers` (
  `teacher_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `first_name` varchar(50) NOT NULL,
  `last_name` varchar(50) NOT NULL,
  `bio` text DEFAULT NULL,
  `expertise` varchar(255) DEFAULT NULL,
  `profile_picture` varchar(255) DEFAULT NULL,
  `website` varchar(255) DEFAULT NULL,
  `social_linkedin` varchar(255) DEFAULT NULL,
  `social_twitter` varchar(255) DEFAULT NULL,
  `social_facebook` varchar(255) DEFAULT NULL,
  `social_youtube` varchar(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`teacher_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `teachers_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Data for table `teachers`
INSERT INTO `teachers` (`teacher_id`, `user_id`, `first_name`, `last_name`, `bio`, `expertise`, `profile_picture`, `website`, `social_linkedin`, `social_twitter`, `social_facebook`, `social_youtube`, `created_at`, `updated_at`) VALUES ('1', '11', 'Murendeni', 'Baloyi', 'Experienced educator in Panadite Academy', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-06-17 09:46:05', '2025-06-17 09:46:05');

-- Table structure for table `users`
DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `user_id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(50) NOT NULL,
  `email` varchar(100) NOT NULL,
  `password` varchar(255) NOT NULL,
  `first_name` varchar(50) NOT NULL,
  `last_name` varchar(50) NOT NULL,
  `profile_picture` varchar(255) DEFAULT NULL,
  `user_role` enum('student','teacher','admin') NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `username` (`username`),
  UNIQUE KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Data for table `users`
INSERT INTO `users` (`user_id`, `username`, `email`, `password`, `first_name`, `last_name`, `profile_picture`, `user_role`, `created_at`, `updated_at`) VALUES ('1', 'admin', 'admin@panadite.com', '$2y$10$6Y5dkf5929ZqX.Y4zOEFgOKKVwOUtSRaRLugdSWwWgDqKZ80GNlGi', 'Admin', 'User', NULL, 'admin', '2025-06-13 18:00:04', '2025-06-13 18:00:04');
INSERT INTO `users` (`user_id`, `username`, `email`, `password`, `first_name`, `last_name`, `profile_picture`, `user_role`, `created_at`, `updated_at`) VALUES ('2', 'teacher1', 'teacher1@panadite.com', '$2y$10$6Y5dkf5929ZqX.Y4zOEFgOKKVwOUtSRaRLugdSWwWgDqKZ80GNlGi', 'John', 'Doe', NULL, 'teacher', '2025-06-13 18:00:04', '2025-06-13 18:00:04');
INSERT INTO `users` (`user_id`, `username`, `email`, `password`, `first_name`, `last_name`, `profile_picture`, `user_role`, `created_at`, `updated_at`) VALUES ('3', 'teacher2', 'teacher2@panadite.com', '$2y$10$6Y5dkf5929ZqX.Y4zOEFgOKKVwOUtSRaRLugdSWwWgDqKZ80GNlGi', 'Jane', 'Smith', NULL, 'teacher', '2025-06-13 18:00:04', '2025-06-13 18:00:04');
INSERT INTO `users` (`user_id`, `username`, `email`, `password`, `first_name`, `last_name`, `profile_picture`, `user_role`, `created_at`, `updated_at`) VALUES ('4', 'student1', 'student1@panadite.com', '$2y$10$6Y5dkf5929ZqX.Y4zOEFgOKKVwOUtSRaRLugdSWwWgDqKZ80GNlGi', 'Alex', 'Johnson', NULL, 'student', '2025-06-13 18:00:04', '2025-06-13 18:00:04');
INSERT INTO `users` (`user_id`, `username`, `email`, `password`, `first_name`, `last_name`, `profile_picture`, `user_role`, `created_at`, `updated_at`) VALUES ('5', 'student2', 'student2@panadite.com', '$2y$10$6Y5dkf5929ZqX.Y4zOEFgOKKVwOUtSRaRLugdSWwWgDqKZ80GNlGi', 'Sarah', 'Brown', NULL, 'student', '2025-06-13 18:00:04', '2025-06-13 18:00:04');
INSERT INTO `users` (`user_id`, `username`, `email`, `password`, `first_name`, `last_name`, `profile_picture`, `user_role`, `created_at`, `updated_at`) VALUES ('6', 'teacher', 'teacher@panadite.com', '$2y$10$Uy6GZ3gpmUTqf2fa3u3D0eDyxQkW.C2jlYG3aKxcFnncpsB2kBXtC', 'Teacher', 'User', NULL, 'teacher', '2025-06-14 14:11:31', '2025-06-14 14:11:31');
INSERT INTO `users` (`user_id`, `username`, `email`, `password`, `first_name`, `last_name`, `profile_picture`, `user_role`, `created_at`, `updated_at`) VALUES ('7', 'student', 'student@panadite.com', '$2y$10$2CftmDqdiL70IPQNqdbvfu9OtppSDieXIFQSvq.IeJS4ypK13x1Qa', 'Student', 'User', NULL, 'student', '2025-06-14 14:11:31', '2025-06-14 14:11:31');
INSERT INTO `users` (`user_id`, `username`, `email`, `password`, `first_name`, `last_name`, `profile_picture`, `user_role`, `created_at`, `updated_at`) VALUES ('8', 'teacher@panadite.com', 'alainkitumaini8@gmail.com', '$2y$10$ZSiyuiE0iKx6UPDek5I0k.lPVGb43gEvUv6cfiMNMTOSDX2cNJFmi', 'Alain', 'Kitumaini', NULL, 'teacher', '2025-06-15 17:05:50', '2025-06-15 17:05:50');
INSERT INTO `users` (`user_id`, `username`, `email`, `password`, `first_name`, `last_name`, `profile_picture`, `user_role`, `created_at`, `updated_at`) VALUES ('10', 'yes', 'futuristicpath357@gmail.com', '$2y$10$jFoWPu8iBmH94Kl98/9dW.Lfl2UacDBB7YBaLGrzhJ.K0M7lprKOC', 'alaink', 'k', NULL, 'teacher', '2025-06-17 09:05:50', '2025-06-17 09:05:50');
INSERT INTO `users` (`user_id`, `username`, `email`, `password`, `first_name`, `last_name`, `profile_picture`, `user_role`, `created_at`, `updated_at`) VALUES ('11', 'mbaloyi', 'murendeni.baloyi@panaditeacademy.com', '$2y$10$mwdAfZoxAxbn0ewrhQQbBuWQCu4NGpyGMXkjL5Gup.N59dtRx3gYq', 'Murendeni', 'Baloyi', NULL, 'student', '2025-06-17 09:21:06', '2025-06-17 09:21:06');
INSERT INTO `users` (`user_id`, `username`, `email`, `password`, `first_name`, `last_name`, `profile_picture`, `user_role`, `created_at`, `updated_at`) VALUES ('12', 'Sis', 'sis@gmail.com', '$2y$10$.p6KM18SDcrQGSRVTjWBmu306TcwMALd7VhXqohWS0ARJKE4Ftjze', 'Sis', 'Lorem', NULL, 'teacher', '2025-07-01 10:32:47', '2025-07-01 10:32:47');
INSERT INTO `users` (`user_id`, `username`, `email`, `password`, `first_name`, `last_name`, `profile_picture`, `user_role`, `created_at`, `updated_at`) VALUES ('13', 'lock', 'briasdn@gmail.com', '$2y$10$2s5/u/EhtlbOfAlIl/DEMO4QBC2hmVqMLpRkQuyfejOmbzTGTAUqO', 'Brian', 'Kahindo', NULL, 'teacher', '2025-07-02 05:34:03', '2025-07-02 05:34:03');
INSERT INTO `users` (`user_id`, `username`, `email`, `password`, `first_name`, `last_name`, `profile_picture`, `user_role`, `created_at`, `updated_at`) VALUES ('14', 'buss', 'bus@gmail.com', '$2y$10$XCLzNAvwgWBfnyO0PupQ.et.CySPlnmZVKUNeQyJbWHcTaTU06qB.', 'keko', 'dlkd', NULL, 'student', '2025-07-02 05:40:22', '2025-07-02 05:40:22');
INSERT INTO `users` (`user_id`, `username`, `email`, `password`, `first_name`, `last_name`, `profile_picture`, `user_role`, `created_at`, `updated_at`) VALUES ('15', 'rendygee', 'mercypraise09@gmail.com', '$2y$10$X2Gk4uOPYV6tUX7ubng6n.ZGuKjW7sP1ONlH8GPcNJDFcvav.cibO', 'Glander', 'Baloyi', NULL, 'student', '2025-07-04 19:59:30', '2025-07-04 19:59:30');

-- Table structure for table `video_purchases`
DROP TABLE IF EXISTS `video_purchases`;
CREATE TABLE `video_purchases` (
  `purchase_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `video_id` int(11) NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `payment_id` varchar(255) NOT NULL,
  `payment_status` enum('pending','completed','failed') DEFAULT 'pending',
  `purchase_date` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`purchase_id`),
  UNIQUE KEY `user_id` (`user_id`,`video_id`),
  KEY `video_id` (`video_id`),
  CONSTRAINT `video_purchases_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE,
  CONSTRAINT `video_purchases_ibfk_2` FOREIGN KEY (`video_id`) REFERENCES `videos` (`video_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Table structure for table `video_views`
DROP TABLE IF EXISTS `video_views`;
CREATE TABLE `video_views` (
  `view_id` int(11) NOT NULL AUTO_INCREMENT,
  `video_id` int(11) NOT NULL,
  `student_id` int(11) DEFAULT NULL,
  `user_ip` varchar(45) DEFAULT NULL,
  `view_date` timestamp NOT NULL DEFAULT current_timestamp(),
  `view_duration` int(11) DEFAULT NULL COMMENT 'Duration viewed in seconds',
  `completed` tinyint(1) DEFAULT 0,
  `device_info` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`view_id`),
  KEY `video_id` (`video_id`),
  KEY `student_id` (`student_id`),
  CONSTRAINT `video_views_ibfk_1` FOREIGN KEY (`video_id`) REFERENCES `videos` (`video_id`) ON DELETE CASCADE,
  CONSTRAINT `video_views_ibfk_2` FOREIGN KEY (`student_id`) REFERENCES `students` (`student_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Table structure for table `videos`
DROP TABLE IF EXISTS `videos`;
CREATE TABLE `videos` (
  `video_id` int(11) NOT NULL AUTO_INCREMENT,
  `course_id` int(11) NOT NULL,
  `teacher_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `video_url` varchar(255) NOT NULL,
  `thumbnail` varchar(255) DEFAULT NULL,
  `duration` varchar(10) DEFAULT NULL,
  `price` decimal(10,2) DEFAULT 0.00,
  `views` int(11) DEFAULT 0,
  `likes` int(11) DEFAULT 0,
  `category_name` varchar(100) DEFAULT NULL,
  `is_free` tinyint(1) DEFAULT 0,
  `is_published` tinyint(1) DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`video_id`),
  KEY `course_id` (`course_id`),
  KEY `teacher_id` (`teacher_id`),
  CONSTRAINT `videos_ibfk_1` FOREIGN KEY (`course_id`) REFERENCES `courses` (`course_id`) ON DELETE CASCADE,
  CONSTRAINT `videos_ibfk_2` FOREIGN KEY (`teacher_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Data for table `videos`
INSERT INTO `videos` (`video_id`, `course_id`, `teacher_id`, `title`, `description`, `video_url`, `thumbnail`, `duration`, `price`, `views`, `likes`, `category_name`, `is_free`, `is_published`, `created_at`, `updated_at`) VALUES ('19', '19', '12', 'Computer and MS Office 365', '0', 'uploads/videos/video_6868efed9c8fa_1751707629.mp4', 'uploads/thumbnails/thumb_6868efee7258f_1751707630.jpeg', '6:50', '3750.00', '0', '0', 'Computer Development Skill', '0', '1', '2025-07-05 11:27:10', '2025-07-05 11:27:10');
INSERT INTO `videos` (`video_id`, `course_id`, `teacher_id`, `title`, `description`, `video_url`, `thumbnail`, `duration`, `price`, `views`, `likes`, `category_name`, `is_free`, `is_published`, `created_at`, `updated_at`) VALUES ('20', '20', '12', 'Data Capturing', '0', 'uploads/videos/video_6868f63049ea6_1751709232.mp4', 'uploads/thumbnails/thumb_6869013a41582.png', '2:00', '4900.00', '2', '0', 'Data Science', '0', '1', '2025-07-05 11:53:52', '2025-07-05 12:40:58');
INSERT INTO `videos` (`video_id`, `course_id`, `teacher_id`, `title`, `description`, `video_url`, `thumbnail`, `duration`, `price`, `views`, `likes`, `category_name`, `is_free`, `is_published`, `created_at`, `updated_at`) VALUES ('21', '21', '12', 'Front-End Web Development', '0', 'uploads/videos/video_6868fa11f406c_1751710225.mp4', 'uploads/thumbnails/thumb_6868fa1202ac1_1751710226.jpeg', '8:53', '4750.00', '1', '0', 'Computer Science', '0', '1', '2025-07-05 12:10:26', '2025-07-06 22:40:57');

