<?php
// CMS Admin Login - Debug Version
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h2>CMS Login Debug Information</h2>";

// Test database connection
echo "<h3>1. Database Connection Test:</h3>";
try {
    require_once '../../includes/db.php';
    if (isset($conn) && $conn) {
        echo "✅ Database connected successfully<br>";
    } else {
        echo "❌ Database connection failed<br>";
    }
} catch (Exception $e) {
    echo "❌ Database error: " . $e->getMessage() . "<br>";
}

// Test CMS functions
echo "<h3>2. CMS Functions Test:</h3>";
try {
    require_once '../functions/cms_functions.php';
    echo "✅ CMS functions loaded successfully<br>";
} catch (Exception $e) {
    echo "❌ CMS functions error: " . $e->getMessage() . "<br>";
}

// Test session
echo "<h3>3. Session Test:</h3>";
try {
    session_start();
    echo "✅ Session started successfully<br>";
    echo "Session ID: " . session_id() . "<br>";
} catch (Exception $e) {
    echo "❌ Session error: " . $e->getMessage() . "<br>";
}

// Test admin authentication
echo "<h3>4. Admin User Test:</h3>";
if (isset($conn) && $conn) {
    try {
        $query = "SELECT * FROM cms_admins WHERE username = 'admin'";
        $result = $conn->query($query);
        if ($result && $result->num_rows > 0) {
            $admin = $result->fetch_assoc();
            echo "✅ Admin user found<br>";
            echo "Username: " . $admin['username'] . "<br>";
            echo "Password hash exists: " . (!empty($admin['password_hash']) ? 'Yes' : 'No') . "<br>";
            
            // Test password verification
            if (password_verify('admin123', $admin['password_hash'])) {
                echo "✅ Password verification successful<br>";
            } else {
                echo "❌ Password verification failed<br>";
            }
        } else {
            echo "❌ Admin user not found<br>";
        }
    } catch (Exception $e) {
        echo "❌ Admin test error: " . $e->getMessage() . "<br>";
    }
}

// Test form submission
echo "<h3>5. Form Submission Test:</h3>";
if ($_POST) {
    echo "Form submitted with data:<br>";
    echo "<pre>";
    print_r($_POST);
    echo "</pre>";
} else {
    echo "No form data submitted<br>";
}

echo "<hr>";
echo "<h3>Simple Login Test Form:</h3>";
echo '<form method="POST" action="">
    <input type="text" name="username" value="admin" placeholder="Username"><br><br>
    <input type="password" name="password" value="admin123" placeholder="Password"><br><br>
    <button type="submit">Test Login</button>
</form>';

?>
