<?php
// CMS Admin Dashboard
// Fix session path issues on production server
if (!is_dir(session_save_path()) || !is_writable(session_save_path())) {
    // Set a proper session save path
    $session_path = sys_get_temp_dir();
    if (is_dir($session_path) && is_writable($session_path)) {
        session_save_path($session_path);
    }
}

// Start session with error handling
try {
    session_start();
} catch (Exception $e) {
    // If sessions still fail, we'll use alternative authentication
    error_log("Session error in CMS dashboard: " . $e->getMessage());
}

require_once '../../includes/db.php';
require_once '../functions/cms_functions.php';

// Check if user is logged in
if (!isset($_SESSION['cms_admin_id'])) {
    header('Location: login.php');
    exit();
}

$admin_user = getCMSAdmin($_SESSION['cms_admin_id']);
if (!$admin_user) {
    session_destroy();
    header('Location: login.php');
    exit();
}

// Get recent activity
$recent_activity = getRecentCMSActivity(10);

// Get content statistics
$content_stats = getCMSContentStats();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>CMS Admin Dashboard - Panadite Academy</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="../assets/css/admin.css" rel="stylesheet">
</head>
<body>
    <?php include 'components/navbar.php'; ?>
    
    <div class="container-fluid">
        <div class="row">
            <?php include 'components/sidebar.php'; ?>
            
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2"><i class="fas fa-tachometer-alt me-2"></i>Dashboard</h1>
                    <div class="btn-toolbar mb-2 mb-md-0">
                        <div class="btn-group me-2">
                            <button type="button" class="btn btn-sm btn-outline-secondary">
                                <i class="fas fa-download me-1"></i>Export
                            </button>
                        </div>
                    </div>
                </div>

                <!-- Statistics Cards -->
                <div class="row mb-4">
                    <div class="col-xl-3 col-md-6 mb-4">
                        <div class="card border-left-primary shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                            Total Content Sections
                                        </div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">
                                            <?php echo $content_stats['total_content']; ?>
                                        </div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="fas fa-edit fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-3 col-md-6 mb-4">
                        <div class="card border-left-success shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                            Managed Images
                                        </div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">
                                            <?php echo $content_stats['total_images']; ?>
                                        </div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="fas fa-images fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-3 col-md-6 mb-4">
                        <div class="card border-left-info shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                            Active Pages
                                        </div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">
                                            <?php echo $content_stats['active_pages']; ?>
                                        </div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="fas fa-file-alt fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-3 col-md-6 mb-4">
                        <div class="card border-left-warning shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                            Recent Updates
                                        </div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">
                                            <?php echo count($recent_activity); ?>
                                        </div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="fas fa-clock fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Quick Actions -->
                <div class="row mb-4">
                    <div class="col-lg-6">
                        <div class="card shadow mb-4">
                            <div class="card-header py-3">
                                <h6 class="m-0 font-weight-bold text-primary">
                                    <i class="fas fa-rocket me-2"></i>Quick Actions
                                </h6>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <a href="content.php?page=homepage" class="btn btn-primary btn-block">
                                            <i class="fas fa-home me-2"></i>Edit Homepage
                                        </a>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <a href="content.php?page=courses" class="btn btn-info btn-block">
                                            <i class="fas fa-graduation-cap me-2"></i>Edit Courses Page
                                        </a>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <a href="content.php?page=about" class="btn btn-success btn-block">
                                            <i class="fas fa-users me-2"></i>Edit About Page
                                        </a>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <a href="images.php" class="btn btn-warning btn-block">
                                            <i class="fas fa-images me-2"></i>Manage Images
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-6">
                        <div class="card shadow mb-4">
                            <div class="card-header py-3">
                                <h6 class="m-0 font-weight-bold text-primary">
                                    <i class="fas fa-history me-2"></i>Recent Activity
                                </h6>
                            </div>
                            <div class="card-body">
                                <?php if (!empty($recent_activity)): ?>
                                    <div class="list-group list-group-flush">
                                        <?php foreach ($recent_activity as $activity): ?>
                                            <div class="list-group-item d-flex justify-content-between align-items-start">
                                                <div class="ms-2 me-auto">
                                                    <div class="fw-bold">
                                                        <?php echo formatActivityType($activity['action_type']); ?>
                                                    </div>
                                                    <small class="text-muted">
                                                        <?php echo formatTimeAgo($activity['timestamp']); ?>
                                                    </small>
                                                </div>
                                                <span class="badge bg-primary rounded-pill">
                                                    <i class="fas fa-<?php echo getActivityIcon($activity['action_type']); ?>"></i>
                                                </span>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                <?php else: ?>
                                    <p class="text-muted">No recent activity to display.</p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Page Management Overview -->
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">
                            <i class="fas fa-sitemap me-2"></i>Content Management Overview
                        </h6>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-4 text-center mb-3">
                                <div class="border rounded p-3">
                                    <h5><i class="fas fa-home text-primary"></i> Homepage</h5>
                                    <p class="text-muted">Hero section, statistics, about content</p>
                                    <a href="content.php?page=homepage" class="btn btn-sm btn-primary">Edit Content</a>
                                </div>
                            </div>
                            <div class="col-md-4 text-center mb-3">
                                <div class="border rounded p-3">
                                    <h5><i class="fas fa-graduation-cap text-info"></i> Courses</h5>
                                    <p class="text-muted">Course listings, filters, descriptions</p>
                                    <a href="content.php?page=courses" class="btn btn-sm btn-info">Edit Content</a>
                                </div>
                            </div>
                            <div class="col-md-4 text-center mb-3">
                                <div class="border rounded p-3">
                                    <h5><i class="fas fa-users text-success"></i> About</h5>
                                    <p class="text-muted">Mission, vision, team information</p>
                                    <a href="content.php?page=about" class="btn btn-sm btn-success">Edit Content</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </main>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="../assets/js/admin.js"></script>
</body>
</html>
