<?php
// CMS Admin Login
// Fix session path issues on production server
if (!is_dir(session_save_path()) || !is_writable(session_save_path())) {
    // Set a proper session save path
    $session_path = sys_get_temp_dir();
    if (is_dir($session_path) && is_writable($session_path)) {
        session_save_path($session_path);
    }
}

// Start session with error handling
try {
    session_start();
} catch (Exception $e) {
    // If sessions still fail, we'll use alternative authentication
    error_log("Session error in CMS login: " . $e->getMessage());
}

require_once '../../includes/db.php';
require_once '../functions/cms_functions.php';

$error_message = '';
$success_message = '';

// Check if already logged in
if (isset($_SESSION['cms_admin_id'])) {
    header('Location: index.php');
    exit();
}

// Handle login form submission
if ($_POST && isset($_POST['username']) && isset($_POST['password'])) {
    $username = trim($_POST['username']);
    $password = $_POST['password'];
    
    if (empty($username) || empty($password)) {
        $error_message = 'Please enter both username and password.';
    } else {
        $admin = authenticateCMSAdmin($username, $password);
        if ($admin) {
            $_SESSION['cms_admin_id'] = $admin['id'];
            $_SESSION['cms_admin_username'] = $admin['username'];
            $_SESSION['cms_admin_role'] = $admin['role'];
            $_SESSION['cms_admin_name'] = $admin['full_name'];
            
            // Log successful login
            logCMSActivity($admin['id'], 'login');
            
            header('Location: index.php');
            exit();
        } else {
            $error_message = 'Invalid username or password.';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>CMS Admin Login - Panadite Academy</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    
    <style>
        body {
            background: linear-gradient(135deg, rgba(245, 158, 11, 0.03) 0%, rgba(245, 158, 11, 0.01) 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif;
        }
        
        .login-container {
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
            overflow: hidden;
            max-width: 900px;
            margin: 0 auto;
        }
        
        .login-left {
            background: linear-gradient(135deg, #2563eb 0%, #f59e0b 100%);
            padding: 3rem;
            color: white;
            text-align: center;
        }
        
        .login-right {
            padding: 3rem;
            background: rgba(245, 158, 11, 0.01);
        }
        
        .brand-logo {
            font-size: 2rem;
            font-weight: 700;
            margin-bottom: 1rem;
        }
        
        .brand-subtitle {
            font-size: 1.1rem;
            opacity: 0.9;
            margin-bottom: 2rem;
        }
        
        .feature-item {
            display: flex;
            align-items: center;
            margin-bottom: 1rem;
            font-size: 0.95rem;
        }
        
        .feature-item i {
            margin-right: 0.75rem;
            font-size: 1.1rem;
        }
        
        .login-form {
            max-width: 400px;
        }
        
        .form-control {
            border-radius: 12px;
            border: 1px solid #d1d5db;
            padding: 0.875rem 1rem;
            font-size: 1rem;
            transition: all 0.3s ease;
        }
        
        .form-control:focus {
            border-color: #f59e0b;
            box-shadow: 0 0 0 3px rgba(245, 158, 11, 0.1);
        }
        
        .btn-login {
            background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);
            border: none;
            border-radius: 12px;
            padding: 0.875rem 2rem;
            font-weight: 600;
            color: white;
            width: 100%;
            transition: all 0.3s ease;
        }
        
        .btn-login:hover {
            background: linear-gradient(135deg, #d97706 0%, #b45309 100%);
            transform: translateY(-2px);
            color: white;
        }
        
        .alert {
            border-radius: 12px;
            border: none;
        }
        
        .input-group {
            position: relative;
        }
        
        .input-group-text {
            background: transparent;
            border: 1px solid #d1d5db;
            border-right: none;
            border-radius: 12px 0 0 12px;
            color: #6b7280;
        }
        
        .input-group .form-control {
            border-left: none;
            border-radius: 0 12px 12px 0;
        }
        
        .input-group:focus-within .input-group-text {
            border-color: #f59e0b;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="login-container">
            <div class="row g-0">
                <div class="col-md-6 login-left">
                    <div class="brand-logo">
                        <i class="fas fa-graduation-cap me-2"></i>
                        Panadite Academy
                    </div>
                    <div class="brand-subtitle">
                        Content Management System
                    </div>
                    
                    <div class="text-start mt-4">
                        <div class="feature-item">
                            <i class="fas fa-edit"></i>
                            Edit all page content dynamically
                        </div>
                        <div class="feature-item">
                            <i class="fas fa-images"></i>
                            Manage images and media files
                        </div>
                        <div class="feature-item">
                            <i class="fas fa-shield-alt"></i>
                            Secure admin authentication
                        </div>
                        <div class="feature-item">
                            <i class="fas fa-mobile-alt"></i>
                            Responsive content management
                        </div>
                        <div class="feature-item">
                            <i class="fas fa-history"></i>
                            Track all content changes
                        </div>
                    </div>
                </div>
                
                <div class="col-md-6 login-right">
                    <div class="login-form">
                        <h2 class="mb-4 text-gray-800">
                            <i class="fas fa-lock me-2 text-warning"></i>
                            Admin Login
                        </h2>
                        <p class="text-muted mb-4">Sign in to manage Panadite Academy content</p>
                        
                        <?php if ($error_message): ?>
                            <div class="alert alert-danger">
                                <i class="fas fa-exclamation-triangle me-2"></i>
                                <?php echo htmlspecialchars($error_message); ?>
                            </div>
                        <?php endif; ?>
                        
                        <?php if ($success_message): ?>
                            <div class="alert alert-success">
                                <i class="fas fa-check-circle me-2"></i>
                                <?php echo htmlspecialchars($success_message); ?>
                            </div>
                        <?php endif; ?>
                        
                        <form method="POST" action="">
                            <div class="mb-3">
                                <label for="username" class="form-label fw-semibold">Username</label>
                                <div class="input-group">
                                    <span class="input-group-text">
                                        <i class="fas fa-user"></i>
                                    </span>
                                    <input type="text" class="form-control" id="username" name="username" 
                                           value="<?php echo htmlspecialchars($_POST['username'] ?? ''); ?>"
                                           placeholder="Enter your username" required>
                                </div>
                            </div>
                            
                            <div class="mb-4">
                                <label for="password" class="form-label fw-semibold">Password</label>
                                <div class="input-group">
                                    <span class="input-group-text">
                                        <i class="fas fa-lock"></i>
                                    </span>
                                    <input type="password" class="form-control" id="password" name="password" 
                                           placeholder="Enter your password" required>
                                </div>
                            </div>
                            
                            <button type="submit" class="btn btn-login">
                                <i class="fas fa-sign-in-alt me-2"></i>
                                Sign In to CMS
                            </button>
                        </form>
                        
                        <div class="mt-4 text-center">
                            <small class="text-muted">
                                <i class="fas fa-info-circle me-1"></i>
                                Default credentials: admin / admin123
                            </small>
                        </div>
                        
                        <div class="mt-4 text-center">
                            <a href="../../index.php" class="text-decoration-none text-muted">
                                <i class="fas fa-arrow-left me-1"></i>
                                Back to Main Site
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
