<?php
// Check if current user is logged in as CMS admin
header('Content-Type: application/json');

// Force proper session configuration for production Linux server
ini_set('session.save_handler', 'files');
ini_set('session.save_path', '/tmp');
ini_set('session.use_cookies', 1);
ini_set('session.cookie_lifetime', 0);
ini_set('session.cookie_path', '/');
ini_set('session.cookie_domain', '');
ini_set('session.cookie_secure', 0);
ini_set('session.cookie_httponly', 1);

// Start session
session_start();

$response = [
    'is_admin' => false,
    'admin_id' => null,
    'admin_name' => null
];

// Check if user is logged in as CMS admin OR main application admin
if (isset($_SESSION['cms_admin_id']) && !empty($_SESSION['cms_admin_id'])) {
    // CMS admin login (separate CMS system)
    $response['is_admin'] = true;
    $response['admin_id'] = $_SESSION['cms_admin_id'];
    $response['admin_name'] = $_SESSION['cms_admin_name'] ?? $_SESSION['cms_admin_username'] ?? 'Admin';
} elseif (isset($_SESSION['user_role']) && $_SESSION['user_role'] === 'admin' && isset($_SESSION['logged_in']) && $_SESSION['logged_in'] == 1) {
    // Main application admin login (unified system)
    $response['is_admin'] = true;
    $response['admin_id'] = $_SESSION['user_id'] ?? 'main_admin';
    $response['admin_name'] = ($_SESSION['first_name'] ?? '') . ' ' . ($_SESSION['last_name'] ?? '') ?: $_SESSION['username'] ?? 'Admin';
}

echo json_encode($response);
?>
