<?php
// Check cms_content table structure
header('Content-Type: application/json');

// Force session configuration
ini_set('session.save_handler', 'files');
ini_set('session.save_path', '/tmp');
session_start();

$response = [
    'success' => false,
    'message' => 'Checking table structure',
    'debug' => []
];

try {
    // Include database
    require_once '../../includes/db.php';
    require_once 'cms_functions.php';
    
    if (!ensureCMSDatabase()) {
        throw new Exception('Database setup failed');
    }
    
    global $conn;
    
    // Check if table exists
    $table_check = $conn->query("SHOW TABLES LIKE 'cms_content'");
    if ($table_check->num_rows == 0) {
        $response['table_exists'] = false;
        $response['message'] = 'cms_content table does not exist';
    } else {
        $response['table_exists'] = true;
        
        // Get table structure
        $columns_result = $conn->query("DESCRIBE cms_content");
        $columns = [];
        while ($row = $columns_result->fetch_assoc()) {
            $columns[] = [
                'field' => $row['Field'],
                'type' => $row['Type'],
                'null' => $row['Null'],
                'key' => $row['Key'],
                'default' => $row['Default']
            ];
        }
        $response['columns'] = $columns;
        $response['column_names'] = array_column($columns, 'field');
        
        // Check if we have any content
        $count_result = $conn->query("SELECT COUNT(*) as count FROM cms_content");
        $count_row = $count_result->fetch_assoc();
        $response['record_count'] = $count_row['count'];
    }
    
    $response['success'] = true;
    
} catch (Exception $e) {
    $response['success'] = false;
    $response['message'] = 'Error: ' . $e->getMessage();
}

echo json_encode($response, JSON_PRETTY_PRINT);
?>
