<?php
/**
 * Database Connection File
 * 
 * This file establishes a connection to the MySQL database
 * using PDO for secure database interactions.
 */
 

// Enable error reporting for debugging - comment out in production
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Detect environment - checks if we're on a local or production server
$is_local = ($_SERVER['HTTP_HOST'] == 'localhost' || 
           strpos($_SERVER['HTTP_HOST'], '127.0.0.1') !== false ||
           strpos($_SERVER['HTTP_HOST'], '192.168.') !== false);

// Database configuration - uses different settings based on environment
if ($is_local) {
  
$db_host = 'localhost'; // XAMPP MySQL server
$db_name = 'panadite_academy';
$db_user = 'root';  // Default XAMPP username
$db_pass = '';
} else {
    // Production/online database settings
    
$db_host = 'localhost'; // XAMPP MySQL server
$db_name = 'twpurnyc_panadite_DB';
$db_user = 'twpurnyc_149586Alain';  // Default XAMPP username
$db_pass = '149586Alain#';

}

$db_charset = 'utf8mb4';

$dsn = "mysql:host=$db_host;dbname=$db_name;charset=$db_charset";
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES   => false,
];

// Global connection variable
$pdo = null;

// Initialize the connection status flag
$GLOBALS['db_connection_failed'] = false;

// Skip extension detection - our tests show the extensions are available
// Connect directly to the database instead of checking extensions

try {
    // Verify MySQL connection by creating one
    $test_conn = @new mysqli($db_host, $db_user, $db_pass);
    
    // If there was an error connecting, set the flag
    if ($test_conn->connect_error) {
        $error_message = "Database connection failed: " . $test_conn->connect_error;
        error_log($error_message);
        $GLOBALS['db_connection_failed'] = true;
        $GLOBALS['db_connection_error'] = $error_message;
        $pdo = null;
        $conn = null;
    } else {
        // Close test connection
        $test_conn->close();
    }    
} catch (Exception $e) {
    // Set the connection failed flag
    $GLOBALS['db_connection_failed'] = true;
    $GLOBALS['db_connection_error'] = $e->getMessage();
    $pdo = null;
    $conn = null;
}

// Only proceed with connections if no errors occurred
if (!$GLOBALS['db_connection_failed']) {
    try {
        // Create a new PDO instance
        $pdo = new PDO($dsn, $db_user, $db_pass, $options);
        
        // Also create a MySQLi connection for backward compatibility
        $conn = new mysqli($db_host, $db_user, $db_pass, $db_name);
        
        // Check connection
        if ($conn->connect_error) {
            throw new Exception("MySQLi Connection failed: " . $conn->connect_error);
        }
        
        // Set charset
        $conn->set_charset('utf8mb4');
        
        // Connection successful
        $GLOBALS['db_connection_failed'] = false;
        
    } catch (Exception $e) {
        // If connection fails, log the error
        error_log('Connection Error: ' . $e->getMessage());
        
        // Set failed connection flag
        $GLOBALS['db_connection_failed'] = true;
        
        // Return null connections
        $pdo = null;
        $conn = null;
    }
}

/**
 * Utility Functions
 */

/**
 * Fetch all records from a query
 * 
 * @param string $sql SQL query
 * @param array $params Parameters for prepared statement
 * @return array|bool Results as associative array or false if DB connection failed
 */
if (!function_exists('fetchAll')) {
function fetchAll($sql, $params = []) {
    global $pdo;
    
    // Check if database connection is available
    if ($pdo === null || defined('DB_CONNECTION_FAILED') && DB_CONNECTION_FAILED) {
        error_log('Database query failed: No valid database connection available');
        return [];
    }
    
    try {
        $stmt = $pdo->prepare($sql);
        $stmt->execute($params);
        return $stmt->fetchAll();
    } catch (Exception $e) {
        error_log('Database query failed: ' . $e->getMessage());
        return [];
    }
}
}

/**
 * Fetch a single record from a query
 * 
 * @param string $sql SQL query
 * @param array $params Parameters for prepared statement
 * @return array|bool Single result as associative array or false if no result
 */
if (!function_exists('fetchOne')) {
function fetchOne($sql, $params = []) {
    global $pdo;
    
    // Check if database connection is available
    if ($pdo === null || defined('DB_CONNECTION_FAILED') && DB_CONNECTION_FAILED) {
        error_log('Database query failed: No valid database connection available');
        return false;
    }
    
    try {
        $stmt = $pdo->prepare($sql);
        $stmt->execute($params);
        $result = $stmt->fetch();
        return $result ? $result : false;
    } catch (Exception $e) {
        error_log('Database query failed: ' . $e->getMessage());
        return false;
    }
}
}

/**
 * Execute an SQL query (INSERT, UPDATE, DELETE)
 * 
 * @param string $sql SQL query
 * @param array $params Parameters for prepared statement
 * @return int Number of affected rows
 */
function execute($sql, $params = []) {
    global $pdo;
    $stmt = $pdo->prepare($sql);
    $stmt->execute($params);
    return $stmt->rowCount();
}

/**
 * Get the last inserted ID
 * 
 * @return string Last inserted ID
 */
function lastInsertId() {
    global $pdo;
    return $pdo->lastInsertId();
}

/**
 * Gets current logged-in user data from session (DB connect version)
 * This is renamed to avoid conflicts with auth/functions.php
 * 
 * @return array|null User data or null if not logged in
 */
function getSessionUserData() {
    if (isset($_SESSION['user_id'])) {
        return array(
            'user_id' => $_SESSION['user_id'],
            'username' => $_SESSION['username'] ?? '',
            'email' => $_SESSION['email'] ?? '',
            'first_name' => $_SESSION['first_name'] ?? '',
            'last_name' => $_SESSION['last_name'] ?? '',
            'user_role' => $_SESSION['user_role'] ?? '',
            'profile_picture' => $_SESSION['profile_picture'] ?? null
        );
    }
    return null;
}
