<?php
// Fix session handling for live server
if (session_status() == PHP_SESSION_NONE) {
    // Force correct session path for Linux server
    ini_set('session.save_path', '/tmp');
    
    // Alternative fallback paths for different server configurations
    if (!is_writable('/tmp')) {
        $temp_paths = ['/var/tmp', sys_get_temp_dir()];
        foreach ($temp_paths as $path) {
            if (is_dir($path) && is_writable($path)) {
                ini_set('session.save_path', $path);
                break;
            }
        }
    }
    
    session_start();
}

// Include any necessary files and configurations
if (file_exists('includes/config.php')) {
    require_once 'includes/config.php';
}

// Get current user information if logged in
function getCurrentUser() {
    if (isset($_SESSION['user_id'])) {
        global $conn;
        $stmt = $conn->prepare("SELECT * FROM users WHERE user_id = ?");
        $stmt->bind_param("i", $_SESSION['user_id']);
        $stmt->execute();
        $result = $stmt->get_result();
        if ($result && $result->num_rows > 0) {
            return $result->fetch_assoc();
        }
    }
    return null;
}
$current_user = getCurrentUser();

// Contact information page - no form processing needed
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Contact Us - Panadite Academy</title>
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Animate.css -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css">
    
    <style>
        :root {
            --primary-color: #276BE4;
            --secondary-color: #1e5bcc;
            --accent-color: #FFA915;
            --light-color: whitesmoke;
            --white: #ffffff;
            --text-dark: #2d3436;
            --text-muted: #636e72;
            --border-radius: 12px;
        }
        
        /* Modern styling with whitesmoke background */
        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
            background-color: whitesmoke;
        }
        
        /* Hero section with whitesmoke background */
        .hero-section {
            background: whitesmoke;
            color: var(--text-dark);
            padding: 120px 0 80px;
            position: relative;
            overflow: hidden;
        }
        
        .hero-section::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><circle cx="20" cy="20" r="2" fill="rgba(39,107,228,0.1)"/><circle cx="80" cy="40" r="1" fill="rgba(255,169,21,0.15)"/><circle cx="40" cy="80" r="1.5" fill="rgba(39,107,228,0.1)"/></svg>');
            animation: float 20s ease-in-out infinite;
        }
        
        .hero-section h1 {
            color: var(--text-dark);
            font-weight: 700;
            margin-bottom: 1.5rem;
        }
        
        .hero-section p.lead {
            color: var(--text-muted);
            font-size: 1.2rem;
            margin-bottom: 2rem;
        }
        
        /* Animations */
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        @keyframes slideInLeft {
            from { opacity: 0; transform: translateX(-40px); }
            to { opacity: 1; transform: translateX(0); }
        }
        
        @keyframes slideInRight {
            from { opacity: 0; transform: translateX(40px); }
            to { opacity: 1; transform: translateX(0); }
        }
        
        /* Animation classes */
        .animate-fade-in {
            animation: fadeIn 1s ease-out forwards;
        }
        
        .animate-slide-left {
            animation: slideInLeft 1s ease-out forwards;
        }
        
        .animate-slide-right {
            animation: slideInRight 1s ease-out forwards;
        }
        
        .animate-delay-1 { animation-delay: 0.3s; }
        .animate-delay-2 { animation-delay: 0.6s; }
        .animate-delay-3 { animation-delay: 0.9s; }
        
        /* Modern card styling */
        .modern-card {
            background: var(--white);
            border-radius: var(--border-radius);
            box-shadow: 0 4px 15px rgba(39, 107, 228, 0.1);
            border: 1px solid rgba(39, 107, 228, 0.05);
            transition: all 0.3s ease;
            overflow: hidden;
        }
        
        .modern-card:hover {
            transform: translateY(-8px);
            box-shadow: 0 12px 30px rgba(39, 107, 228, 0.2);
        }
        
        /* Contact form styling */
        .contact-form-card {
            background: var(--white);
            border-radius: 20px;
            box-shadow: 0 8px 25px rgba(39, 107, 228, 0.1);
            border: 1px solid rgba(39, 107, 228, 0.05);
            position: relative;
            overflow: hidden;
        }
        
        .contact-form-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(90deg, var(--primary-color), var(--accent-color));
        }
        
        .form-control {
            border: 2px solid #e9ecef;
            border-radius: 12px;
            padding: 15px 20px;
            font-size: 16px;
            transition: all 0.3s ease;
            background: #f8f9fa;
        }
        
        .form-control:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 0.25rem rgba(39, 107, 228, 0.15);
            background: white;
            transform: translateY(-2px);
        }
        
        .form-label {
            font-weight: 600;
            color: var(--text-dark);
            margin-bottom: 8px;
        }
        
        .btn-primary {
            background: var(--primary-color);
            border: none;
            padding: 15px 40px;
            border-radius: 12px;
            font-weight: 600;
            font-size: 16px;
            transition: all 0.3s ease;
            color: white;
        }
        
        .btn-primary:hover {
            background: var(--secondary-color);
            transform: translateY(-3px);
            box-shadow: 0 10px 25px rgba(39, 107, 228, 0.3);
            color: white;
        }
        
        /* Contact info card */
        .contact-info-card {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            padding: 2.5rem;
            border-radius: 20px;
            box-shadow: 0 8px 25px rgba(39, 107, 228, 0.2);
            position: relative;
            overflow: hidden;
            height: 100%;
        }
        
        .contact-info-card::before {
            content: '';
            position: absolute;
            top: -20px;
            right: -20px;
            width: 100px;
            height: 100px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 50%;
            pointer-events: none;
        }
        
        .contact-info-card h3 {
            color: white !important;
            position: relative;
            z-index: 2;
        }
        
        .contact-info-card h5 {
            color: white !important;
            position: relative;
            z-index: 2;
        }
        
        .contact-info-item {
            display: flex;
            align-items: flex-start;
            margin-bottom: 2rem;
            position: relative;
            z-index: 2;
        }
        
        .contact-icon {
            width: 50px;
            height: 50px;
            background: rgba(255, 255, 255, 0.2);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 1rem;
            flex-shrink: 0;
        }
        
        .contact-icon i {
            font-size: 1.2rem;
            color: white;
        }
        
        .contact-info-item h6 {
            color: white !important;
            font-weight: 600;
            margin-bottom: 0.5rem;
        }
        
        .contact-info-item p {
            margin: 0;
            color: rgba(255, 255, 255, 0.9) !important;
            line-height: 1.5;
        }
        
        /* Social links in contact card */
        .contact-info-card .social-link {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            width: 40px;
            height: 40px;
            background: rgba(255, 255, 255, 0.2);
            border-radius: 50%;
            color: white !important;
            text-decoration: none;
            transition: all 0.3s ease;
            margin-right: 0.75rem;
        }
        
        .contact-info-card .social-link:hover {
            background: rgba(255, 255, 255, 0.3);
            transform: translateY(-2px);
            color: white !important;
        }
        
        /* Map section */
        .map-container {
            border-radius: 20px;
            overflow: hidden;
            box-shadow: 0 8px 25px rgba(39, 107, 228, 0.1);
            border: 1px solid rgba(39, 107, 228, 0.05);
        }
        
        .map-container iframe {
            width: 100%;
            height: 450px;
            border: none;
        }
        
        /* Section styling */
        .section-title {
            text-align: center;
            margin-bottom: 3rem;
        }
        
        .section-title h2 {
            font-size: 2.5rem;
            font-weight: 700;
            color: var(--text-dark);
            margin-bottom: 1rem;
        }
        
        .section-subtitle {
            font-size: 1.2rem;
            color: var(--text-muted);
            max-width: 600px;
            margin: 0 auto;
        }
        
        .accent-bar {
            width: 60px;
            height: 3px;
            background: linear-gradient(90deg, var(--primary-color), var(--accent-color));
            margin: 0 auto 2rem;
            border-radius: 2px;
        }
        
        /* Alert styling */
        .alert {
            border-radius: 12px;
            border: none;
            padding: 15px 20px;
        }
        
        .alert-success {
            background: rgba(40, 167, 69, 0.1);
            color: #28a745;
            border: 1px solid rgba(40, 167, 69, 0.2);
        }
        
        .alert-danger {
            background: rgba(220, 53, 69, 0.1);
            color: #dc3545;
            border: 1px solid rgba(220, 53, 69, 0.2);
        }
        
        /* Text colors */
        h1, h2, h3, h4, h5, h6 {
            color: var(--text-dark) !important;
        }
        
        p, .lead {
            color: var(--text-muted) !important;
        }
        
        .fw-bold {
            color: var(--text-dark) !important;
        }
        
        /* Modern Accordion Styling */
        .modern-accordion {
            --bs-accordion-border-width: 0;
            --bs-accordion-border-radius: 0;
        }
        
        .modern-accordion .accordion-item {
            background: var(--white);
            border: 1px solid rgba(39, 107, 228, 0.08);
            border-radius: 12px;
            margin-bottom: 1rem;
            overflow: hidden;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.04);
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }
        
        .modern-accordion .accordion-item:hover {
            box-shadow: 0 4px 20px rgba(39, 107, 228, 0.08);
            transform: translateY(-1px);
            border-color: rgba(39, 107, 228, 0.15);
        }
        
        .modern-accordion .accordion-button {
            background: transparent;
            border: none;
            padding: 1.25rem 1.5rem;
            font-weight: 600;
            color: var(--text-dark);
            font-size: 1rem;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
            text-align: left;
            width: 100%;
        }
        
        .modern-accordion .accordion-button:not(.collapsed) {
            background: transparent;
            color: var(--primary-color);
            box-shadow: none;
        }
        
        .modern-accordion .accordion-button:focus {
            box-shadow: none;
            border-color: transparent;
        }
        
        .modern-accordion .accordion-button::after {
            position: absolute;
            right: 1.5rem;
            top: 50%;
            transform: translateY(-50%);
            width: 32px;
            height: 32px;
            background: var(--accent-color);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            content: '+';
            font-size: 18px;
            font-weight: bold;
            color: white;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            flex-shrink: 0;
        }
        
        .modern-accordion .accordion-button:not(.collapsed)::after {
            content: '−';
            background: var(--primary-color);
            transform: translateY(-50%) rotate(0deg);
        }
        
        .modern-accordion .accordion-body {
            padding: 0 1.5rem 1.5rem 1.5rem;
            background: transparent;
            color: var(--text-muted);
            line-height: 1.7;
            font-size: 0.95rem;
        }
        
        .modern-accordion .accordion-collapse {
            border: none;
        }
        
        .modern-accordion .accordion-header {
            margin-bottom: 0;
        }
        
        /* Responsive */
        @media (max-width: 768px) {
            .hero-section {
                padding: 80px 0 60px;
            }
            
            .section-title h2 {
                font-size: 2rem;
            }
            
            .contact-info-card {
                margin-top: 30px;
            }
            
            .modern-accordion .accordion-button {
                padding: 1rem 1.25rem;
                font-size: 0.95rem;
            }
            
            .modern-accordion .accordion-button::after {
                right: 1.25rem;
                width: 28px;
                height: 28px;
                font-size: 16px;
            }
        }
    </style>
    <!-- Add AOS library for scroll animations -->
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
</head>
<body>
    <div class="d-flex flex-column min-vh-100">
        <!-- Include the modern navbar -->
        <?php include 'includes/navbar.php'; ?>
        
        <!-- Hero Section -->
        <section class="hero-section">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-8 mx-auto text-center">
                        <div class="animate-fade-in">
                            <span class="badge bg-white text-primary px-3 py-2 mb-3" style="font-size: 0.9rem; border-radius: 25px; color: var(--primary-color) !important;">
                                <i class="fas fa-envelope me-2"></i>Contact Us
                            </span>
                        </div>
                        
                        <h1 class="display-4 fw-bold mb-4 animate-slide-left animate-delay-1">
                            Get in Touch
                        </h1>
                        
                        <p class="lead mb-4 animate-slide-left animate-delay-2" style="max-width: 600px; margin: 0 auto;">
                            Have a question or feedback? We're here to help. Reach out to our friendly team.
                        </p>
                    </div>
                </div>
            </div>
        </section>
        
        <!-- Contact Form Section -->
        <!-- Contact Information Section -->
        <section class="py-5">
            <div class="container">
                <div class="row mb-5">
                    <div class="col-lg-8 mx-auto text-center">
                        <div class="animate-fade-in">
                            <h2 class="fw-bold mb-3" style="color: var(--text-dark);">Contact Information</h2>
                            <div class="accent-bar mx-auto mb-4"></div>
                            <p class="lead" style="color: var(--text-muted); max-width: 600px; margin: 0 auto;">
                                Find all the ways to reach us and visit our campus. We're here to help with your educational journey.
                            </p>
                        </div>
                    </div>
                </div>
                
                <div class="row justify-content-center">
                    <div class="col-lg-6 col-md-8">
                        <div class="contact-info-card animate-slide-right animate-delay-2">
                            <h3 class="fw-bold mb-4" style="color: var(--text-dark);">Get In Touch</h3>
                            
                            <div class="contact-info-item">
                                <div class="contact-icon">
                                    <i class="fas fa-map-marker-alt"></i>
                                </div>
                                <div>
                                    <h6 class="fw-bold mb-2" style="color: var(--text-dark);">Our Location</h6>
                                    <p class="mb-0" style="color: var(--text-muted);">296 Pretorius Street, Corner Lilian Ngoyi<br>Pretoria Central, 0001<br>South Africa</p>
                                </div>
                            </div>
                            
                            <div class="contact-info-item">
                                <div class="contact-icon">
                                    <i class="fas fa-phone-alt"></i>
                                </div>
                                <div>
                                    <h6 class="fw-bold mb-2" style="color: var(--text-dark);">Phone Number</h6>
                                    <p class="mb-0" style="color: var(--text-muted);">+27 74 722 3141</p>
                                </div>
                            </div>
                            
                            <div class="contact-info-item">
                                <div class="contact-icon">
                                    <i class="fas fa-envelope"></i>
                                </div>
                                <div>
                                    <h6 class="fw-bold mb-2" style="color: var(--text-dark);">Email Address</h6>
                                    <p class="mb-0" style="color: var(--text-muted);">admin@panaditeacademy.com</p>
                                </div>
                            </div>
                            
                            <div class="contact-info-item">
                                <div class="contact-icon">
                                    <i class="fas fa-clock"></i>
                                </div>
                                <div>
                                    <h6 class="fw-bold mb-2" style="color: var(--text-dark);">Business Hours</h6>
                                    <p class="mb-0" style="color: var(--text-muted);">Monday - Friday<br>9:00 AM - 5:00 PM</p>
                                </div>
                            </div>
                            
                            <div class="mt-5 pt-4" style="border-top: 1px solid rgba(39, 107, 228, 0.1);">
                                <h5 class="fw-bold mb-3" style="color: var(--text-dark);">Connect With Us</h5>
                                <div class="d-flex gap-3">
                                    <a href="https://www.facebook.com/profile.php?id=61571212115022" class="social-link">
                                        <i class="fab fa-facebook-f"></i>
                                    </a>
                                    <a href="https://www.tiktok.com/@panadite.academy?_r=1&_t=ZS-92RE3EUzPRX" class="social-link">
                                        <i class="fab fa-tiktok"></i>
                                    </a>
                                    <a href="https://www.instagram.com/panadite_academy?igsh=OGQ5ZDc2ODk2ZA==" class="social-link">
                                        <i class="fab fa-instagram"></i>
                                    </a>
                                    <a href="https://www.linkedin.com/company/panadite-academy/" class="social-link">
                                        <i class="fab fa-linkedin-in"></i>
                                    </a>
                                    
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        
        <!-- Location Section -->
        <section class="py-5">
            <div class="container">
                <div class="row mb-5">
                    <div class="col-lg-8 mx-auto text-center">
                        <div class="animate-fade-in">
                            <h2 class="fw-bold mb-3" style="color: var(--text-dark);">Visit Our Campus</h2>
                            <div class="accent-bar mx-auto mb-4"></div>
                            <p class="lead" style="color: var(--text-muted); max-width: 600px; margin: 0 auto;">
                                Find us in the heart of Pretoria Central. We're easily accessible and look forward to welcoming you.
                            </p>
                        </div>
                    </div>
                </div>
                
                <div class="map-container animate-fade-in animate-delay-1">
                    <iframe 
                        src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3554.385786243773!2d28.18592257559839!3d-25.749261177735506!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x1e95620c803a270d%3A0x56aa13edf4a18527!2s296%20Pretorius%20St%2C%20Pretoria%20Central%2C%20Pretoria%2C%200001!5e0!3m2!1sen!2sza!4v1687176599621!5m2!1sen!2sza" 
                        allowfullscreen="" 
                        loading="lazy" 
                        referrerpolicy="no-referrer-when-downgrade">
                    </iframe>
                </div>
            </div>
        </section>
        
        <!-- FAQ Section -->
        <section class="py-5" style="background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);">
            <div class="container">
                <div class="row mb-5">
                    <div class="col-lg-8 mx-auto text-center">
                        <div class="animate-fade-in">
                            <h2 class="fw-bold mb-3" style="color: var(--text-dark);">Frequently Asked Questions</h2>
                            <div class="accent-bar mx-auto mb-4"></div>
                            <p class="lead" style="color: var(--text-muted); max-width: 600px; margin: 0 auto;">
                                Find answers to common questions about our services and enrollment process.
                            </p>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-lg-8 mx-auto">
                        <div class="accordion modern-accordion animate-slide-up animate-delay-1" id="contactFaq">
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="faq1">
                                    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse1" aria-expanded="true">
                                        How do we learn with Panadite Academy?
                                    </button>
                                </h2>
                                <div id="faqCollapse1" class="accordion-collapse collapse show" aria-labelledby="faq1" data-bs-parent="#contactFaq">
                                    <div class="accordion-body">
                                        Our learning approach combines interactive video lessons, hands-on projects, and real-world case studies. You'll learn at your own pace with access to expert instructors and a supportive community of learners who are passionate about professional development.
                                    </div>
                                </div>
                            </div>
                            
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="faq2">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse2" aria-expanded="false">
                                        Are Panadite Academy's programs Accredited?
                                    </button>
                                </h2>
                                <div id="faqCollapse2" class="accordion-collapse collapse" aria-labelledby="faq2" data-bs-parent="#contactFaq">
                                    <div class="accordion-body">
                                        Yes, our programs are fully accredited and recognized by leading industry bodies. We maintain the highest standards of education quality and our certifications are valued by employers worldwide across various professional sectors.
                                    </div>
                                </div>
                            </div>
                            
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="faq3">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse3" aria-expanded="false">
                                        What is the eligibility for our Professional Development Programs?
                                    </button>
                                </h2>
                                <div id="faqCollapse3" class="accordion-collapse collapse" aria-labelledby="faq3" data-bs-parent="#contactFaq">
                                    <div class="accordion-body">
                                        Our Professional Development Programs are open to working professionals, recent graduates, and career changers. Most programs require a basic educational background, and some specialized courses may have specific prerequisites which are clearly outlined in the course descriptions.
                                    </div>
                                </div>
                            </div>
                            
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="faq4">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse4" aria-expanded="false">
                                        How will Upskilling help grow my career?
                                    </button>
                                </h2>
                                <div id="faqCollapse4" class="accordion-collapse collapse" aria-labelledby="faq4" data-bs-parent="#contactFaq">
                                    <div class="accordion-body">
                                        Upskilling with Panadite Academy enhances your expertise, makes you more competitive in the job market, and opens doors to higher-paying positions. Our industry-relevant curriculum ensures you gain practical skills that employers value, leading to career advancement and increased earning potential.
                                    </div>
                                </div>
                            </div>
                            
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="faq5">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse5" aria-expanded="false">
                                        Who does Panadite Academy partner with?
                                    </button>
                                </h2>
                                <div id="faqCollapse5" class="accordion-collapse collapse" aria-labelledby="faq5" data-bs-parent="#contactFaq">
                                    <div class="accordion-body">
                                        We partner with leading technology companies, educational institutions, and industry experts to provide cutting-edge curriculum and real-world experience. Our partnerships ensure that our content stays current with industry trends and provides valuable networking opportunities for our students.
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>

    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>

    <!-- Bootstrap JavaScript -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        // Initialize modern animations
        document.addEventListener('DOMContentLoaded', function() {
            // Trigger animations on scroll
            const observerOptions = {
                threshold: 0.1,
                rootMargin: '0px 0px -50px 0px'
            };
            
            const observer = new IntersectionObserver(function(entries) {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        entry.target.style.opacity = '1';
                        entry.target.style.transform = 'translateY(0)';
                    }
                });
            }, observerOptions);
            
            // Observe all animated elements
            document.querySelectorAll('.animate-fade-in, .animate-slide-left, .animate-slide-right, .animate-slide-up').forEach(el => {
                observer.observe(el);
            });
            
            // Enhanced form interactions
            const formInputs = document.querySelectorAll('.modern-input');
            formInputs.forEach(input => {
                // Focus effect
                input.addEventListener('focus', function() {
                    this.parentElement.classList.add('input-focused');
                });
                
                // Blur effect
                input.addEventListener('blur', function() {
                    if (this.value === '') {
                        this.parentElement.classList.remove('input-focused');
                    }
                });
                
                // Check initial state
                if (input.value !== '') {
                    input.parentElement.classList.add('input-focused');
                }
            });
            
            // Social link hover effects
            document.querySelectorAll('.social-link').forEach(link => {
                link.addEventListener('mouseenter', function() {
                    this.style.transform = 'translateY(-2px) scale(1.05)';
                });
                
                link.addEventListener('mouseleave', function() {
                    this.style.transform = 'translateY(0) scale(1)';
                });
            });
            
            // Button click effect
            document.querySelectorAll('.modern-btn').forEach(btn => {
                btn.addEventListener('click', function(e) {
                    // Create ripple effect
                    const ripple = document.createElement('span');
                    const rect = this.getBoundingClientRect();
                    const size = Math.max(rect.width, rect.height);
                    const x = e.clientX - rect.left - size / 2;
                    const y = e.clientY - rect.top - size / 2;
                    
                    ripple.style.width = ripple.style.height = size + 'px';
                    ripple.style.left = x + 'px';
                    ripple.style.top = y + 'px';
                    ripple.classList.add('ripple');
                    
                    this.appendChild(ripple);
                    
                    setTimeout(() => {
                        ripple.remove();
                    }, 600);
                });
            });
        });
    </script>
</body>
</html>
