<?php
// Database connection script for Panadite Academy
// This script imports the database schema from panadite_academy.sql
// Local database settings

$db_host = 'localhost'; // XAMPP MySQL server
$db_user = 'twpurnyc_149586Alain';  // Default XAMPP username
$db_pass = '149586Alain#'; 

// Create connection
$conn = new mysqli($db_host, $db_user, $db_pass);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

echo "Connected to MySQL successfully.<br>";

// Get the SQL file content
$sql_file = file_get_contents(__DIR__ . '/panadite_academy.sql');

if (!$sql_file) {
    die("Error: Could not read SQL file.");
}

echo "SQL file read successfully.<br>";

// Split SQL statements
$sql_statements = explode(';', $sql_file);
$total_statements = count($sql_statements);
$executed_statements = 0;

// Execute each statement
foreach ($sql_statements as $statement) {
    $statement = trim($statement);
    if (!empty($statement)) {
        if ($conn->query($statement)) {
            $executed_statements++;
        } else {
            echo "Error executing SQL statement: " . $conn->error . "<br>";
            echo "Statement: " . htmlspecialchars($statement) . "<br><br>";
        }
    }
}

echo "Executed $executed_statements out of $total_statements statements.<br>";

// Check if database was created
$result = $conn->query("SHOW DATABASES LIKE 'panadite_academy'");
if ($result->num_rows > 0) {
    echo "Database 'panadite_academy' was created successfully.<br>";
} else {
    echo "Warning: Database 'panadite_academy' was not found after import.<br>";
}

// Close the connection
$conn->close();
echo "Database setup completed.";
?>

<a href="../index.php">Return to homepage</a>
