<?php
/**
 * Database Migration: Add Video Embedding Support
 * Adds support for external video URLs from YouTube, Facebook, TikTok, Vimeo, etc.
 */

require_once '../includes/config.php';

echo "<h2>Adding Video Embedding Support...</h2>";

try {
    // Add new columns to videos table
    $migrations = [
        "ALTER TABLE videos ADD COLUMN IF NOT EXISTS video_type ENUM('file', 'url') DEFAULT 'file' AFTER video_url",
        "ALTER TABLE videos ADD COLUMN IF NOT EXISTS external_url TEXT AFTER video_type",
        "ALTER TABLE videos ADD COLUMN IF NOT EXISTS platform VARCHAR(50) AFTER external_url",
        "ALTER TABLE videos ADD COLUMN IF NOT EXISTS embed_code TEXT AFTER platform",
        "ALTER TABLE videos ADD COLUMN IF NOT EXISTS video_id_external VARCHAR(255) AFTER embed_code",
        "ALTER TABLE videos MODIFY COLUMN video_url VARCHAR(500) NULL",
        "ALTER TABLE videos ADD INDEX idx_video_type (video_type)",
        "ALTER TABLE videos ADD INDEX idx_platform (platform)"
    ];
    
    foreach ($migrations as $sql) {
        echo "<p>Executing: " . htmlspecialchars($sql) . "</p>";
        
        if ($conn->query($sql) === TRUE) {
            echo "<p style='color: green;'>✓ Success</p>";
        } else {
            echo "<p style='color: red;'>✗ Error: " . $conn->error . "</p>";
        }
    }
    
    echo "<h3 style='color: green;'>Migration completed successfully!</h3>";
    echo "<p><strong>New features added:</strong></p>";
    echo "<ul>";
    echo "<li>video_type: Distinguishes between 'file' uploads and 'url' embeds</li>";
    echo "<li>external_url: Stores the original URL from external platforms</li>";
    echo "<li>platform: Automatically detected platform (youtube, facebook, tiktok, vimeo, etc.)</li>";
    echo "<li>embed_code: Generated embed HTML for the video</li>";
    echo "<li>video_id_external: Extracted video ID from the platform</li>";
    echo "</ul>";
    
} catch (Exception $e) {
    echo "<h3 style='color: red;'>Migration failed!</h3>";
    echo "<p style='color: red;'>Error: " . $e->getMessage() . "</p>";
}

$conn->close();
?>
