<?php
/**
 * Set Unlimited File Uploads for Assessment System
 * Updates default file limits to support unlimited submissions
 */

require_once '../config/db_connect.php';

if (!isset($conn)) {
    die("Database connection failed.");
}

echo "<h2>📁 Setting Unlimited File Upload Support</h2>";
echo "<div style='font-family: Arial, sans-serif; max-width: 800px; margin: 0 auto; padding: 20px;'>";

try {
    // Update default file limits in assessment questions
    $sql1 = "ALTER TABLE sita_assessment_questions 
             ALTER COLUMN max_files_allowed SET DEFAULT 999,
             ALTER COLUMN min_files_required SET DEFAULT 0";
    
    if ($conn->query($sql1) === TRUE) {
        echo "<p>✅ Updated default file limits in assessment questions</p>";
    }

    // Update existing records to allow unlimited files
    $sql2 = "UPDATE sita_assessment_questions SET max_files_allowed = 999 WHERE max_files_allowed < 10";
    $result2 = $conn->query($sql2);
    echo "<p>✅ Updated " . $conn->affected_rows . " existing questions to allow unlimited files</p>";

    // Update file format presets to include unlimited files for images
    $sql3 = "UPDATE sita_file_format_presets 
             SET file_formats = JSON_ARRAY('jpg', 'jpeg', 'png', 'gif', 'webp', 'bmp', 'tiff', 'svg')
             WHERE preset_name = 'images'";
    
    if ($conn->query($sql3) === TRUE) {
        echo "<p>✅ Enhanced image format support</p>";
    }

    // Add unlimited mixed preset
    $unlimited_formats = json_encode(['pdf', 'doc', 'docx', 'txt', 'jpg', 'jpeg', 'png', 'gif', 'zip', 'rar', 'mp4', 'avi', 'mp3', 'xls', 'xlsx', 'ppt', 'pptx']);
    $sql4 = "INSERT IGNORE INTO sita_file_format_presets 
             (preset_name, preset_description, file_formats, max_file_size_mb) 
             VALUES ('unlimited_mixed', 'All common file types - unlimited quantity', '$unlimited_formats', 50)";
    
    if ($conn->query($sql4) === TRUE) {
        echo "<p>✅ Added unlimited mixed file format preset</p>";
    }

    echo "<div style='background: #d4edda; border: 1px solid #c3e6cb; color: #155724; padding: 15px; border-radius: 5px; margin: 20px 0;'>";
    echo "<h4>🎉 Unlimited File Upload Configuration Complete!</h4>";
    echo "<p><strong>Updates Applied:</strong></p>";
    echo "<ul>";
    echo "<li>✅ Default max files per question: <strong>999 (unlimited)</strong></li>";
    echo "<li>✅ Enhanced image format support: <strong>8 formats including SVG, WebP</strong></li>";
    echo "<li>✅ New unlimited mixed preset: <strong>All common file types</strong></li>";
    echo "<li>✅ Existing questions updated to unlimited</li>";
    echo "</ul>";
    echo "<p><strong>Students can now:</strong></p>";
    echo "<ul>";
    echo "<li>📸 Upload unlimited images for visual answers</li>";
    echo "<li>📄 Submit multiple documents without restriction</li>";
    echo "<li>🎥 Include video demonstrations</li>";
    echo "<li>📊 Attach spreadsheets and presentations</li>";
    echo "<li>💾 Upload code files and projects</li>";
    echo "</ul>";
    echo "</div>";

} catch (Exception $e) {
    echo "<div style='background: #f8d7da; border: 1px solid #f5c6cb; color: #721c24; padding: 15px; border-radius: 5px;'>";
    echo "<h4>❌ Update Failed</h4>";
    echo "<p>Error: " . $e->getMessage() . "</p>";
    echo "</div>";
}

echo "</div>";
echo "<p style='text-align: center; margin-top: 30px;'><a href='../student/course-detail.php' style='background: #007bff; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;'>← Back to Course</a></p>";
?>
