<?php
// Session Cookie Fixer for API calls
require_once '../includes/session_start.php';

echo "<h1>Session Cookie Diagnostics</h1>";

echo "<h2>Current Session</h2>";
echo "<pre>";
print_r($_SESSION);
echo "</pre>";

echo "<h2>Cookie Information</h2>";
echo "<pre>";
print_r($_COOKIE);
echo "</pre>";

// Fix session cookie path
$session_name = session_name();
$session_id = session_id();

echo "<h2>Session Settings</h2>";
echo "Session Name: " . $session_name . "<br>";
echo "Session ID: " . $session_id . "<br>";
echo "PHP Session Path: " . session_save_path() . "<br>";
echo "Current Cookie Path: " . ini_get('session.cookie_path') . "<br>";

// If we have an active session but cookie issue, try to fix it
if (!empty($_SESSION['user_id']) && !empty($_SESSION['user_role'])) {
    echo "<h2>Active Session Found</h2>";
    echo "User ID: " . $_SESSION['user_id'] . "<br>";
    echo "User Role: " . $_SESSION['user_role'] . "<br>";
    
    // Set a cookie with wider path to ensure API can access it
    setcookie($session_name, $session_id, [
        'path' => '/',               // Make cookie available across the entire site
        'domain' => '',              // Current domain only
        'secure' => false,           // Don't require HTTPS for localhost
        'httponly' => true,          // Not accessible via JavaScript
        'samesite' => 'Lax'          // Allow cross-site requests when following links
    ]);
    
    echo "<p style='color:green'>Cookie has been reset with path '/' to fix API access.</p>";
    echo "<p>Please try your message again after visiting this page.</p>";
} else {
    echo "<h2>No Active Session Found</h2>";
    echo "<p style='color:red'>You don't appear to be logged in. Please log in first.</p>";
}

echo "<h2>Actions</h2>";
echo "<ul>";
echo "<li><a href='../student/messages.php'>Return to Messages</a></li>";
echo "<li><a href='test_api.php'>Test API</a></li>";
echo "</ul>";
?>
