<?php
// Script to fix the teacher record for existing user
require_once '../config/db_connect.php';

echo "<h1>Fix Teacher Record</h1>";

// Get the teacher user
$teacherUserId = 2; // kahindo user
$stmt = $conn->prepare("SELECT * FROM users WHERE user_id = ?");
$stmt->bind_param("i", $teacherUserId);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $teacherUser = $result->fetch_assoc();
    echo "<p>Found teacher user: {$teacherUser['first_name']} {$teacherUser['last_name']} (ID: {$teacherUser['user_id']})</p>";
    
    // Check if teacher record exists
    $stmt = $conn->prepare("SELECT * FROM teachers WHERE user_id = ?");
    $stmt->bind_param("i", $teacherUserId);
    $stmt->execute();
    $teacherResult = $stmt->get_result();
    
    if ($teacherResult->num_rows > 0) {
        $teacher = $teacherResult->fetch_assoc();
        echo "<p>Teacher record already exists with teacher_id: {$teacher['teacher_id']}</p>";
    } else {
        // Create teacher record
        $firstName = $teacherUser['first_name'];
        $lastName = $teacherUser['last_name'];
        $bio = "Experienced educator with expertise in teaching.";
        
        $stmt = $conn->prepare("INSERT INTO teachers (user_id, first_name, last_name, bio, expertise) 
                               VALUES (?, ?, ?, ?, 'Teaching')");
        $stmt->bind_param("isss", $teacherUserId, $firstName, $lastName, $bio);
        
        if ($stmt->execute()) {
            $teacherId = $conn->insert_id;
            echo "<p>Created teacher record with teacher_id: $teacherId</p>";
            
            // Create a sample course for this teacher
            $categoryId = 1;
            $categoryCheck = $conn->query("SELECT category_id FROM categories LIMIT 1");
            if ($categoryCheck && $categoryCheck->num_rows > 0) {
                $row = $categoryCheck->fetch_assoc();
                $categoryId = $row['category_id'];
            } else {
                // Create a default category
                $conn->query("INSERT INTO categories (name, description) VALUES ('General', 'General courses')");
                $categoryId = $conn->insert_id;
                echo "<p>Created default category with ID: $categoryId</p>";
            }
            
            // Create course
            $title = "Introduction to Web Development";
            $description = "Learn the basics of HTML, CSS, and JavaScript";
            $price = 99.99;
            $isPublished = 1;
            $isApproved = 1;
            
            $stmt = $conn->prepare("INSERT INTO courses (teacher_id, category_id, title, description, price, is_published, is_approved) 
                                   VALUES (?, ?, ?, ?, ?, ?, ?)");
            $stmt->bind_param("iissdii", $teacherId, $categoryId, $title, $description, $price, $isPublished, $isApproved);
            
            if ($stmt->execute()) {
                $courseId = $conn->insert_id;
                echo "<p>Created course with ID: $courseId</p>";
                
                // Now enroll the student in this course
                $studentUserId = 3; // Lossi user
                
                // Get or create student record
                $stmt = $conn->prepare("SELECT student_id FROM students WHERE user_id = ?");
                $stmt->bind_param("i", $studentUserId);
                $stmt->execute();
                $studentResult = $stmt->get_result();
                
                if ($studentResult->num_rows > 0) {
                    $student = $studentResult->fetch_assoc();
                    $studentId = $student['student_id'];
                    echo "<p>Found existing student with ID: $studentId</p>";
                } else {
                    // Get student user details
                    $stmt = $conn->prepare("SELECT * FROM users WHERE user_id = ?");
                    $stmt->bind_param("i", $studentUserId);
                    $stmt->execute();
                    $studentUserResult = $stmt->get_result();
                    $studentUser = $studentUserResult->fetch_assoc();
                    
                    // Create student record
                    $studentFirstName = $studentUser['first_name'];
                    $studentLastName = $studentUser['last_name'];
                    
                    $stmt = $conn->prepare("INSERT INTO students (user_id, first_name, last_name, bio) 
                                          VALUES (?, ?, ?, 'Student account')");
                    $stmt->bind_param("iss", $studentUserId, $studentFirstName, $studentLastName);
                    $stmt->execute();
                    $studentId = $conn->insert_id;
                    echo "<p>Created student record with ID: $studentId</p>";
                }
                
                // Enroll student in course
                $stmt = $conn->prepare("INSERT INTO enrollments (student_id, user_id, course_id, progress, enrolled_date) 
                                       VALUES (?, ?, ?, 0, NOW())");
                $stmt->bind_param("iii", $studentId, $studentUserId, $courseId);
                
                if ($stmt->execute()) {
                    $enrollmentId = $conn->insert_id;
                    echo "<p>Enrolled student in course with enrollment ID: $enrollmentId</p>";
                    
                    // Create sample messages
                    $message1 = "Hello teacher, I have a question about the course material.";
                    $stmt = $conn->prepare("INSERT INTO messages (sender_id, recipient_id, message_text, is_read, sent_at) 
                                           VALUES (?, ?, ?, 0, NOW())");
                    $stmt->bind_param("iis", $studentUserId, $teacherUserId, $message1);
                    $stmt->execute();
                    $messageId1 = $conn->insert_id;
                    echo "<p>Created message from student to teacher with ID: $messageId1</p>";
                    
                    $message2 = "Hi there! How can I help you with the course?";
                    $stmt = $conn->prepare("INSERT INTO messages (sender_id, recipient_id, message_text, is_read, sent_at) 
                                           VALUES (?, ?, ?, 0, NOW())");
                    $stmt->bind_param("iis", $teacherUserId, $studentUserId, $message2);
                    $stmt->execute();
                    $messageId2 = $conn->insert_id;
                    echo "<p>Created message from teacher to student with ID: $messageId2</p>";
                    
                } else {
                    echo "<p>Error enrolling student: " . $conn->error . "</p>";
                }
            } else {
                echo "<p>Error creating course: " . $conn->error . "</p>";
            }
        } else {
            echo "<p>Error creating teacher record: " . $conn->error . "</p>";
        }
    }
} else {
    echo "<p>Teacher user not found!</p>";
}

echo "<h2>Setup Complete</h2>";
echo "<p>Now you can:</p>";
echo "<ul>
    <li><a href='test_messaging.php'>Go back to test messaging page</a></li>
    <li><a href='../student/login.php'>Go to login page</a></li>
    <li><a href='../student/messages.php'>Go to messages (as student)</a></li>
</ul>";
?>
