<?php
// Display current session info first
session_start();

echo "<h1>API Test Tool</h1>";
echo "<h2>Current Session Before Test</h2>";
echo "<pre>";
print_r($_SESSION);
echo "</pre>";

// Function to make a POST request to the API
function test_api_post($url, $data) {
    $options = [
        'http' => [
            'header' => "Content-type: application/x-www-form-urlencoded\r\n",
            'method' => 'POST',
            'content' => http_build_query($data),
            'cookies' => session_name() . '=' . session_id()
        ]
    ];
    
    $context = stream_context_create($options);
    $result = file_get_contents($url, false, $context);
    
    return $result;
}

// Test the message API if requested
$result = '';
if (isset($_POST['test_api'])) {
    $api_url = 'http://localhost:8000/student/api/send_message.php';
    $post_data = [
        'recipient_id' => $_POST['recipient_id'],
        'message' => $_POST['message'],
        'course_id' => $_POST['course_id']
    ];
    
    $result = test_api_post($api_url, $post_data);
}

// Add a form to test the API
echo "<h2>Test Message API</h2>";
echo "<form method='post'>";
echo "<div>Recipient ID: <input type='text' name='recipient_id' value='2'></div>";
echo "<div>Message: <input type='text' name='message' value='Test message'></div>";
echo "<div>Course ID: <input type='text' name='course_id' value=''></div>";
echo "<div><button type='submit' name='test_api'>Test API</button></div>";
echo "</form>";

// Show result if available
if (!empty($result)) {
    echo "<h3>API Response:</h3>";
    echo "<pre>";
    echo htmlspecialchars($result);
    echo "</pre>";
}

echo "<h2>Links</h2>";
echo "<ul>";
echo "<li><a href='check_session.php'>Back to Session Check</a></li>";
echo "</ul>";
?>
