<?php
// Quiz AI Grading Database Upgrade Script
require_once('../config/db_connect.php');

echo "<h1>🚀 Quiz AI Grading Database Upgrade</h1>";

// Check current quizzes table structure
echo "<h3>📊 Current Quizzes Table Structure:</h3>";
$result = $conn->query("DESCRIBE quizzes");
if ($result) {
    echo "<table border='1' style='border-collapse: collapse; margin-bottom: 20px;'>";
    echo "<tr><th>Column</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th></tr>";
    while ($row = $result->fetch_assoc()) {
        echo "<tr>";
        echo "<td>" . htmlspecialchars($row['Field']) . "</td>";
        echo "<td>" . htmlspecialchars($row['Type']) . "</td>";
        echo "<td>" . htmlspecialchars($row['Null']) . "</td>";
        echo "<td>" . htmlspecialchars($row['Key']) . "</td>";
        echo "<td>" . htmlspecialchars($row['Default'] ?? 'NULL') . "</td>";
        echo "</tr>";
    }
    echo "</table>";
}

echo "<h3>🔧 Adding Missing AI Grading Columns to Quizzes Table:</h3>";

// List of columns to add (MariaDB compatible)
$columns_to_add = [
    'answer_key' => "ADD COLUMN `answer_key` LONGTEXT",
    'ai_grading_enabled' => "ADD COLUMN `ai_grading_enabled` TINYINT(1) DEFAULT 1",
    'essay_questions' => "ADD COLUMN `essay_questions` LONGTEXT",
    'auto_grade_mcq' => "ADD COLUMN `auto_grade_mcq` TINYINT(1) DEFAULT 1", 
    'feedback_enabled' => "ADD COLUMN `feedback_enabled` TINYINT(1) DEFAULT 1"
];

$success_count = 0;
$already_exists_count = 0;

foreach ($columns_to_add as $column => $alter_sql) {
    // Check if column already exists
    $check_query = "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS 
                    WHERE TABLE_SCHEMA = DATABASE() 
                    AND TABLE_NAME = 'quizzes' 
                    AND COLUMN_NAME = '$column'";
    
    $result = $conn->query($check_query);
    
    if ($result && $result->num_rows > 0) {
        echo "Column <strong>$column</strong>: ✅ Already exists<br>";
        $already_exists_count++;
    } else {
        // Add the column
        $full_query = "ALTER TABLE `quizzes` $alter_sql";
        
        if ($conn->query($full_query)) {
            echo "Column <strong>$column</strong>: ✅ Added successfully<br>";
            $success_count++;
        } else {
            echo "Column <strong>$column</strong>: ❌ Error - " . $conn->error . "<br>";
        }
    }
}

echo "<br><h3>📋 Upgrade Summary:</h3>";
echo "✅ Columns added: $success_count<br>";
echo "ℹ️ Columns already existed: $already_exists_count<br>";

if ($success_count > 0 || $already_exists_count > 0) {
    echo "<br>🎉 Quizzes table is now ready for AI Grading!<br>";
    echo "You can now create quizzes with AI grading enabled.<br>";
    
    // Show updated table structure
    echo "<br><h3>📊 Updated Quizzes Table Structure:</h3>";
    $result = $conn->query("DESCRIBE quizzes");
    if ($result) {
        echo "<table border='1' style='border-collapse: collapse;'>";
        echo "<tr><th>Column</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th></tr>";
        while ($row = $result->fetch_assoc()) {
            $is_new = in_array($row['Field'], array_keys($columns_to_add));
            $style = $is_new ? " style='background-color: #d4edda;'" : "";
            echo "<tr$style>";
            echo "<td>" . htmlspecialchars($row['Field']) . "</td>";
            echo "<td>" . htmlspecialchars($row['Type']) . "</td>";
            echo "<td>" . htmlspecialchars($row['Null']) . "</td>";
            echo "<td>" . htmlspecialchars($row['Key']) . "</td>";
            echo "<td>" . htmlspecialchars($row['Default'] ?? 'NULL') . "</td>";
            echo "</tr>";
        }
        echo "</table>";
        echo "<small>Green rows = newly added AI grading columns</small>";
    }
}

echo "<br><br><a href='../teacher/create_quiz.php'>← Back to Create Quiz</a>";

$conn->close();
?>
