<?php
// Create a simple placeholder image
$width = 400;
$height = 225;  // 16:9 aspect ratio

// Create the image
$image = imagecreatetruecolor($width, $height);

// Define colors
$bg_color = imagecolorallocate($image, 40, 40, 40);  // Dark gray background
$text_color = imagecolorallocate($image, 255, 255, 255);  // White text

// Fill the background
imagefilledrectangle($image, 0, 0, $width, $height, $bg_color);

// Add a "play" button icon (simplified)
$center_x = $width / 2;
$center_y = $height / 2;

// Draw a play button icon
$play_size = min($width, $height) * 0.3;
$icon_color = imagecolorallocate($image, 220, 220, 220);  // Light gray icon

// Triangle play button
$points = [
    $center_x - $play_size/2, $center_y - $play_size/2,
    $center_x - $play_size/2, $center_y + $play_size/2,
    $center_x + $play_size/2, $center_y
];
imagefilledpolygon($image, $points, 3, $icon_color);

// Add "Video Placeholder" text
$font_size = 4;
$text = "Video Placeholder";
$text_width = imagefontwidth($font_size) * strlen($text);
$text_x = $center_x - ($text_width / 2);
$text_y = $height - 30;

imagestring($image, $font_size, $text_x, $text_y, $text, $text_color);

// Create directory if it doesn't exist
$directory = __DIR__ . '/assets/images/';
if (!is_dir($directory)) {
    mkdir($directory, 0777, true);
}

// Save the image
$file_path = $directory . 'video-placeholder.jpg';
imagejpeg($image, $file_path, 90);

// Free memory
imagedestroy($image);

echo "Placeholder image created at: " . $file_path;
?>
