<?php
/**
 * Database Configuration File
 * Panadite Academy
 */

// Prevent multiple inclusions
if (defined('CONFIG_INCLUDED')) {
    return;
}
define('CONFIG_INCLUDED', true);

// Include database override for when MySQL extensions aren't available
require_once __DIR__ . '/../override_db.php';

// Include the database status helper
require_once __DIR__ . '/db_status.php';




define('DB_SERVER', 'localhost');
define('DB_USERNAME', 'twpurnyc_149586Alain');
define('DB_PASSWORD', '149586Alain#');
define('DB_NAME', 'twpurnyc_panadite_DB');



// PayFast configuration
define('PAYFAST_MERCHANT_ID', '10038898'); // Default, will be overridden from database
define('PAYFAST_MERCHANT_KEY', 'jkeryt8c9i8sy'); // Default, will be overridden from database
define('PAYFAST_SANDBOX_URL', 'https://sandbox.payfast.co.za/eng/process');
define('PAYFAST_LIVE_URL', 'https://www.payfast.co.za/eng/process');
define('PAYFAST_SANDBOX_MODE', true); // Default to sandbox mode for testing

// Application paths
define('BASE_PATH', realpath(dirname(__FILE__) . '/..'));
define('BASE_URL', ''); // Empty string for serving from root
define('ASSETS_PATH', '/assets');
define('UPLOADS_PATH', BASE_PATH . '/uploads');
define('VIDEOS_PATH', BASE_PATH . '/videos');

// Database connection status is managed through db_status.php
set_db_status(false); // Start by assuming connection will succeed

// Check if MySQLi extension is available
$mysqli_available = class_exists('mysqli');

// Create database connection if MySQLi is available
$conn = null;
if ($mysqli_available) {
    try {
        $conn = new mysqli(DB_SERVER, DB_USERNAME, DB_PASSWORD, DB_NAME);
        
        // Check connection
        if ($conn->connect_error) {
            throw new Exception("Connection failed: " . $conn->connect_error);
        }
    } catch (Exception $e) {
        // During first installation, the database might not exist, so we'll create it
        try {
            $tempConn = new mysqli(DB_SERVER, DB_USERNAME, DB_PASSWORD);
            if (!$tempConn->connect_error) {
                $tempConn->query("CREATE DATABASE IF NOT EXISTS " . DB_NAME);
                $tempConn->close();
                
                // Try connecting again
                $conn = new mysqli(DB_SERVER, DB_USERNAME, DB_PASSWORD, DB_NAME);
                if ($conn->connect_error) {
                    $GLOBALS['db_connection_failed'] = true;
                    error_log("Database connection failed: " . $conn->connect_error);
                    $conn = null;
                }
            } else {
                $GLOBALS['db_connection_failed'] = true;
                error_log("Database connection failed: " . $tempConn->connect_error);
                $conn = null;
            }
        } catch (Exception $e) {
            $GLOBALS['db_connection_failed'] = true;
            error_log("Database connection failed: " . $e->getMessage());
            $conn = null;
        }
    }
} else {
    // MySQLi extension not available
    $GLOBALS['db_connection_failed'] = true;
    error_log("MySQLi extension not available. Please enable it in your PHP configuration.");
    $conn = null;
}

// Function to get PayFast settings from database
if (!function_exists('getPayfastSettings_safe')) {
function getPayfastSettings_safe() {
    global $conn;
    
    $settings = array(
        'merchant_id' => PAYFAST_MERCHANT_ID,
        'merchant_key' => PAYFAST_MERCHANT_KEY,
        'sandbox_mode' => PAYFAST_SANDBOX_MODE,
        'passphrase' => ''
    );
    
    // Check if database connection is available
    if ($conn === null || defined('DB_CONNECTION_FAILED') && DB_CONNECTION_FAILED) {
        // Return default settings if database is not available
        return $settings;
    }
    
    try {
        // Try different column names that might exist in the table
        $result = $conn->query("SELECT * FROM payfast_settings ORDER BY setting_id DESC LIMIT 1");
        
        if (!$result) {
            // Try without setting_id if that column doesn't exist
            $result = $conn->query("SELECT * FROM payfast_settings LIMIT 1");
        }
        
        if ($result && $result->num_rows > 0) {
            $row = $result->fetch_assoc();
            $settings['merchant_id'] = $row['merchant_id'] ?? PAYFAST_MERCHANT_ID;
            $settings['merchant_key'] = $row['merchant_key'] ?? PAYFAST_MERCHANT_KEY;
            $settings['sandbox_mode'] = isset($row['test_mode']) ? (bool)$row['test_mode'] : (isset($row['sandbox_mode']) ? (bool)$row['sandbox_mode'] : PAYFAST_SANDBOX_MODE);
            $settings['passphrase'] = $row['passphrase'] ?? '';
        }
    } catch (Exception $e) {
        // Log the error but continue with default settings
        error_log('Error fetching PayFast settings: ' . $e->getMessage());
    }
    
    return $settings;
}
}

// Backwards compatibility function
if (!function_exists('getPayfastSettings')) {
    function getPayfastSettings() {
        return getPayfastSettings_safe();
    }
}

// Site configuration
// Site configuration
$site_config = array(
    'site_name' => 'Panadite Academy',
    'site_tagline' => 'Get ahead of the curve',
    'admin_email' => 'admin@panadite.com',
    'support_email' => 'support@panadite.com',
    'site_url' => 'https://panaditeacademy.com',
    'theme_color_primary' => '#276BE4', // Blue
    'theme_color_secondary' => '#FFA915', // Orange
    'theme_color_light' => '#FFFFFF' // White
);
?>
