-- Create course materials table
CREATE TABLE IF NOT EXISTS `course_materials` (
  `material_id` int(11) NOT NULL AUTO_INCREMENT,
  `teacher_id` int(11) NOT NULL,
  `course_id` int(11) DEFAULT NULL,
  `title` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `category` varchar(100) NOT NULL,
  `file_path` varchar(512) NOT NULL,
  `file_size` int(11) DEFAULT NULL,
  `file_type` varchar(100) DEFAULT NULL,
  `download_count` int(11) DEFAULT 0,
  `date_added` datetime NOT NULL,
  `date_modified` datetime DEFAULT NULL,
  `status` enum('active','inactive','deleted') NOT NULL DEFAULT 'active',
  PRIMARY KEY (`material_id`),
  KEY `teacher_id` (`teacher_id`),
  KEY `course_id` (`course_id`),
  KEY `category` (`category`),
  KEY `status` (`status`),
  CONSTRAINT `course_materials_teacher_fk` FOREIGN KEY (`teacher_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE,
  CONSTRAINT `course_materials_course_fk` FOREIGN KEY (`course_id`) REFERENCES `courses` (`course_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Create index for efficient searching
CREATE INDEX IF NOT EXISTS `idx_course_materials_search` ON `course_materials` (`title`, `description`(255));

-- Create table for tracking student material views
CREATE TABLE IF NOT EXISTS `material_views` (
  `view_id` int(11) NOT NULL AUTO_INCREMENT,
  `material_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `view_date` datetime NOT NULL,
  PRIMARY KEY (`view_id`),
  KEY `material_id` (`material_id`),
  KEY `student_id` (`student_id`),
  CONSTRAINT `material_views_material_fk` FOREIGN KEY (`material_id`) REFERENCES `course_materials` (`material_id`) ON DELETE CASCADE,
  CONSTRAINT `material_views_student_fk` FOREIGN KEY (`student_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
