<?php
/**
 * Database Status Configuration
 * Panadite Academy
 * 
 * This file defines the global database connection status variable
 * that is used throughout the application.
 */

// Initialize the database connection status to "not failed" by default
if (!isset($GLOBALS['db_connection_failed'])) {
    $GLOBALS['db_connection_failed'] = false;
}

/**
 * Function to check if database connection is available
 * 
 * @return bool True if database is connected and working, false otherwise
 */
function is_db_connected() {
    return !isset($GLOBALS['db_connection_failed']) || !$GLOBALS['db_connection_failed'];
}

/**
 * Function to set the database connection status
 * 
 * @param bool $status True if connection failed, false if connection successful
 * @return void
 */
function set_db_status($status) {
    $GLOBALS['db_connection_failed'] = $status;
}
