<?php
// Start or resume session
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Function to check if user is logged in
function is_logged_in() {
    return isset($_SESSION['user_id']) && !empty($_SESSION['user_id']);
}

// Function to check if user has a specific role
function has_role($role) {
    return isset($_SESSION['user_role']) && $_SESSION['user_role'] === $role;
}

// Function to check if user is a teacher
function is_teacher() {
    return has_role('teacher');
}

// Function to check if user is a student
function is_student() {
    return has_role('student');
}

// Function to check if user is an admin
function is_admin() {
    return has_role('admin');
}

// Function to require a specific role, redirects if user doesn't have the required role
function requireRole($role) {
    if (!is_logged_in()) {
        // Not logged in, redirect to login
        header('Location: ../login.php?redirect=' . urlencode($_SERVER['REQUEST_URI']));
        exit;
    }
    
    if (!has_role($role)) {
        // Logged in but doesn't have required role
        header('Location: ../unauthorized.php');
        exit;
    }
    
    // User has required role, continue execution
    return true;
}

// Function to check if user has purchased a specific course
function has_purchased_course($conn, $user_id, $course_id) {
    try {
        // First check if enrollments table exists
        $tableCheckQuery = "SHOW TABLES LIKE 'enrollments'";
        $tableCheckResult = $conn->query($tableCheckQuery);
        
        if ($tableCheckResult->num_rows > 0) {
            // Check columns to determine the correct field name
            $columnQuery = "SHOW COLUMNS FROM enrollments LIKE 'student_id'";
            $columnResult = $conn->query($columnQuery);
            
            if ($columnResult->num_rows > 0) {
                // If student_id exists, use it
                $query = "SELECT * FROM enrollments WHERE student_id = ? AND course_id = ? AND status = 'active'"; 
            } else {
                // Otherwise use user_id
                $query = "SELECT * FROM enrollments WHERE user_id = ? AND course_id = ? AND status = 'active'";
            }
            
            $stmt = $conn->prepare($query);
            $stmt->bind_param("ii", $user_id, $course_id);
            $stmt->execute();
            $result = $stmt->get_result();
            return $result->num_rows > 0;
        }
        
        // As fallback, check if course_enrollments exists
        $tableCheckQuery = "SHOW TABLES LIKE 'course_enrollments'";
        $tableCheckResult = $conn->query($tableCheckQuery);
        
        if ($tableCheckResult->num_rows > 0) {
            $query = "SELECT * FROM course_enrollments WHERE student_id = ? AND course_id = ? AND status = 'active'"; 
            $stmt = $conn->prepare($query);
            $stmt->bind_param("ii", $user_id, $course_id);
            $stmt->execute();
            $result = $stmt->get_result();
            return $result->num_rows > 0;
        }
        
        // If no enrollment tables exist, return false
        return false;
    } catch (Exception $e) {
        // Log error but don't expose it to user
        error_log("Error checking course purchase: " . $e->getMessage());
        return false;
    }
}
