<?php
/**
 * Site Configuration Settings
 * This file contains global site configuration settings
 */

// NOTE: All session handling has been moved to includes/session_start.php
// This file now only contains site configuration settings

// Detect current domain and protocol automatically
function getSiteURL() {
    $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https://' : 'http://';
    $host = $_SERVER['HTTP_HOST'];
    return $protocol . $host;
}

// Base site URL (automatically detected)
$site_url = getSiteURL();

// Site name
$site_name = 'Panadite Academy';

// Default paths
$upload_path = 'uploads/';
$thumbnail_path = 'uploads/thumbnails/';
$video_path = 'uploads/videos/';

// Default redirects
function redirectTo($path) {
    global $site_url;
    $location = $site_url . '/' . ltrim($path, '/');
    header("Location: $location");
    exit;
}
?>
