<?php
session_start();
require_once 'includes/db_connection.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Instructor Support - Panadite Academy</title>
    <meta name="description" content="Get the support you need as an instructor at Panadite Academy. Access resources, community, and help to succeed in your teaching journey.">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    
    <style>
        :root {
            --primary-blue: #276BE4;
            --primary-amber: #FFA915;
            --dark-text: #2d3748;
            --light-text: #718096;
            --bg-light: #f8fafc;
            --border-color: #e2e8f0;
            --success-green: #10b981;
            --warning-orange: #f59e0b;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Inter', sans-serif;
            line-height: 1.6;
            color: var(--dark-text);
            background-color: var(--bg-light);
        }
        
        .hero-section {
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            color: var(--dark-text);
            padding: 4rem 0 3rem;
            margin-bottom: 3rem;
            border-bottom: 1px solid var(--border-color);
            position: relative;
            overflow: hidden;
        }
        
        .hero-section::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: 
                radial-gradient(circle at 25% 75%, rgba(16, 185, 129, 0.04) 0%, transparent 50%),
                radial-gradient(circle at 75% 25%, rgba(39, 107, 228, 0.04) 0%, transparent 50%);
            animation: backgroundPulse 8s ease-in-out infinite alternate;
        }
        
        @keyframes backgroundPulse {
            0% { opacity: 0.3; }
            100% { opacity: 0.8; }
        }
        
        .floating-element {
            position: absolute;
            pointer-events: none;
            opacity: 0.1;
        }
        
        .floating-element:nth-child(1) {
            top: 12%;
            left: 8%;
            animation: float1 8s ease-in-out infinite;
        }
        
        .floating-element:nth-child(2) {
            top: 65%;
            right: 12%;
            animation: float2 7s ease-in-out infinite reverse;
        }
        
        .floating-element:nth-child(3) {
            bottom: 20%;
            left: 72%;
            animation: float3 9s ease-in-out infinite;
        }
        
        @keyframes float1 {
            0%, 100% { transform: translate(0, 0) rotate(0deg); }
            50% { transform: translate(20px, -25px) rotate(180deg); }
        }
        
        @keyframes float2 {
            0%, 100% { transform: translate(0, 0) rotate(0deg); }
            50% { transform: translate(-35px, -20px) rotate(-180deg); }
        }
        
        @keyframes float3 {
            0%, 100% { transform: translate(0, 0) rotate(0deg); }
            50% { transform: translate(25px, 30px) rotate(360deg); }
        }
        
        .hero-content {
            position: relative;
            z-index: 2;
            animation: fadeInUp 1s ease-out;
        }
        
        .hero-content h1 {
            font-size: 2.5rem;
            font-weight: 700;
            margin-bottom: 1rem;
            line-height: 1.2;
            color: var(--dark-text);
            animation: fadeInUp 1s ease-out 0.2s both;
        }
        
        .hero-content p {
            font-size: 1.1rem;
            color: var(--light-text);
            margin-bottom: 2rem;
            max-width: 600px;
            line-height: 1.6;
            animation: fadeInUp 1s ease-out 0.4s both;
        }
        
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .support-stats {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
            gap: 1rem;
            margin-top: 2rem;
        }
        
        .stat-card {
            background: white;
            border-radius: 12px;
            padding: 1.5rem;
            text-align: center;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
            border: 1px solid var(--border-color);
        }
        
        .stat-number {
            font-size: 2rem;
            font-weight: 800;
            margin-bottom: 0.5rem;
            color: var(--primary-blue);
        }
        
        .stat-label {
            font-size: 0.9rem;
            color: var(--light-text);
        }
        
        .content-section {
            background: white;
            border-radius: 16px;
            padding: 3rem;
            margin-bottom: 2rem;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
            border: 1px solid var(--border-color);
        }
        
        .section-title {
            font-size: 1.75rem;
            font-weight: 700;
            color: var(--dark-text);
            margin-bottom: 1rem;
            display: flex;
            align-items: center;
        }
        
        .section-title i {
            background: linear-gradient(135deg, var(--success-green), #059669);
            color: white;
            width: 50px;
            height: 50px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 1rem;
            font-size: 1.25rem;
        }
        
        .support-card {
            background: var(--bg-light);
            border-radius: 12px;
            padding: 2rem;
            margin-bottom: 1.5rem;
            border-left: 4px solid var(--success-green);
            transition: all 0.3s ease;
        }
        
        .support-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(16, 185, 129, 0.15);
        }
        
        .support-title {
            font-size: 1.25rem;
            font-weight: 600;
            color: var(--dark-text);
            margin-bottom: 0.5rem;
            display: flex;
            align-items: center;
        }
        
        .support-title i {
            color: var(--success-green);
            margin-right: 0.75rem;
            font-size: 1.1rem;
        }
        
        .support-description {
            color: var(--light-text);
            font-size: 1rem;
            line-height: 1.6;
            margin-bottom: 1rem;
        }
        
        .contact-options {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 1.5rem;
            margin-top: 2rem;
        }
        
        .contact-card {
            background: white;
            border-radius: 12px;
            padding: 2rem;
            text-align: center;
            border: 1px solid var(--border-color);
            transition: all 0.3s ease;
        }
        
        .contact-card:hover {
            transform: translateY(-3px);
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        }
        
        .contact-icon {
            background: linear-gradient(135deg, var(--primary-blue), #1e5bcc);
            color: white;
            width: 60px;
            height: 60px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 1rem;
            font-size: 1.5rem;
        }
        
        .contact-title {
            font-size: 1.1rem;
            font-weight: 600;
            color: var(--dark-text);
            margin-bottom: 0.5rem;
        }
        
        .contact-description {
            color: var(--light-text);
            font-size: 0.9rem;
            margin-bottom: 1rem;
        }
        
        .contact-btn {
            background: var(--primary-blue);
            color: white;
            padding: 0.75rem 1.5rem;
            border-radius: 8px;
            text-decoration: none;
            font-weight: 600;
            font-size: 0.9rem;
            display: inline-block;
            transition: all 0.3s ease;
        }
        
        .contact-btn:hover {
            background: #1e5bcc;
            color: white;
            transform: translateY(-1px);
        }
        
        .faq-item {
            border: 1px solid var(--border-color);
            border-radius: 8px;
            margin-bottom: 1rem;
            overflow: hidden;
        }
        
        .faq-question {
            background: white;
            padding: 1.5rem;
            cursor: pointer;
            display: flex;
            justify-content: space-between;
            align-items: center;
            font-weight: 600;
            color: var(--dark-text);
            transition: all 0.3s ease;
        }
        
        .faq-question:hover {
            background: var(--bg-light);
        }
        
        .faq-answer {
            background: var(--bg-light);
            padding: 0 1.5rem 1.5rem;
            color: var(--light-text);
            display: none;
        }
        
        .resource-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 1.5rem;
            margin-top: 2rem;
        }
        
        .resource-card {
            background: white;
            border: 1px solid var(--border-color);
            border-radius: 12px;
            padding: 1.5rem;
            transition: all 0.3s ease;
        }
        
        .resource-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(0, 0, 0, 0.1);
        }
        
        .resource-icon {
            background: linear-gradient(135deg, var(--primary-amber), #ff8f00);
            color: white;
            width: 45px;
            height: 45px;
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 1rem;
            font-size: 1.1rem;
        }
        
        .back-btn {
            background: white;
            color: var(--primary-blue);
            border: 1px solid var(--border-color);
            padding: 0.75rem 1.5rem;
            border-radius: 8px;
            text-decoration: none;
            font-weight: 600;
            display: inline-flex;
            align-items: center;
            transition: all 0.3s ease;
            margin-bottom: 2rem;
        }
        
        .back-btn:hover {
            background: var(--bg-light);
            border-color: var(--primary-blue);
            color: var(--primary-blue);
        }
        
        .back-btn i {
            margin-right: 0.5rem;
        }
    </style>
</head>
<body>
    <?php include 'includes/navbar.php'; ?>
    
    <!-- Hero Section -->
    <section class="hero-section">
        <!-- Floating animated elements -->
        <div class="floating-element">
            <i class="fas fa-headset" style="font-size: 50px; color: #10b981;"></i>
        </div>
        <div class="floating-element">
            <i class="fas fa-heart" style="font-size: 42px; color: var(--primary-blue);"></i>
        </div>
        <div class="floating-element">
            <i class="fas fa-users" style="font-size: 45px; color: var(--primary-amber);"></i>
        </div>
        
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-8">
                    <div class="hero-content">
                        <h1>Instructor Support</h1>
                        <p>We're here to help you succeed! Access comprehensive support resources, connect with our community, and get the assistance you need throughout your teaching journey.</p>
                    </div>
                    <div class="support-stats">
                        <div class="stat-card">
                            <div class="stat-number">24/7</div>
                            <div class="stat-label">Support Available</div>
                        </div>
                        <div class="stat-card">
                            <div class="stat-number">500+</div>
                            <div class="stat-label">Help Articles</div>
                        </div>
                        <div class="stat-card">
                            <div class="stat-number">98%</div>
                            <div class="stat-label">Satisfaction Rate</div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 text-center">
                    <div style="background: white; border-radius: 16px; padding: 2rem; box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08); border: 1px solid var(--border-color);">
                        <i class="fas fa-headset" style="font-size: 3rem; margin-bottom: 1rem; color: var(--success-green);"></i>
                        <h4 style="margin: 0; font-weight: 700; color: var(--dark-text);">We're Here to Help</h4>
                        <p style="margin: 0.5rem 0 0; color: var(--light-text); font-size: 0.95rem;">Expert Support Team</p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
    <div class="container">
        <a href="index.php" class="back-btn">
            <i class="fas fa-arrow-left"></i>
            Back to Home
        </a>
        
        <!-- Support Channels -->
        <div class="content-section">
            <h2 class="section-title">
                <i class="fas fa-hands-helping"></i>
                How We Support You
            </h2>
            <div class="contact-options">
                <div class="contact-card">
                    <div class="contact-icon">
                        <i class="fas fa-comments"></i>
                    </div>
                    <h4 class="contact-title">Live Chat Support</h4>
                    <p class="contact-description">Get instant help from our support team during business hours.</p>
                    <a href="#" class="contact-btn">Start Chat</a>
                </div>
                <div class="contact-card">
                    <div class="contact-icon">
                        <i class="fas fa-envelope"></i>
                    </div>
                    <h4 class="contact-title">Email Support</h4>
                    <p class="contact-description">Send us detailed questions and receive comprehensive responses.</p>
                    <a href="mailto:instructors@panaditeacademy.com" class="contact-btn">Send Email</a>
                </div>
                <div class="contact-card">
                    <div class="contact-icon">
                        <i class="fas fa-users"></i>
                    </div>
                    <h4 class="contact-title">Community Forum</h4>
                    <p class="contact-description">Connect with other instructors and share experiences.</p>
                    <a href="#" class="contact-btn">Join Forum</a>
                </div>
                <div class="contact-card">
                    <div class="contact-icon">
                        <i class="fas fa-calendar-alt"></i>
                    </div>
                    <h4 class="contact-title">One-on-One Sessions</h4>
                    <p class="contact-description">Schedule personalized support sessions with our team.</p>
                    <a href="#" class="contact-btn">Book Session</a>
                </div>
            </div>
        </div>
        
        <!-- Support Areas -->
        <div class="content-section">
            <h2 class="section-title">
                <i class="fas fa-tools"></i>
                Support Areas
            </h2>
            <div class="row">
                <div class="col-md-6">
                    <div class="support-card">
                        <div class="support-title">
                            <i class="fas fa-video"></i>
                            Course Creation Support
                        </div>
                        <div class="support-description">
                            Get help with planning, recording, and publishing your courses. Our team provides guidance on content structure, technical setup, and best practices.
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="support-card">
                        <div class="support-title">
                            <i class="fas fa-chart-line"></i>
                            Marketing & Promotion
                        </div>
                        <div class="support-description">
                            Learn how to effectively market your courses and grow your student base. Access promotional tools and strategies to increase enrollment.
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="support-card">
                        <div class="support-title">
                            <i class="fas fa-cog"></i>
                            Technical Assistance
                        </div>
                        <div class="support-description">
                            Resolve technical issues quickly with our expert support team. From platform navigation to video upload troubleshooting.
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="support-card">
                        <div class="support-title">
                            <i class="fas fa-dollar-sign"></i>
                            Payment & Analytics
                        </div>
                        <div class="support-description">
                            Understand your earnings, payment schedules, and analytics. Get help with financial reporting and performance insights.
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Resources -->
        <div class="content-section">
            <h2 class="section-title">
                <i class="fas fa-book"></i>
                Learning Resources
            </h2>
            <div class="resource-grid">
                <div class="resource-card">
                    <div class="resource-icon">
                        <i class="fas fa-graduation-cap"></i>
                    </div>
                    <h4>Instructor Academy</h4>
                    <p>Comprehensive training program covering all aspects of online teaching and course creation.</p>
                </div>
                <div class="resource-card">
                    <div class="resource-icon">
                        <i class="fas fa-file-alt"></i>
                    </div>
                    <h4>Knowledge Base</h4>
                    <p>Extensive collection of articles, tutorials, and guides to help you at every step of your journey.</p>
                </div>
                <div class="resource-card">
                    <div class="resource-icon">
                        <i class="fas fa-play-circle"></i>
                    </div>
                    <h4>Video Tutorials</h4>
                    <p>Step-by-step video guides covering platform features, course creation, and teaching strategies.</p>
                </div>
                <div class="resource-card">
                    <div class="resource-icon">
                        <i class="fas fa-download"></i>
                    </div>
                    <h4>Template Library</h4>
                    <p>Ready-to-use templates for course outlines, presentations, and promotional materials.</p>
                </div>
            </div>
        </div>
        
        <!-- FAQ Section -->
        <div class="content-section">
            <h2 class="section-title">
                <i class="fas fa-question-circle"></i>
                Frequently Asked Questions
            </h2>
            <div class="faq-item">
                <div class="faq-question" onclick="toggleFaq(this)">
                    How do I get paid for my courses?
                    <i class="fas fa-chevron-down"></i>
                </div>
                <div class="faq-answer">
                    Payments are processed monthly via bank transfer or PayPal. You'll receive detailed earnings reports and can track your revenue in real-time through your instructor dashboard.
                </div>
            </div>
            <div class="faq-item">
                <div class="faq-question" onclick="toggleFaq(this)">
                    What support do I get for marketing my courses?
                    <i class="fas fa-chevron-down"></i>
                </div>
                <div class="faq-answer">
                    We provide marketing resources, promotional opportunities, and guidance on optimizing your course for better visibility. Top courses may be featured on our homepage and marketing materials.
                </div>
            </div>
            <div class="faq-item">
                <div class="faq-question" onclick="toggleFaq(this)">
                    How quickly can I expect support responses?
                    <i class="fas fa-chevron-down"></i>
                </div>
                <div class="faq-answer">
                    Live chat responses are immediate during business hours. Email support typically responds within 24 hours. For urgent issues, we prioritize faster response times.
                </div>
            </div>
            <div class="faq-item">
                <div class="faq-question" onclick="toggleFaq(this)">
                    Can I get help with course content review?
                    <i class="fas fa-chevron-down"></i>
                </div>
                <div class="faq-answer">
                    Yes! Our content specialists can review your course structure, provide feedback, and suggest improvements to enhance student learning outcomes.
                </div>
            </div>
        </div>
    </div>
    
    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
    
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        function toggleFaq(element) {
            const answer = element.nextElementSibling;
            const icon = element.querySelector('i');
            
            if (answer.style.display === 'block') {
                answer.style.display = 'none';
                icon.classList.remove('fa-chevron-up');
                icon.classList.add('fa-chevron-down');
            } else {
                // Close all other FAQs
                document.querySelectorAll('.faq-answer').forEach(faq => {
                    faq.style.display = 'none';
                });
                document.querySelectorAll('.faq-question i').forEach(i => {
                    i.classList.remove('fa-chevron-up');
                    i.classList.add('fa-chevron-down');
                });
                
                // Open this FAQ
                answer.style.display = 'block';
                icon.classList.remove('fa-chevron-down');
                icon.classList.add('fa-chevron-up');
            }
        }
    </script>
</body>
</html>
