<?php
/**
 * Universal Logout Handler
 * Panadite Academy
 * This file will handle logout correctly from any part of the application
 */

// We should NOT include session_start.php here since it would attempt to modify session settings
// Instead, we'll directly work with the existing session

// Check if a session is already active
if (session_status() === PHP_SESSION_ACTIVE) {
    // Clear all session data
    $_SESSION = array();
    
    // Clear session cookie
    if (ini_get("session.use_cookies")) {
        $params = session_get_cookie_params();
        setcookie(session_name(), '', time() - 42000,
            $params["path"], $params["domain"],
            $params["secure"], $params["httponly"]
        );
    }
    
    // Destroy session
    session_destroy();
} else {
    // If no session is active, start one just to make sure we clear everything
    session_start();
    $_SESSION = array();
    session_destroy();
}

// Delete all other cookies
foreach ($_COOKIE as $name => $value) {
    unset($_COOKIE[$name]);
    setcookie($name, '', time() - 3600, '/');
}

// We couldn't find a specific teacher login page, so we'll redirect to the main login page
// Append a success parameter so the login page can show a success message
$redirect = 'login.php?logout=success';

// Redirect to the login page
header("Location: $redirect");
exit;

