<?php
/**
 * Database Connection Override
 * This file provides a fallback database connection when MySQL extensions are not available
 */

// Only execute this code if the file is included directly
if (!defined('DB_OVERRIDE_INCLUDED')) {
    define('DB_OVERRIDE_INCLUDED', true);

    // Note that we detected the database connection issue
    $GLOBALS['db_connection_warning'] = "Using alternative database connection method";

    /**
     * Alternative fetchAll function when PDO is not available
     */
    function alt_fetchAll($sql, $params = []) {
        // Connect using mysqli directly
        $conn = mysqli_connect('localhost', 'root', '', 'panadite_academy');
        
        if (!$conn) {
            error_log('Alternative database connection failed: ' . mysqli_connect_error());
            return [];
        }
        
        // Handle parameters by manual replacement (simplified)
        if (!empty($params)) {
            foreach ($params as $param) {
                // Very simple parameter replacement - not for production
                $sql = preg_replace('/\?/', "'" . mysqli_real_escape_string($conn, $param) . "'", $sql, 1);
            }
        }
        
        $result = mysqli_query($conn, $sql);
        
        if (!$result) {
            error_log('Query failed: ' . mysqli_error($conn));
            mysqli_close($conn);
            return [];
        }
        
        $rows = [];
        while ($row = mysqli_fetch_assoc($result)) {
            $rows[] = $row;
        }
        
        mysqli_close($conn);
        return $rows;
    }
    
    /**
     * Alternative fetchOne function when PDO is not available
     */
    function alt_fetchOne($sql, $params = []) {
        $results = alt_fetchAll($sql, $params);
        return !empty($results) ? $results[0] : null;
    }
    
    // Override the fetchAll and fetchOne functions
    if (!function_exists('fetchAll')) {
        function fetchAll($sql, $params = []) {
            return alt_fetchAll($sql, $params);
        }
    }
    
    if (!function_exists('fetchOne')) {
        function fetchOne($sql, $params = []) {
            return alt_fetchOne($sql, $params);
        }
    }
    
    // Database connection global variables to avoid errors
    $GLOBALS['pdo'] = null;
    $GLOBALS['conn'] = null;
    $GLOBALS['db_connection_failed'] = false;
}
?>
