<?php
/**
 * Helper script to clear test reminder data
 */

header('Content-Type: application/json');
require_once '../config/database.php';

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Only POST method allowed');
    }
    
    // Clear test reminders (only those with "TEST" in description)
    $delete_reminders = $conn->prepare("DELETE FROM study_reminders WHERE description LIKE '%TEST REMINDER%' OR description LIKE '%test%'");
    $deleted_reminders = $delete_reminders->execute();
    $reminders_affected = $conn->affected_rows;
    
    // Clear old reminder logs (older than 1 day)
    $delete_logs = $conn->prepare("DELETE FROM reminder_log WHERE sent_at < DATE_SUB(NOW(), INTERVAL 1 DAY)");
    $deleted_logs = $delete_logs->execute();
    $logs_affected = $conn->affected_rows;
    
    echo json_encode([
        'success' => true,
        'message' => 'Test data cleared successfully',
        'details' => [
            'reminders_deleted' => $reminders_affected,
            'logs_deleted' => $logs_affected
        ]
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}

$conn->close();
?>
