<?php
/**
 * Web-based Setup Script for Study Reminders System
 * Visit this page in your browser to set up the database tables and automated reminder system
 */

// Security check - remove this in production or add proper authentication
$setup_password = "panadite2024"; // Change this password!

if (isset($_POST['setup_password']) && $_POST['setup_password'] !== $setup_password) {
    $error = "Incorrect setup password!";
} elseif (isset($_POST['setup_password']) && $_POST['setup_password'] === $setup_password) {
    $run_setup = true;
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Study Reminders System Setup</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">
    <style>
        body { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); min-height: 100vh; }
        .setup-container { background: white; border-radius: 20px; box-shadow: 0 20px 60px rgba(0,0,0,0.1); }
        .setup-header { background: linear-gradient(135deg, #FF6B6B 0%, #4ECDC4 100%); color: white; padding: 2rem; border-radius: 20px 20px 0 0; }
        .step-indicator { background: #f8f9fa; border-radius: 15px; padding: 1rem; margin-bottom: 1rem; }
        .log-output { background: #000; color: #00ff00; font-family: 'Courier New', monospace; padding: 1rem; border-radius: 10px; max-height: 400px; overflow-y: auto; }
        .success-indicator { color: #28a745; }
        .error-indicator { color: #dc3545; }
        .warning-indicator { color: #ffc107; }
    </style>
</head>
<body>
    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-md-10 col-lg-8">
                <div class="setup-container">
                    <div class="setup-header text-center">
                        <h1><i class="bx bx-cog me-2"></i>Study Reminders System Setup</h1>
                        <p class="mb-0">Set up database tables and automated reminder system</p>
                    </div>
                    
                    <div class="p-4">
                        <?php if (!isset($run_setup)): ?>
                            <!-- Password Form -->
                            <div class="text-center mb-4">
                                <div class="step-indicator">
                                    <h5><i class="bx bx-shield-check text-primary me-2"></i>Security Check</h5>
                                    <p class="mb-0">Enter the setup password to proceed</p>
                                </div>
                            </div>
                            
                            <?php if (isset($error)): ?>
                                <div class="alert alert-danger">
                                    <i class="bx bx-error-circle me-2"></i><?= htmlspecialchars($error) ?>
                                </div>
                            <?php endif; ?>
                            
                            <form method="POST" class="text-center">
                                <div class="row justify-content-center">
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <input type="password" class="form-control form-control-lg" name="setup_password" placeholder="Enter setup password" required>
                                        </div>
                                        <button type="submit" class="btn btn-primary btn-lg">
                                            <i class="bx bx-rocket me-2"></i>Start Setup
                                        </button>
                                    </div>
                                </div>
                            </form>
                            
                            <div class="mt-4">
                                <div class="alert alert-info">
                                    <h6><i class="bx bx-info-circle me-2"></i>What this setup will do:</h6>
                                    <ul class="mb-0">
                                        <li>Create <code>study_reminders</code> table</li>
                                        <li>Create <code>reminder_log</code> table for tracking</li>
                                        <li>Create <code>reminder_system_config</code> table</li>
                                        <li>Insert default configuration settings</li>
                                        <li>Create sample reminder data (optional)</li>
                                        <li>Set up automated reminder checking system</li>
                                    </ul>
                                </div>
                            </div>
                            
                        <?php else: ?>
                            <!-- Run Setup -->
                            <div class="step-indicator text-center mb-4">
                                <h5><i class="bx bx-play-circle text-success me-2"></i>Running Setup Process...</h5>
                                <p class="mb-0">Please wait while we set up your study reminders system</p>
                            </div>
                            
                            <div class="log-output" id="setupLog">
                                <div>🚀 Starting Study Reminders System Setup...</div>
                                <div>📡 Connecting to database...</div>
                            </div>
                            
                            <div class="mt-4" id="setupResults" style="display: none;">
                                <!-- Results will be populated by JavaScript -->
                            </div>
                            
                            <script>
                                // Simulate setup process and fetch real results
                                function runSetup() {
                                    const log = document.getElementById('setupLog');
                                    const results = document.getElementById('setupResults');
                                    
                                    // Show progress
                                    const steps = [
                                        '🏗️ Creating study_reminders table...',
                                        '📋 Creating reminder_log table...',
                                        '⚙️ Creating reminder_system_config table...',
                                        '📝 Inserting default configuration...',
                                        '🎯 Setting up automated reminder system...',
                                        '📊 Verifying table structures...',
                                        '✅ Setup completed successfully!'
                                    ];
                                    
                                    let stepIndex = 0;
                                    
                                    function showNextStep() {
                                        if (stepIndex < steps.length) {
                                            log.innerHTML += '<div>' + steps[stepIndex] + '</div>';
                                            log.scrollTop = log.scrollHeight;
                                            stepIndex++;
                                            setTimeout(showNextStep, 800);
                                        } else {
                                            // Setup completed, fetch actual results
                                            fetch('run_setup.php', {
                                                method: 'POST',
                                                headers: { 'Content-Type': 'application/json' },
                                                body: JSON.stringify({ action: 'setup', password: '<?= $setup_password ?>' })
                                            })
                                            .then(response => response.json())
                                            .then(data => {
                                                showResults(data);
                                            })
                                            .catch(error => {
                                                showError('Setup failed: ' + error.message);
                                            });
                                        }
                                    }
                                    
                                    showNextStep();
                                }
                                
                                function showResults(data) {
                                    const results = document.getElementById('setupResults');
                                    
                                    if (data.success) {
                                        results.innerHTML = `
                                            <div class="alert alert-success">
                                                <h5><i class="bx bx-check-circle me-2"></i>Setup Completed Successfully!</h5>
                                                <p>Your study reminders system is now ready to use.</p>
                                                <ul>
                                                    <li>✅ Database tables created</li>
                                                    <li>✅ Configuration settings applied</li>
                                                    <li>✅ Automated reminder system configured</li>
                                                </ul>
                                            </div>
                                            
                                            <div class="alert alert-warning">
                                                <h6><i class="bx bx-time me-2"></i>Important: Set up Automatic Reminders</h6>
                                                <p>To enable automatic reminder emails, you need to set up a cron job:</p>
                                                <div class="bg-dark text-light p-3 rounded">
                                                    <code>*/5 * * * * cd ${data.project_path}/cron && php check_reminders.php</code>
                                                </div>
                                                <small class="text-muted">This will check for due reminders every 5 minutes.</small>
                                            </div>
                                            
                                            <div class="alert alert-info">
                                                <h6><i class="bx bx-test-tube me-2"></i>Test the System</h6>
                                                <p>You can test the automatic reminder system by:</p>
                                                <ol>
                                                    <li>Creating a reminder for a few minutes from now</li>
                                                    <li>Running the cron script manually: <code>php cron/check_reminders.php</code></li>
                                                    <li>Checking your email for the reminder notification</li>
                                                </ol>
                                            </div>
                                            
                                            <div class="text-center mt-4">
                                                <a href="../student/course-detail.php" class="btn btn-primary btn-lg">
                                                    <i class="bx bx-rocket me-2"></i>Go to Course Page
                                                </a>
                                                <a href="test_reminders.php" class="btn btn-outline-info btn-lg ms-2">
                                                    <i class="bx bx-test-tube me-2"></i>Test System
                                                </a>
                                            </div>
                                        `;
                                    } else {
                                        showError(data.message || 'Setup failed');
                                    }
                                    
                                    results.style.display = 'block';
                                }
                                
                                function showError(message) {
                                    const results = document.getElementById('setupResults');
                                    results.innerHTML = `
                                        <div class="alert alert-danger">
                                            <h5><i class="bx bx-error-circle me-2"></i>Setup Failed</h5>
                                            <p>${message}</p>
                                            <button onclick="location.reload()" class="btn btn-outline-danger">
                                                <i class="bx bx-refresh me-2"></i>Try Again
                                            </button>
                                        </div>
                                    `;
                                    results.style.display = 'block';
                                }
                                
                                // Start setup automatically
                                runSetup();
                            </script>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
