<?php
/**
 * Restore Working SMTP Configuration - Panadite Academy
 * Revert to your original working TLS configuration
 */

require_once __DIR__ . '/../config/db_connect.php';

$success = false;
$error = '';

if ($_POST && isset($_POST['restore_config'])) {
    $config = $_POST['config'];
    
    try {
        if ($config === 'original') {
            // Restore original TLS on port 465 (your working config)
            $settings = [
                'smtp_enabled' => '1',
                'smtp_host' => 'lon106b.superfasthost.cloud',
                'smtp_port' => '465',
                'smtp_encryption' => 'tls', // Back to TLS as you had it working
                'smtp_username' => 'testme@panaditeacademy.com',
                'smtp_password' => $_POST['smtp_password'] ?? '',
                'smtp_auth' => '1',
                'from_email' => 'testme@panaditeacademy.com',
                'from_name' => 'Panadite Academy'
            ];
        } else {
            // Try standard port 587 with TLS
            $settings = [
                'smtp_enabled' => '1',
                'smtp_host' => 'lon106b.superfasthost.cloud',
                'smtp_port' => '587',
                'smtp_encryption' => 'tls',
                'smtp_username' => 'testme@panaditeacademy.com',
                'smtp_password' => $_POST['smtp_password'] ?? '',
                'smtp_auth' => '1',
                'from_email' => 'testme@panaditeacademy.com',
                'from_name' => 'Panadite Academy'
            ];
        }
        
        // Update database settings
        if ($pdo) {
            foreach ($settings as $key => $value) {
                $stmt = $pdo->prepare("INSERT INTO system_settings (setting_group, setting_key, setting_value) VALUES ('email', ?, ?) ON DUPLICATE KEY UPDATE setting_value = ?");
                $stmt->execute([$key, $value, $value]);
            }
            $success = true;
        }
        
    } catch (Exception $e) {
        $error = $e->getMessage();
    }
}

// Get current settings
$currentSettings = [];
if ($pdo) {
    try {
        $stmt = $pdo->prepare("SELECT setting_key, setting_value FROM system_settings WHERE setting_group = 'email'");
        $stmt->execute();
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        foreach ($results as $row) {
            $currentSettings[$row['setting_key']] = $row['setting_value'];
        }
    } catch (Exception $e) {
        // Continue
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Restore Working SMTP - Panadite Academy</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">
</head>
<body class="bg-light">
    <div class="container mt-5">
        <div class="row justify-content-center">
            <div class="col-md-10">
                <div class="card shadow">
                    <div class="card-header bg-success text-white">
                        <h4 class="mb-0"><i class="bx bx-refresh"></i> Restore Working SMTP Configuration</h4>
                    </div>
                    <div class="card-body">
                        
                        <div class="alert alert-warning">
                            <h6><i class="bx bx-info-circle"></i> My Apologies!</h6>
                            <p>I changed your working TLS configuration to SSL, which broke your email sending. Let me restore your original working settings.</p>
                        </div>
                        
                        <?php if ($success): ?>
                            <div class="alert alert-success">
                                <h6><i class="bx bx-check-circle"></i> Configuration Restored!</h6>
                                <p>Your SMTP settings have been restored. Now test:</p>
                                <div class="mt-3">
                                    <a href="/auth/register.php" class="btn btn-success">
                                        <i class="bx bx-user-plus"></i> Test Registration Now
                                    </a>
                                    <a href="debug_email_deep.php" class="btn btn-info ms-2">
                                        <i class="bx bx-test-tube"></i> Run Debug Test
                                    </a>
                                </div>
                            </div>
                        <?php elseif ($error): ?>
                            <div class="alert alert-danger">
                                <i class="bx bx-error-circle"></i> Error: <?php echo htmlspecialchars($error); ?>
                            </div>
                        <?php endif; ?>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <h5><i class="bx bx-x-circle text-danger"></i> Current (Broken) Configuration</h5>
                                <div class="table-responsive">
                                    <table class="table table-sm table-bordered">
                                        <tr class="table-danger">
                                            <td><strong>Port</strong></td>
                                            <td><?php echo htmlspecialchars($currentSettings['smtp_port'] ?? 'Not set'); ?></td>
                                        </tr>
                                        <tr class="table-danger">
                                            <td><strong>Encryption</strong></td>
                                            <td><?php echo htmlspecialchars($currentSettings['smtp_encryption'] ?? 'Not set'); ?> ❌</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Status</strong></td>
                                            <td><span class="badge bg-danger">Broken Pipe Errors</span></td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <h5><i class="bx bx-check-circle text-success"></i> Restore Options</h5>
                                <div class="card">
                                    <div class="card-body">
                                        <p><strong>Option 1: Your Original Working Config</strong></p>
                                        <ul class="small">
                                            <li>Port: 465</li>
                                            <li>Encryption: TLS (as you had it)</li>
                                            <li>Status: Was working before my changes</li>
                                        </ul>
                                        
                                        <p><strong>Option 2: Standard Configuration</strong></p>
                                        <ul class="small">
                                            <li>Port: 587</li>
                                            <li>Encryption: TLS</li>
                                            <li>Status: Industry standard</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <hr>
                        
                        <h5><i class="bx bx-refresh"></i> Restore Configuration</h5>
                        
                        <form method="POST" action="">
                            <div class="mb-3">
                                <label for="smtp_password" class="form-label">SMTP Password</label>
                                <input type="password" class="form-control" id="smtp_password" name="smtp_password" 
                                       placeholder="Enter your SMTP password" required>
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label">Choose Configuration:</label>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="config" value="original" id="original" checked>
                                    <label class="form-check-label" for="original">
                                        <strong>Restore Original (Port 465 + TLS)</strong> - Your working configuration
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="config" value="standard" id="standard">
                                    <label class="form-check-label" for="standard">
                                        <strong>Try Standard (Port 587 + TLS)</strong> - Industry standard
                                    </label>
                                </div>
                            </div>
                            
                            <button type="submit" name="restore_config" class="btn btn-success btn-lg">
                                <i class="bx bx-refresh"></i> Restore Working Configuration
                            </button>
                        </form>
                        
                        <div class="mt-4">
                            <div class="alert alert-info">
                                <h6><i class="bx bx-lightbulb"></i> After Restoring:</h6>
                                <ol>
                                    <li><strong>Test registration immediately</strong> at <code>/auth/register.php</code></li>
                                    <li><strong>Check your email</strong> (should arrive within 1-2 minutes)</li>
                                    <li><strong>Remember:</strong> 10-minute verification expiry (as requested)</li>
                                    <li><strong>If it still fails:</strong> Run the debug tool to see specific errors</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
