<?php
/**
 * Email Verification Setup Script - Panadite Academy
 * Run this script to set up email verification functionality
 */

require_once __DIR__ . '/../config/email_verification_service.php';

// Set content type
header('Content-Type: text/html; charset=UTF-8');

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Email Verification Setup - Panadite Academy</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">
</head>
<body class="bg-light">
    <div class="container mt-5">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card shadow">
                    <div class="card-header bg-primary text-white">
                        <h4 class="mb-0"><i class="bx bx-envelope"></i> Email Verification Setup</h4>
                    </div>
                    <div class="card-body">
                        <?php
                        echo "<h5>Setting up Email Verification...</h5>";
                        
                        // Create the email verification table
                        $result = createEmailVerificationTable();
                        
                        if ($result) {
                            echo "<div class='alert alert-success'>";
                            echo "<i class='bx bx-check-circle'></i> Email verification table created successfully!";
                            echo "</div>";
                            
                            // Test database connection
                            global $conn;
                            if ($conn) {
                                echo "<div class='alert alert-info'>";
                                echo "<i class='bx bx-info-circle'></i> Database connection: <strong>OK</strong>";
                                echo "</div>";
                                
                                // Check if SMTP settings exist
                                try {
                                    require_once __DIR__ . '/../config/fast_email_service.php';
                                    $emailSettings = getEmailSettings();
                                    
                                    if ($emailSettings && !empty($emailSettings['smtp_host'])) {
                                        echo "<div class='alert alert-success'>";
                                        echo "<i class='bx bx-check-circle'></i> SMTP settings: <strong>Configured</strong>";
                                        echo "<br><small>Host: " . htmlspecialchars($emailSettings['smtp_host']) . "</small>";
                                        echo "</div>";
                                    } else {
                                        echo "<div class='alert alert-warning'>";
                                        echo "<i class='bx bx-error-circle'></i> SMTP settings: <strong>Not configured</strong>";
                                        echo "<br><small>Please configure SMTP settings in admin panel</small>";
                                        echo "</div>";
                                    }
                                } catch (Exception $e) {
                                    echo "<div class='alert alert-warning'>";
                                    echo "<i class='bx bx-error-circle'></i> Could not check SMTP settings";
                                    echo "</div>";
                                }
                                
                            } else {
                                echo "<div class='alert alert-danger'>";
                                echo "<i class='bx bx-error-circle'></i> Database connection: <strong>Failed</strong>";
                                echo "</div>";
                            }
                            
                        } else {
                            echo "<div class='alert alert-danger'>";
                            echo "<i class='bx bx-x-circle'></i> Failed to create email verification table. Please check database connection.";
                            echo "</div>";
                        }
                        ?>
                        
                        <hr>
                        
                        <h5>Email Verification Features</h5>
                        <ul class="list-group list-group-flush">
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <span><i class="bx bx-check text-success"></i> Secure email verification during registration</span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <span><i class="bx bx-check text-success"></i> 10-minute verification token expiry (enhanced security)</span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <span><i class="bx bx-check text-success"></i> Automatic account creation after verification</span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <span><i class="bx bx-check text-success"></i> Resend verification email functionality</span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <span><i class="bx bx-check text-success"></i> Beautiful HTML email templates</span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <span><i class="bx bx-check text-success"></i> Integration with existing SMTP service</span>
                            </li>
                        </ul>
                        
                        <hr>
                        
                        <h5>Next Steps</h5>
                        <ol>
                            <li><strong>Configure SMTP Settings:</strong> Go to Admin Panel > Email Settings and configure your SMTP server</li>
                            <li><strong>Test Registration:</strong> Try registering a new account at <a href="/auth/register.php">/auth/register.php</a></li>
                            <li><strong>Check Email:</strong> Verify that verification emails are being sent</li>
                            <li><strong>Test Verification:</strong> Click the verification link in the email</li>
                        </ol>
                        
                        <div class="mt-4 text-center">
                            <a href="/auth/register.php" class="btn btn-primary">
                                <i class="bx bx-user-plus"></i> Test Registration
                            </a>
                            <a href="/admin/dashboard.php" class="btn btn-outline-secondary ms-2">
                                <i class="bx bx-cog"></i> Admin Panel
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
