<?php
/**
 * Email Sending Test Tool - Panadite Academy
 * Debug and test email configuration
 */

require_once __DIR__ . '/../config/fast_email_service.php';

// Handle form submission
$testResult = null;
if ($_POST && isset($_POST['test_email'])) {
    $testEmail = filter_var($_POST['test_email'], FILTER_VALIDATE_EMAIL);
    if ($testEmail) {
        $testResult = sendEmailNow($testEmail, 'Test Email - Panadite Academy', 
            '<div style="padding:20px;font-family:Arial;background:#f8f9fa;border-radius:8px;">
                <h2 style="color:#007bff;">🎉 Email Test Successful!</h2>
                <p>Your email configuration is working correctly.</p>
                <p><strong>Time sent:</strong> ' . date('Y-m-d H:i:s') . '</p>
            </div>'
        );
    }
}

$settings = getEmailSettings();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Email Sending Test - Panadite Academy</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">
</head>
<body class="bg-light">
    <div class="container mt-5">
        <div class="row justify-content-center">
            <div class="col-md-10">
                <div class="card shadow">
                    <div class="card-header bg-warning text-dark">
                        <h4 class="mb-0"><i class="bx bx-envelope-open"></i> Email Configuration Test</h4>
                    </div>
                    <div class="card-body">
                        
                        <!-- Current Email Settings -->
                        <div class="row">
                            <div class="col-md-6">
                                <h5><i class="bx bx-cog"></i> Current Email Configuration</h5>
                                <div class="table-responsive">
                                    <table class="table table-sm table-bordered">
                                        <tr>
                                            <td><strong>SMTP Enabled</strong></td>
                                            <td>
                                                <?php if ($settings['smtp_enabled'] === '1'): ?>
                                                    <span class="badge bg-success"><i class="bx bx-check"></i> Yes</span>
                                                <?php else: ?>
                                                    <span class="badge bg-danger"><i class="bx bx-x"></i> No (Using Native Mail)</span>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td><strong>SMTP Host</strong></td>
                                            <td><?php echo htmlspecialchars($settings['smtp_host'] ?: 'Not configured'); ?></td>
                                        </tr>
                                        <tr>
                                            <td><strong>SMTP Port</strong></td>
                                            <td><?php echo htmlspecialchars($settings['smtp_port'] ?: 'Not set'); ?></td>
                                        </tr>
                                        <tr>
                                            <td><strong>Encryption</strong></td>
                                            <td><?php echo htmlspecialchars($settings['smtp_encryption'] ?: 'None'); ?></td>
                                        </tr>
                                        <tr>
                                            <td><strong>Username</strong></td>
                                            <td><?php echo htmlspecialchars($settings['smtp_username'] ? 'Configured' : 'Not set'); ?></td>
                                        </tr>
                                        <tr>
                                            <td><strong>From Email</strong></td>
                                            <td><?php echo htmlspecialchars($settings['from_email'] ?: 'Not set'); ?></td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <h5><i class="bx bx-test-tube"></i> Send Test Email</h5>
                                
                                <?php if ($testResult !== null): ?>
                                    <?php if ($testResult['success']): ?>
                                        <div class="alert alert-success">
                                            <i class="bx bx-check-circle"></i> <strong>Success!</strong> Test email sent successfully.
                                            Check your inbox (including spam folder).
                                        </div>
                                    <?php else: ?>
                                        <div class="alert alert-danger">
                                            <i class="bx bx-error-circle"></i> <strong>Failed!</strong> 
                                            <?php echo htmlspecialchars($testResult['error'] ?: 'Unknown error occurred'); ?>
                                        </div>
                                    <?php endif; ?>
                                <?php endif; ?>
                                
                                <form method="POST" action="">
                                    <div class="mb-3">
                                        <label for="test_email" class="form-label">Test Email Address</label>
                                        <input type="email" class="form-control" id="test_email" name="test_email" 
                                               placeholder="Enter email to test" required 
                                               value="<?php echo htmlspecialchars($_POST['test_email'] ?? ''); ?>">
                                    </div>
                                    <button type="submit" class="btn btn-warning">
                                        <i class="bx bx-send"></i> Send Test Email
                                    </button>
                                </form>
                            </div>
                        </div>
                        
                        <hr>
                        
                        <!-- Configuration Status -->
                        <h5><i class="bx bx-info-circle"></i> Configuration Status</h5>
                        
                        <?php if ($settings['smtp_enabled'] !== '1'): ?>
                            <div class="alert alert-warning">
                                <h6><i class="bx bx-error-circle"></i> SMTP Not Configured</h6>
                                <p>Your system is using PHP's native mail() function. This may not work reliably on all servers.</p>
                                <p><strong>Recommendation:</strong> Configure SMTP settings for better email delivery.</p>
                            </div>
                        <?php elseif (empty($settings['smtp_host']) || empty($settings['smtp_username'])): ?>
                            <div class="alert alert-danger">
                                <h6><i class="bx bx-x-circle"></i> SMTP Incomplete Configuration</h6>
                                <p>SMTP is enabled but missing required settings:</p>
                                <ul class="mb-2">
                                    <?php if (empty($settings['smtp_host'])): ?>
                                        <li>SMTP Host not configured</li>
                                    <?php endif; ?>
                                    <?php if (empty($settings['smtp_username'])): ?>
                                        <li>SMTP Username not configured</li>
                                    <?php endif; ?>
                                    <?php if (empty($settings['smtp_password'])): ?>
                                        <li>SMTP Password not configured</li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        <?php else: ?>
                            <div class="alert alert-success">
                                <h6><i class="bx bx-check-circle"></i> SMTP Configuration Complete</h6>
                                <p>All required SMTP settings are configured. Test email sending above.</p>
                            </div>
                        <?php endif; ?>
                        
                        <!-- Common SMTP Settings Examples -->
                        <div class="mt-4">
                            <h5><i class="bx bx-help-circle"></i> Common SMTP Settings</h5>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="card">
                                        <div class="card-header bg-primary text-white">
                                            <h6 class="mb-0">Gmail SMTP</h6>
                                        </div>
                                        <div class="card-body small">
                                            <strong>Host:</strong> smtp.gmail.com<br>
                                            <strong>Port:</strong> 587 (TLS) or 465 (SSL)<br>
                                            <strong>Encryption:</strong> TLS or SSL<br>
                                            <strong>Auth:</strong> Required<br>
                                            <em>Note: Use App Passwords for 2FA accounts</em>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="card">
                                        <div class="card-header bg-info text-white">
                                            <h6 class="mb-0">Outlook/Hotmail SMTP</h6>
                                        </div>
                                        <div class="card-body small">
                                            <strong>Host:</strong> smtp-mail.outlook.com<br>
                                            <strong>Port:</strong> 587<br>
                                            <strong>Encryption:</strong> TLS<br>
                                            <strong>Auth:</strong> Required<br>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Next Steps -->
                        <div class="mt-4">
                            <h5><i class="bx bx-list-check"></i> Next Steps</h5>
                            <ol>
                                <li><strong>Configure SMTP:</strong> Go to Admin Panel → Email Settings</li>
                                <li><strong>Test Email:</strong> Use the form above to verify email sending</li>
                                <li><strong>Try Registration:</strong> Test email verification registration</li>
                                <li><strong>Check Logs:</strong> Review server logs for detailed error messages</li>
                            </ol>
                        </div>
                        
                        <div class="mt-4 text-center">
                            <a href="/admin/dashboard.php" class="btn btn-primary">
                                <i class="bx bx-cog"></i> Configure SMTP Settings
                            </a>
                            <a href="/auth/register.php" class="btn btn-success ms-2">
                                <i class="bx bx-user-plus"></i> Test Registration
                            </a>
                            <a href="setup_email_verification.php" class="btn btn-outline-secondary ms-2">
                                <i class="bx bx-arrow-back"></i> Back to Setup
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
