<?php
/**
 * Verification Email Direct Test - Panadite Academy
 * Test the exact same email function used in registration
 */

require_once __DIR__ . '/../config/email_verification_service.php';

// Handle form submission
$testResult = null;
if ($_POST && isset($_POST['test_email'])) {
    $testEmail = filter_var($_POST['test_email'], FILTER_VALIDATE_EMAIL);
    $firstName = $_POST['first_name'] ?? 'Test';
    $lastName = $_POST['last_name'] ?? 'User';
    
    if ($testEmail) {
        // Generate a test token
        $testToken = generateVerificationToken();
        
        // Call the exact same function used in registration
        $testResult = sendVerificationEmail($testEmail, $firstName, $lastName, $testToken);
        
        // Also log what we're testing
        error_log("DIRECT TEST: Testing verification email to $testEmail with token $testToken");
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Verification Email Test - Panadite Academy</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">
</head>
<body class="bg-light">
    <div class="container mt-5">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card shadow">
                    <div class="card-header bg-info text-white">
                        <h4 class="mb-0"><i class="bx bx-envelope-check"></i> Verification Email Direct Test</h4>
                    </div>
                    <div class="card-body">
                        
                        <div class="alert alert-warning">
                            <h6><i class="bx bx-info-circle"></i> What This Test Does:</h6>
                            <ul class="mb-0">
                                <li>Tests the <strong>exact same</strong> email function used in registration</li>
                                <li>Generates a real verification token</li>
                                <li>Creates the same email content and headers</li>
                                <li>Shows detailed debug information</li>
                            </ul>
                        </div>
                        
                        <?php if ($testResult !== null): ?>
                            <?php if ($testResult['success']): ?>
                                <div class="alert alert-success">
                                    <h6><i class="bx bx-check-circle"></i> Verification Email Test Result: SUCCESS!</h6>
                                    <p class="mb-2"><strong>Message:</strong> <?php echo htmlspecialchars($testResult['message']); ?></p>
                                    <hr>
                                    <h6><i class="bx bx-search"></i> Check These Places:</h6>
                                    <ol>
                                        <li><strong>Primary Inbox:</strong> Check your main email folder</li>
                                        <li><strong>Spam/Junk Folder:</strong> Verification emails often get filtered</li>
                                        <li><strong>Promotions Tab:</strong> (Gmail) Check the Promotions tab</li>
                                        <li><strong>Quarantine:</strong> Some email providers quarantine HTML emails</li>
                                    </ol>
                                    <div class="mt-3 p-3 bg-light rounded">
                                        <small><strong>Debug Info:</strong> Check your server error logs for detailed debugging information about the email sending process.</small>
                                    </div>
                                </div>
                            <?php else: ?>
                                <div class="alert alert-danger">
                                    <h6><i class="bx bx-error-circle"></i> Verification Email Test Result: FAILED!</h6>
                                    <p><strong>Error:</strong> <?php echo htmlspecialchars($testResult['message'] ?? 'Unknown error'); ?></p>
                                </div>
                            <?php endif; ?>
                        <?php endif; ?>
                        
                        <form method="POST" action="">
                            <div class="mb-3">
                                <label for="test_email" class="form-label">Email Address to Test</label>
                                <input type="email" class="form-control" id="test_email" name="test_email" 
                                       placeholder="Enter your email address" required 
                                       value="<?php echo htmlspecialchars($_POST['test_email'] ?? ''); ?>">
                                <div class="form-text">Use the same email you tried in registration</div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="first_name" class="form-label">First Name</label>
                                        <input type="text" class="form-control" id="first_name" name="first_name" 
                                               placeholder="First Name" value="<?php echo htmlspecialchars($_POST['first_name'] ?? 'Test'); ?>">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="last_name" class="form-label">Last Name</label>
                                        <input type="text" class="form-control" id="last_name" name="last_name" 
                                               placeholder="Last Name" value="<?php echo htmlspecialchars($_POST['last_name'] ?? 'User'); ?>">
                                    </div>
                                </div>
                            </div>
                            
                            <button type="submit" class="btn btn-info">
                                <i class="bx bx-send"></i> Send Test Verification Email
                            </button>
                        </form>
                        
                        <hr>
                        
                        <h5><i class="bx bx-help-circle"></i> Troubleshooting Tips</h5>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="card">
                                    <div class="card-header bg-warning text-dark">
                                        <h6 class="mb-0">If Test Shows SUCCESS but No Email:</h6>
                                    </div>
                                    <div class="card-body small">
                                        <ol>
                                            <li><strong>Check Spam Folder:</strong> Verification emails often get filtered</li>
                                            <li><strong>Check All Email Tabs:</strong> Gmail has Promotions, Social tabs</li>
                                            <li><strong>Wait 5-10 minutes:</strong> Some servers have delays</li>
                                            <li><strong>Try Different Email:</strong> Some providers block automated emails</li>
                                        </ol>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="card">
                                    <div class="card-header bg-danger text-white">
                                        <h6 class="mb-0">If Test Shows FAILED:</h6>
                                    </div>
                                    <div class="card-body small">
                                        <ol>
                                            <li><strong>SMTP Settings:</strong> Check configuration in admin panel</li>
                                            <li><strong>Email Service:</strong> Verify credentials are correct</li>
                                            <li><strong>Server Logs:</strong> Check error_log for detailed errors</li>
                                            <li><strong>Firewall:</strong> Ensure SMTP ports are not blocked</li>
                                        </ol>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="mt-4">
                            <h6><i class="bx bx-shield-check"></i> Email Provider Specific Tips:</h6>
                            <ul class="small">
                                <li><strong>Gmail:</strong> Check Promotions tab, enable "less secure app access" or use app passwords</li>
                                <li><strong>Outlook/Hotmail:</strong> Check Junk folder, whitelist sender domain</li>
                                <li><strong>Yahoo:</strong> Check Bulk/Spam folder, verify sender reputation</li>
                                <li><strong>Corporate Email:</strong> Contact IT - may block external SMTP</li>
                            </ul>
                        </div>
                        
                        <div class="mt-4 text-center">
                            <a href="test_email_sending.php" class="btn btn-warning">
                                <i class="bx bx-test-tube"></i> Basic Email Test
                            </a>
                            <a href="/auth/register.php" class="btn btn-success ms-2">
                                <i class="bx bx-user-plus"></i> Try Registration Again
                            </a>
                            <a href="/admin/dashboard.php" class="btn btn-primary ms-2">
                                <i class="bx bx-cog"></i> Email Settings
                            </a>
                        </div>
                        
                        <div class="mt-4 p-3 bg-light rounded">
                            <h6><i class="bx bx-code"></i> Debug Information:</h6>
                            <p class="small mb-0">
                                <strong>Server:</strong> <?php echo $_SERVER['HTTP_HOST']; ?><br>
                                <strong>Current Time:</strong> <?php echo date('Y-m-d H:i:s'); ?><br>
                                <strong>PHP Error Logs:</strong> Check your server's error_log file for detailed debugging
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
