<?php
/**
 * Update Users Table for Email Verification - Panadite Academy
 * Adds email_verified_at column to users table
 */

require_once __DIR__ . '/../config/db_connect.php';

// Set content type
header('Content-Type: text/html; charset=UTF-8');

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Database Update - Panadite Academy</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">
</head>
<body class="bg-light">
    <div class="container mt-5">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card shadow">
                    <div class="card-header bg-success text-white">
                        <h4 class="mb-0"><i class="bx bx-data"></i> Database Update for Email Verification</h4>
                    </div>
                    <div class="card-body">
                        <?php
                        global $conn;
                        
                        if (!$conn) {
                            echo "<div class='alert alert-danger'>";
                            echo "<i class='bx bx-error-circle'></i> Database connection failed. Please check your configuration.";
                            echo "</div>";
                            exit;
                        }
                        
                        echo "<h5>Updating Users Table...</h5>";
                        
                        // Check if column already exists
                        $checkColumn = $conn->query("SHOW COLUMNS FROM users LIKE 'email_verified_at'");
                        
                        if ($checkColumn->num_rows > 0) {
                            echo "<div class='alert alert-info'>";
                            echo "<i class='bx bx-info-circle'></i> Column 'email_verified_at' already exists in users table.";
                            echo "</div>";
                        } else {
                            // Add the column
                            $addColumn = $conn->query("ALTER TABLE users ADD COLUMN email_verified_at DATETIME NULL AFTER user_role");
                            
                            if ($addColumn) {
                                echo "<div class='alert alert-success'>";
                                echo "<i class='bx bx-check-circle'></i> Successfully added 'email_verified_at' column to users table!";
                                echo "</div>";
                                
                                // Set existing users as verified (optional - for existing users)
                                $updateExisting = $conn->query("UPDATE users SET email_verified_at = created_at WHERE email_verified_at IS NULL");
                                
                                if ($updateExisting) {
                                    echo "<div class='alert alert-info'>";
                                    echo "<i class='bx bx-info-circle'></i> Marked existing users as email verified.";
                                    echo "</div>";
                                }
                                
                            } else {
                                echo "<div class='alert alert-danger'>";
                                echo "<i class='bx bx-error-circle'></i> Failed to add column: " . $conn->error;
                                echo "</div>";
                            }
                        }
                        
                        // Show current table structure
                        echo "<h5 class='mt-4'>Current Users Table Structure:</h5>";
                        $showColumns = $conn->query("SHOW COLUMNS FROM users");
                        
                        if ($showColumns) {
                            echo "<div class='table-responsive'>";
                            echo "<table class='table table-sm table-bordered'>";
                            echo "<thead class='table-dark'>";
                            echo "<tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr>";
                            echo "</thead>";
                            echo "<tbody>";
                            
                            while ($column = $showColumns->fetch_assoc()) {
                                echo "<tr>";
                                echo "<td><strong>" . htmlspecialchars($column['Field']) . "</strong></td>";
                                echo "<td>" . htmlspecialchars($column['Type']) . "</td>";
                                echo "<td>" . htmlspecialchars($column['Null']) . "</td>";
                                echo "<td>" . htmlspecialchars($column['Key']) . "</td>";
                                echo "<td>" . htmlspecialchars($column['Default'] ?? 'NULL') . "</td>";
                                echo "<td>" . htmlspecialchars($column['Extra']) . "</td>";
                                echo "</tr>";
                            }
                            
                            echo "</tbody>";
                            echo "</table>";
                            echo "</div>";
                        }
                        ?>
                        
                        <hr>
                        
                        <h5>What This Update Does:</h5>
                        <ul class="list-group list-group-flush">
                            <li class="list-group-item">
                                <i class="bx bx-check text-success"></i> 
                                Adds <code>email_verified_at</code> column to track when users verify their emails
                            </li>
                            <li class="list-group-item">
                                <i class="bx bx-check text-success"></i> 
                                Allows NULL values for unverified users
                            </li>
                            <li class="list-group-item">
                                <i class="bx bx-check text-success"></i> 
                                Sets existing users as verified (preserves current functionality)
                            </li>
                            <li class="list-group-item">
                                <i class="bx bx-check text-success"></i> 
                                Enables tracking of verification timestamps
                            </li>
                        </ul>
                        
                        <div class="mt-4 text-center">
                            <a href="setup_email_verification.php" class="btn btn-primary">
                                <i class="bx bx-envelope"></i> Continue to Email Verification Setup
                            </a>
                            <a href="/admin/dashboard.php" class="btn btn-outline-secondary ms-2">
                                <i class="bx bx-dashboard"></i> Go to Admin Panel
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
