-- AI Grading System Database Upgrade
-- Generated: 2025-07-22 12:41:02
-- BACKUP YOUR DATABASE BEFORE RUNNING THIS SCRIPT!

-- Upgrading table: assignment_submissions
ALTER TABLE `assignment_submissions`
ADD COLUMN `extracted_text` LONGTEXT,
ADD COLUMN `ai_score` DECIMAL(5,2),
ADD COLUMN `ai_feedback` LONGTEXT,
ADD COLUMN `similarity_score` DECIMAL(5,2),
ADD COLUMN `plagiarism_score` DECIMAL(5,2),
ADD COLUMN `keyword_match_score` DECIMAL(5,2),
ADD COLUMN `structure_score` DECIMAL(5,2),
ADD COLUMN `quality_score` DECIMAL(5,2),
ADD COLUMN `processing_status` ENUM("pending","processing","completed","failed") DEFAULT "pending",
ADD COLUMN `processing_time` DECIMAL(8,2),
ADD COLUMN `review_needed` TINYINT(1) DEFAULT 0,
ADD COLUMN `ai_confidence` DECIMAL(5,2);

-- Upgrading table: assignments
ALTER TABLE `assignments`
ADD COLUMN `memorandum_content` LONGTEXT,
ADD COLUMN `memorandum_file_path` VARCHAR(500),
ADD COLUMN `memorandum_key_points` LONGTEXT JSON,
ADD COLUMN `ai_grading_enabled` TINYINT(1) DEFAULT 1,
ADD COLUMN `pass_mark` DECIMAL(5,2) DEFAULT 50.00,
ADD COLUMN `max_attempts` INT DEFAULT 3,
ADD COLUMN `auto_feedback` TINYINT(1) DEFAULT 1,
ADD COLUMN `plagiarism_check` TINYINT(1) DEFAULT 1;

-- Upgrading table: certificates
ALTER TABLE `certificates`
ADD COLUMN `verification_code` VARCHAR(50) UNIQUE,
ADD COLUMN `qr_code_path` VARCHAR(500),
ADD COLUMN `pdf_path` VARCHAR(500),
ADD COLUMN `final_score` DECIMAL(5,2),
ADD COLUMN `completion_date` DATETIME,
ADD COLUMN `certificate_data` LONGTEXT JSON;

-- Upgrading table: course_videos
ALTER TABLE `course_videos`
ADD COLUMN `min_watch_percentage` DECIMAL(5,2) DEFAULT 80.00,
ADD COLUMN `skip_prevention` TINYINT(1) DEFAULT 1,
ADD COLUMN `transcript` LONGTEXT,
ADD COLUMN `key_moments` LONGTEXT JSON;

-- Upgrading table: quizzes
ALTER TABLE `quizzes`
ADD COLUMN `answer_key` LONGTEXT JSON,
ADD COLUMN `ai_grading_enabled` TINYINT(1) DEFAULT 1,
ADD COLUMN `essay_questions` LONGTEXT JSON,
ADD COLUMN `auto_grade_mcq` TINYINT(1) DEFAULT 1,
ADD COLUMN `feedback_enabled` TINYINT(1) DEFAULT 1;

-- Upgrading table: student_progress
ALTER TABLE `student_progress`
ADD COLUMN `video_progress_percent` DECIMAL(5,2) DEFAULT 0.00,
ADD COLUMN `assignment_progress_percent` DECIMAL(5,2) DEFAULT 0.00,
ADD COLUMN `quiz_progress_percent` DECIMAL(5,2) DEFAULT 0.00,
ADD COLUMN `overall_progress_percent` DECIMAL(5,2) DEFAULT 0.00,
ADD COLUMN `video_weight` DECIMAL(3,2) DEFAULT 0.30,
ADD COLUMN `assignment_weight` DECIMAL(3,2) DEFAULT 0.50,
ADD COLUMN `quiz_weight` DECIMAL(3,2) DEFAULT 0.20,
ADD COLUMN `completion_criteria_met` TINYINT(1) DEFAULT 0,
ADD COLUMN `certificate_eligible` TINYINT(1) DEFAULT 0,
ADD COLUMN `last_activity` DATETIME;

-- Upgrading table: videos
ALTER TABLE `videos`
ADD COLUMN `min_watch_percentage` DECIMAL(5,2) DEFAULT 80.00,
ADD COLUMN `skip_prevention` TINYINT(1) DEFAULT 1,
ADD COLUMN `transcript` LONGTEXT,
ADD COLUMN `key_moments` LONGTEXT JSON;

-- Create indexes for better performance
CREATE INDEX idx_assignment_submissions_ai_score ON `assignment_submissions` (ai_score);
CREATE INDEX idx_assignment_submissions_processing_status ON `assignment_submissions` (processing_status);
CREATE INDEX idx_student_progress_completion ON `student_progress` (completion_criteria_met);
CREATE INDEX idx_student_progress_certificate_eligible ON `student_progress` (certificate_eligible);

-- Script completed successfully!
