<?php
/**
 * Add to Cart API Endpoint - Simplified Test Version
 */

header('Content-Type: application/json');

// Initialize response
$response = [
    'success' => false,
    'message' => '',
    'cart_count' => 0,
    'course_data' => null
];

try {
    // Get JSON input
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!$input || !isset($input['course_id'])) {
        throw new Exception('Invalid request data');
    }

    $courseId = intval($input['course_id']);

    if ($courseId <= 0) {
        throw new Exception('Invalid course ID');
    }

    // Connect to database to get real course data
    require_once '../../config/db_connect.php';
    
    if (!isset($conn)) {
        throw new Exception('Database connection failed');
    }

    // Get real course details from database
    $courseQuery = "
        SELECT c.course_id, c.title, c.description, c.thumbnail, c.price, c.teacher_id,
               u.first_name, u.last_name
        FROM courses c
        LEFT JOIN users u ON c.teacher_id = u.user_id
        WHERE c.course_id = ?
    ";
    
    $stmt = $conn->prepare($courseQuery);
    if (!$stmt) {
        throw new Exception('Database prepare failed');
    }
    
    $stmt->bind_param('i', $courseId);
    $stmt->execute();
    $courseResult = $stmt->get_result();
    
    if ($courseResult->num_rows === 0) {
        throw new Exception('Course not found');
    }
    
    $course = $courseResult->fetch_assoc();

    // Prepare real course data for cart
    $courseData = [
        'id' => $course['course_id'],
        'title' => $course['title'],
        'description' => $course['description'] ?: 'Course description not available',
        'thumbnail' => $course['thumbnail'] ?: '/uploads/thumbnails/default-course.jpg',
        'price' => floatval($course['price']),
        'instructor' => trim($course['first_name'] . ' ' . $course['last_name']) ?: 'Panadite Academy',
        'students' => 25, // Default value - can be improved later
        'rating' => '4.5',
        'reviews' => '10',
        'added_date' => date('Y-m-d H:i:s')
    ];

    // Success response
    $response['success'] = true;
    $response['message'] = $course['title'] . ' added to cart successfully!';
    $response['course_data'] = $courseData;
    
    // Clean up
    $stmt->close();
    
} catch (Exception $e) {
    $response['success'] = false;
    $response['message'] = $e->getMessage();
}

// Return clean JSON response
echo json_encode($response);
exit;
?>
